/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.ChatProtoNavTool;
import component.Tools;
import flap.FLAPSock;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import main.CallbackData;
import main.ChatExchange;
import main.ChatNavAPI;
import main.ChatNavCoreAPI;
import main.ChatRoom;
import main.ChatRoomDesc;
import main.ChatRoomID;
import main.ClientDispatcher;
import main.Oscar;
import main.SnacConnectionHandler;
import snac.ChatExchangeDesc;
import snac.ChatListener;
import snac.ChatNavHandler;
import snac.ChatNavListener;
import snac.ReqID;
import snac.ServiceHandler;
import snac.ServiceListener;
import snac.SnacConstants;
import snac.SnacIcbmCookie;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.SnacTlvBlock;
import snac.SnacVersion;
import snac.TLV;
import uiutil.ErrorMgr;
import util.JUtil;
import util.Log;

public class ChatNavCore
extends SnacConnectionHandler
implements ChatNavCoreAPI,
SnacConstants,
ChatNavListener,
ServiceListener,
ChatListener {
    private static String MODULE = "ChatNavCore";
    private ChatNavAPI chatNavTool;
    private ClientDispatcher dispatcher;
    private FLAPSock navServer = null;
    private int[] families;
    private Vector familyVersions;

    public ChatNavCore(ClientDispatcher clientDispatcher, Tools tools) {
        this.dispatcher = clientDispatcher;
        Log.log(MODULE, Log.DEBUG, "registering listeners...");
        clientDispatcher.registerListener(1, 2, this);
        clientDispatcher.registerListener(14, 1, this);
        Log.log(MODULE, Log.DEBUG, "creating ChatProtoNavTool...");
        this.chatNavTool = new ChatProtoNavTool(this, tools);
    }

    private TLV getChatRoomDescriptionAsTlv(ChatRoom chatRoom) {
        TLV tLV = new TLV();
        String string = chatRoom.getName();
        if (string != null) {
            tLV.addTlv(211, string);
        }
        return tLV;
    }

    private int[] getFamilies() {
        if (this.families == null) {
            this.families = new int[2];
            this.families[0] = 1;
            this.families[1] = 13;
        }
        return this.families;
    }

    private Vector getFamilyVersions() {
        if (this.familyVersions == null) {
            this.familyVersions = new Vector();
            this.familyVersions.addElement(new SnacVersion(1, 2, 1, Oscar.buildNumber));
            this.familyVersions.addElement(new SnacVersion(13, 1, this.chatNavTool.id(), this.chatNavTool.version()));
        }
        return this.familyVersions;
    }

    private boolean notANavServer(FLAPSock fLAPSock) {
        return fLAPSock != this.navServer;
    }

    public int chatNavNavInfo(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        if (this.notANavServer(fLAPSock)) {
            return 0;
        }
        Log.log(MODULE, Log.DEBUG, "chatNavNavInfo");
        CallbackData callbackData = (CallbackData)object;
        if (callbackData.subType == 2) {
            Object object2;
            ChatExchange[] chatExchangeArray;
            byte by = 0;
            Vector<ChatExchange> vector = new Vector<ChatExchange>();
            Enumeration enumeration = tLV.elements();
            while (enumeration.hasMoreElements()) {
                SnacTlv snacTlv = (SnacTlv)enumeration.nextElement();
                if (snacTlv.type == 2) {
                    by = snacTlv.data[0];
                    continue;
                }
                if (snacTlv.type != 3) continue;
                chatExchangeArray = new ByteArrayInputStream(snacTlv.data);
                object2 = new DataInputStream((InputStream)chatExchangeArray);
                try {
                    ChatExchangeDesc chatExchangeDesc = new ChatExchangeDesc((DataInputStream)object2);
                    vector.addElement(new ChatExchange(chatExchangeDesc));
                }
                catch (IOException iOException) {
                    ErrorMgr.warn(MODULE, "Error reading chat exchange description. Description skipped.");
                }
            }
            chatExchangeArray = new ChatExchange[vector.size()];
            object2 = vector.elements();
            int n2 = 0;
            while (object2.hasMoreElements()) {
                chatExchangeArray[n2++] = (ChatExchange)object2.nextElement();
            }
            this.chatNavTool.setChatRights(callbackData.data, by, chatExchangeArray);
        } else if (callbackData.subType == 8) {
            if (tLV.tlvTypePresent(4)) {
                ChatRoom chatRoom;
                byte[] byArray = tLV.getTlvData(4);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    snac.ChatRoomDesc chatRoomDesc = new snac.ChatRoomDesc(dataInputStream);
                    chatRoom = new ChatRoom(chatRoomDesc);
                }
                catch (IOException iOException) {
                    ErrorMgr.warn(MODULE, "Error reading chat room description for CHAT_NAV_NAV_INFO. Message dropped.");
                    return 1;
                }
                this.chatNavTool.roomCreated(callbackData.data, chatRoom);
            } else {
                ErrorMgr.warn(MODULE, "Missing CHAT_RESPONSES_ROOM_DESC tag for CHAT_NAV_NAV_INFO response to CREATE_ROOM.");
            }
        } else if (callbackData.subType == 3) {
            Object object3;
            ChatRoom[] chatRoomArray;
            ChatExchange chatExchange = null;
            Vector<ChatRoom> vector = new Vector<ChatRoom>();
            Enumeration enumeration = tLV.elements();
            while (enumeration.hasMoreElements()) {
                Object object4;
                SnacTlv snacTlv = (SnacTlv)enumeration.nextElement();
                if (snacTlv.type == 3) {
                    chatRoomArray = new ByteArrayInputStream(snacTlv.data);
                    object3 = new DataInputStream((InputStream)chatRoomArray);
                    try {
                        object4 = new ChatExchangeDesc((DataInputStream)object3);
                        chatExchange = new ChatExchange((ChatExchangeDesc)object4);
                    }
                    catch (IOException iOException) {
                        ErrorMgr.warn(MODULE, "Error reading chat exchange description. Description skipped.");
                    }
                    continue;
                }
                if (snacTlv.type != 4) continue;
                chatRoomArray = (ChatRoom[])tLV.getTlvData(4);
                object3 = new ByteArrayInputStream((byte[])chatRoomArray);
                object4 = new DataInputStream((InputStream)object3);
                try {
                    snac.ChatRoomDesc chatRoomDesc = new snac.ChatRoomDesc((DataInputStream)object4);
                    vector.addElement(new ChatRoom(chatRoomDesc));
                }
                catch (IOException iOException) {
                    ErrorMgr.warn(MODULE, "Error reading chat room description for CHAT_NAV_NAV_INFO. Description skipped.");
                }
            }
            chatRoomArray = new ChatRoom[vector.size()];
            object3 = vector.elements();
            int n3 = 0;
            while (object3.hasMoreElements()) {
                chatRoomArray[n3++] = (ChatRoom)object3.nextElement();
            }
            this.chatNavTool.setExchangeInfo(callbackData.data, chatExchange, chatRoomArray);
        } else {
            ErrorMgr.warn(MODULE, "Unrecognized chat nav request " + callbackData.subType);
        }
        return 1;
    }

    public String toString() {
        return MODULE;
    }

    public void requestTimedOut(Object object) {
        if (object == null) {
            return;
        }
        CallbackData callbackData = (CallbackData)object;
        if (callbackData.responseExpected) {
            this.warn(object, "The chat server is not responding", null);
        }
    }

    public boolean connectionSignOff(FLAPSock fLAPSock, TLV tLV, boolean bl) {
        if (this.notANavServer(fLAPSock)) {
            return false;
        }
        if (this.chatNavTool != null) {
            this.chatNavTool.disconnect();
        }
        return true;
    }

    public boolean connectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n, boolean bl2) {
        if (this.navServer != null) {
            if (this.chatNavTool != null) {
                this.chatNavTool.disconnect();
            }
            fLAPSock = null;
            this.navServer = null;
            return true;
        }
        return false;
    }

    public int snacError(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (this.notANavServer(fLAPSock)) {
            return 0;
        }
        String string = tLV.getTlvDataAsString(4);
        int n3 = -1;
        if (tLV.tlvTypePresent(8)) {
            n3 = tLV.getTlvDataAsU16(8);
        }
        this.warn(object, this.lookup(SnacConnectionHandler.generalErrors, n2), string);
        return 1;
    }

    public void requestConnection() {
        Log.log(MODULE, Log.DEBUG, "requestConnection");
        if (JUtil.isTrue(Oscar.config.getValue("debug.chatnoserver"))) {
            this.chatNavTool.connect();
            this.chatNavTool.setEnabled(true);
            return;
        }
        Oscar.bosCore.requestService(this.chatNavTool, "chatnav", null);
    }

    public void requestChatRights(Object object) {
        Log.log(MODULE, Log.DEBUG, "requestChatRights");
        CallbackData callbackData = new CallbackData(null, false, true, 13, 2, "request chat rights", object);
        ChatNavHandler chatNavHandler = (ChatNavHandler)this.dispatcher.getHandler(13);
        if (JUtil.isTrue(Oscar.config.getValue("debug.chatnoserver"))) {
            this.chatNavTool.setChatRights(object, 0, null);
            return;
        }
        chatNavHandler.requestChatRights(this.navServer, this, callbackData);
    }

    public void requestExchangeInfo(Object object, int n) {
        Log.log(MODULE, Log.DEBUG, "requestExchangeInfo");
        CallbackData callbackData = new CallbackData(null, false, true, 13, 3, "request exchange info", object);
        ChatNavHandler chatNavHandler = (ChatNavHandler)this.dispatcher.getHandler(13);
        chatNavHandler.requestExchangeInfo(this.navServer, this, callbackData, n);
    }

    public void requestRoomInfo() {
    }

    public void requestMoreRoomInfo() {
    }

    public void requestOccupantList() {
    }

    public void searchForRoom() {
    }

    public void createRoom(Object object, ChatRoom chatRoom) {
        byte[] byArray = chatRoom.getCookie();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        snac.ChatRoomID chatRoomID = new snac.ChatRoomID(chatRoom.getExchange(), byArray.length, byArray, -1);
        TLV tLV = this.getChatRoomDescriptionAsTlv(chatRoom);
        snac.ChatRoomDesc chatRoomDesc = new snac.ChatRoomDesc(chatRoomID, chatRoom.getDetailLevel(), new SnacTlvBlock(tLV.size(), tLV));
        CallbackData callbackData = new CallbackData(null, false, true, 13, 8, "create a chat room", object);
        ChatNavHandler chatNavHandler = (ChatNavHandler)this.dispatcher.getHandler(13);
        Log.log(MODULE, Log.DEBUG, "createRoom creating room");
        if (JUtil.isTrue(Oscar.config.getValue("debug.chatnoserver"))) {
            ChatRoomID chatRoomID2 = new ChatRoomID(1, null, 0);
            ChatRoomDesc chatRoomDesc2 = new ChatRoomDesc();
            chatRoomDesc2.setName("Client Test Room");
            this.chatNavTool.roomCreated(object, new ChatRoom(chatRoomID2, 1, chatRoomDesc2, null));
            return;
        }
        chatNavHandler.createRoom(this.navServer, this, callbackData, chatRoomDesc);
    }

    public int serviceHostOnline(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (this.notANavServer(fLAPSock) && this.compareGroups(nArray, this.getFamilies()) > 0) {
            this.navServer = fLAPSock;
            this.chatNavTool.connect();
            Log.log(MODULE, Log.DEBUG, String.valueOf(MODULE) + "serviceHostOnline: " + "sending client online.");
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.clientOnline(fLAPSock, this, null, this.getFamilyVersions());
            this.chatNavTool.setEnabled(true);
            return 1;
        }
        return 0;
    }

    public int serviceServiceResponse(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceRateParamsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector, Vector vector2) {
        return 0;
    }

    public int serviceRateParamChange(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int servicePause(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceResume(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceNickInfoUpdate(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacNicknameWinfo snacNicknameWinfo) {
        return 0;
    }

    public int serviceEvilNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int serviceMigrateGroups(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int[] nArray, TLV tLV) {
        return 0;
    }

    public int serviceMotd(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        return 0;
    }

    public int serviceWellKnownUrls(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceNoop(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        return 1;
    }

    public int chatRoomInfoUpdate(FLAPSock fLAPSock, Object object, ReqID reqID, int n, snac.ChatRoomDesc chatRoomDesc) {
        return 0;
    }

    public int chatUsersJoined(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        return 0;
    }

    public int chatUsersLeft(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        return 0;
    }

    public int chatChannelMsgToclient(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, TLV tLV) {
        return 0;
    }

    public int chatEvilReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int n3) {
        return 0;
    }

    public int chatClientErr(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacIcbmCookie snacIcbmCookie, int n2, SnacNickname snacNickname, int n3, byte[] byArray) {
        return 0;
    }
}

