/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import main.LoginCore;
import main.Oscar;
import uiutil.ACheckbox;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;

public class ConnectionProps
extends PropertySheet
implements ItemListener,
KeyListener,
ActionListener {
    private LoginCore login;
    private ChangeListener changeListener;
    private ACheckbox autoLoginCheck;
    private ACheckbox autoConnectCheck;
    private TextField hostField;
    private TextField portField;
    private Button autoConfButton;
    private String AutoConfLabel = "Auto-Configure";
    private Button defaultsButton;
    private String DefaultsLabel = "Use Defaults";
    private KeyBindings config;
    private boolean changed = false;

    public ConnectionProps(LoginCore loginCore, ChangeListener changeListener) {
        this.login = loginCore;
        this.changeListener = changeListener;
        this.config = Oscar.config.getKeyBindings(LoginCore.LOGIN_KEY);
        if (this.config == null) {
            this.config = Oscar.config.addKeyBindings(LoginCore.LOGIN_KEY);
        }
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("West", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        this.add("Center", transparentPanel);
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add("North", new Label("Connection", 0));
        transparentPanel2.add("West", new Spacer());
        TransparentPanel transparentPanel3 = new TransparentPanel(new GridLayout(3, 1, 0, 0));
        transparentPanel2.add("Center", transparentPanel3);
        this.autoLoginCheck = new ACheckbox("Auto-Login");
        transparentPanel3.add(this.autoLoginCheck);
        this.autoLoginCheck.addItemListener(this);
        this.autoConnectCheck = new ACheckbox("Auto-Connect");
        transparentPanel3.add(this.autoConnectCheck);
        this.autoConnectCheck.addItemListener(this);
        transparentPanel2 = new TransparentPanel(new FlowLayout(0, 0, 0));
        transparentPanel.add(transparentPanel2);
        transparentPanel3 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add(transparentPanel3);
        transparentPanel3.add("North", new Label("Server", 0));
        transparentPanel3.add("West", new Spacer());
        TransparentPanel transparentPanel4 = new TransparentPanel();
        transparentPanel3.add("Center", transparentPanel4);
        TransparentPanel transparentPanel5 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel4.add(transparentPanel5);
        transparentPanel5.add(new Label("Host:", 0));
        transparentPanel5.add(new Label("Port:", 0));
        transparentPanel5 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel4.add(transparentPanel5);
        this.hostField = new TextField("", 14);
        transparentPanel5.add(this.hostField);
        this.hostField.addKeyListener(this);
        this.portField = new TextField("", 14);
        transparentPanel5.add(this.portField);
        this.portField.addKeyListener(this);
        transparentPanel3 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel2.add(transparentPanel3);
        transparentPanel3.add(new Spacer());
        this.defaultsButton = new Button(this.DefaultsLabel);
        transparentPanel3.add(this.defaultsButton);
        this.defaultsButton.addActionListener(this);
        this.autoConfButton = new Button(this.AutoConfLabel);
        transparentPanel3.add(this.autoConfButton);
        this.autoConfButton.addActionListener(this);
        transparentPanel.add(new Spacer());
        if (Oscar.config.getValue("Debug.connection") == null) {
            this.autoConnectCheck.setEnabled(false);
            this.autoConfButton.setEnabled(false);
        }
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.DefaultsLabel)) {
            ((TextComponent)this.hostField).setText(this.getDefaultAuthorizer());
            ((TextComponent)this.portField).setText(this.getDefaultPort());
            this.setChanged(true);
            return;
        }
        string.equals(this.AutoConfLabel);
    }

    public boolean changed() {
        return this.changed;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Connection Setup Help", "This is where you control how to connect to the service. When Auto-Login is enabled, the client will automatically connect to the service when started assuming there is a network connection available. When Auto-Connect is enabled, the client will automatically connect to the service when a network connection becomes available. You must save you name and password for either Auto-Login or Auto-Connect to work. You should not need to set the host and port fields unless you have trouble connecting due to a firewall or other network security. The \"Auto-Configure\" button will automatically determine how to communicate with the service from your network. If \"Auto-Configure\" fails, your network may be using a proxy. In this case, use the \"Proxy\" folder to specify how to connect using your network's proxy server.");
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            Component component = keyEvent.getComponent();
            if (component == this.hostField) {
                this.portField.requestFocus();
            } else if (component == this.portField) {
                this.hostField.requestFocus();
            }
        }
        this.setChanged(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeNotify() {
        this.removeAll();
        this.login = null;
        this.changeListener = null;
        this.autoLoginCheck = null;
        this.autoConnectCheck = null;
        this.hostField = null;
        this.portField = null;
        this.autoConfButton = null;
        this.AutoConfLabel = null;
        this.defaultsButton = null;
        this.DefaultsLabel = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        if (this.autoLoginCheck.getState()) {
            this.config.setValue(LoginCore.AUTO_LOGIN_KEY, "true");
        } else {
            this.config.setValue(LoginCore.AUTO_LOGIN_KEY, "false");
        }
        if (this.autoConnectCheck.getState()) {
            this.config.setValue(LoginCore.AUTO_CONNECT_KEY, "true");
        } else {
            this.config.setValue(LoginCore.AUTO_CONNECT_KEY, "false");
        }
        String string = this.hostField.getText();
        if (string == null || string.length() == 0) {
            string = this.getDefaultAuthorizer();
        }
        this.config.setValue(LoginCore.AUTH_HOST_KEY, string);
        string = this.portField.getText();
        if (!JUtil.isInteger(string)) {
            string = this.getDefaultPort();
            ((TextComponent)this.portField).setText(string);
        }
        this.config.setValue(LoginCore.AUTH_PORT_KEY, string);
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    private String getDefaultAuthorizer() {
        String string = this.config.getValue(LoginCore.DEFAULT_AUTH_HOST_KEY);
        if (string == null || string.length() == 0) {
            string = LoginCore.DEFAULT_AUTHORIZER;
        }
        return string;
    }

    private String getDefaultPort() {
        String string = this.config.getValue(LoginCore.DEFAULT_AUTH_PORT_KEY);
        if (!JUtil.isInteger(string)) {
            string = LoginCore.DEFAULT_PORT;
        }
        return string;
    }

    public void setValues() {
        String string = this.config.getValueDefault(LoginCore.AUTO_LOGIN_KEY, "false");
        this.autoLoginCheck.setState(string.equalsIgnoreCase("true"));
        string = this.config.getValueDefault(LoginCore.AUTO_CONNECT_KEY, "false");
        this.autoConnectCheck.setState(string.equalsIgnoreCase("true"));
        string = this.config.getValue(LoginCore.AUTH_HOST_KEY);
        if (string != null && string.length() > 0) {
            ((TextComponent)this.hostField).setText(string);
        } else {
            ((TextComponent)this.hostField).setText(this.getDefaultAuthorizer());
        }
        string = this.config.getValue(LoginCore.AUTH_PORT_KEY);
        if (JUtil.isInteger(string)) {
            ((TextComponent)this.portField).setText(string);
        } else {
            ((TextComponent)this.portField).setText(this.getDefaultPort());
        }
        this.setChanged(false);
    }
}

