/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.Folders;
import component.SetupUI;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import main.LoginCore;
import main.Oscar;
import uiutil.ACheckbox;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;

public class ProxyProps
extends PropertySheet
implements ItemListener {
    private ACheckbox proxyCheck;
    private List proxyList;
    private Vector proxyNames;
    private boolean changed = false;
    private String proxyTab;
    private KeyBindings config;
    private SetupUI setupUI;

    public ProxyProps(SetupUI setupUI, Vector vector) {
        this.setupUI = setupUI;
        this.proxyNames = vector;
        this.config = Oscar.config.getKeyBindingsOrAdd(LoginCore.LOGIN_KEY);
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer(20));
        this.add("West", new Spacer(30));
        this.add("South", new Spacer(20));
        this.add("East", new Spacer(30));
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        this.add("Center", transparentPanel);
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add(transparentPanel2);
        this.proxyCheck = new ACheckbox("Use a proxy to connect");
        transparentPanel2.add("North", this.proxyCheck);
        this.proxyCheck.addItemListener(this);
        this.proxyList = new List();
        transparentPanel2.add("Center", this.proxyList);
        this.proxyList.addItemListener(this);
        int n = 0;
        while (n < vector.size()) {
            this.proxyList.add((String)vector.elementAt(n));
            ++n;
        }
        this.setValues();
    }

    public boolean changed() {
        return this.changed;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Folders folders = this.setupUI.getFolders(null);
        if (itemEvent.getSource() == this.proxyCheck) {
            int n;
            this.proxyList.setEnabled(this.proxyCheck.getState());
            if (this.proxyTab != null) {
                folders.hideTab(this.proxyTab);
            }
            this.proxyTab = null;
            if (this.proxyCheck.getState() && (n = this.proxyList.getSelectedIndex()) != -1) {
                this.proxyTab = (String)this.proxyNames.elementAt(n);
                folders.showTab(this.proxyTab);
            }
        } else if (itemEvent.getSource() == this.proxyList && itemEvent.getStateChange() == 1) {
            if (this.proxyTab != null) {
                folders.hideTab(this.proxyTab);
            }
            int n = (Integer)itemEvent.getItem();
            this.proxyTab = (String)this.proxyNames.elementAt(n);
            folders.showTab(this.proxyTab);
        }
        this.setChanged(true);
    }

    public boolean help() {
        return false;
    }

    public void removeNotify() {
        this.removeAll();
        this.setupUI = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        if (this.proxyCheck.getState()) {
            int n = this.proxyList.getSelectedIndex();
            if (n == -1) {
                this.config.setValue(LoginCore.USE_PROXY_KEY, "false");
                this.proxyCheck.setState(false);
            } else {
                this.config.setValue(LoginCore.USE_PROXY_KEY, (String)this.proxyNames.elementAt(n));
            }
        } else {
            this.config.setValue(LoginCore.USE_PROXY_KEY, "false");
        }
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.setupUI.setChanged(true);
        }
    }

    public void setValues() {
        String string = this.config.getValueDefault(LoginCore.USE_PROXY_KEY, "false");
        if (JUtil.isFalse(string)) {
            this.proxyCheck.setState(false);
            this.proxyList.setEnabled(false);
        } else {
            int n = 0;
            while (n < this.proxyNames.size()) {
                String string2 = (String)this.proxyNames.elementAt(n);
                if (string.equals(string2)) {
                    this.proxyList.setEnabled(true);
                    this.proxyList.select(n);
                    this.proxyCheck.setState(true);
                    this.proxyTab = string2;
                    return;
                }
                ++n;
            }
        }
        this.proxyList.setEnabled(false);
        this.proxyCheck.setState(false);
    }
}

