/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.BosListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacNickname;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class BosHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public BosHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(9, 1, this);
    }

    public void rightsQuery(FLAPSock fLAPSock, BosListener bosListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing bosRightsQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, bosListener, object, 9, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosRightsQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRightsReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosRightsReply SNAC");
        BosListener bosListener = (BosListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (bosListener != null) {
                        n2 = this.updateHandledState(n2, bosListener.bosRightsReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BosListener bosListener2;
                    if ((bosListener2 = (BosListener)vector.elementAt(n)) != bosListener) {
                        n2 = this.updateHandledState(n2, bosListener2.bosRightsReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosRightsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void setGroupPermitMask(FLAPSock fLAPSock, BosListener bosListener, Object object, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing bosSetGroupPermitMask SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (byArray.length < 4) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 4) {
                throw new IOException("write overflow");
            }
            outputBuffer.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, bosListener, object, 9, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosSetGroupPermitMask " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void addPermListEntries(FLAPSock fLAPSock, BosListener bosListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing bosAddPermListEntries SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, bosListener, object, 9, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosAddPermListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void delPermListEntries(FLAPSock fLAPSock, BosListener bosListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing bosDelPermListEntries SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, bosListener, object, 9, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosDelPermListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void addDenyListEntries(FLAPSock fLAPSock, BosListener bosListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing bosAddDenyListEntries SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, bosListener, object, 9, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosAddDenyListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void delDenyListEntries(FLAPSock fLAPSock, BosListener bosListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing bosDelDenyListEntries SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, bosListener, object, 9, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosDelDenyListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeErr(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosErr SNAC");
        BosListener bosListener = (BosListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (bosListener != null) {
                        n2 = this.updateHandledState(n2, bosListener.bosErr(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BosListener bosListener2;
                    if ((bosListener2 = (BosListener)vector.elementAt(n)) != bosListener) {
                        n2 = this.updateHandledState(n2, bosListener2.bosErr(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeRightsReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeErr(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Bos", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

