/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.BuddyHostListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacNickname;
import snac.SnacNicknameWdelta;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class BuddyHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public BuddyHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(3, 1, this);
    }

    private void decodeRightsQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyRightsQuery SNAC");
        BuddyHostListener buddyHostListener = (BuddyHostListener)listener;
        int n = this.initHandledState();
        if (buddyHostListener != null) {
            n = this.updateHandledState(n, buddyHostListener.buddyRightsQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            BuddyHostListener buddyHostListener2 = (BuddyHostListener)vector.elementAt(n2);
            if (buddyHostListener2 != buddyHostListener) {
                n = this.updateHandledState(n, buddyHostListener2.buddyRightsQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void rightsReply(FLAPSock fLAPSock, BuddyHostListener buddyHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing buddyRightsReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyHostListener, object, 3, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyRightsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAddBuddies(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyAddBuddies SNAC");
        BuddyHostListener buddyHostListener = (BuddyHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyHostListener != null) {
                        n2 = this.updateHandledState(n2, buddyHostListener.buddyAddBuddies(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyHostListener buddyHostListener2;
                    if ((buddyHostListener2 = (BuddyHostListener)vector.elementAt(n)) != buddyHostListener) {
                        n2 = this.updateHandledState(n2, buddyHostListener2.buddyAddBuddies(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyAddBuddies " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeDelBuddies(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyDelBuddies SNAC");
        BuddyHostListener buddyHostListener = (BuddyHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyHostListener != null) {
                        n2 = this.updateHandledState(n2, buddyHostListener.buddyDelBuddies(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyHostListener buddyHostListener2;
                    if ((buddyHostListener2 = (BuddyHostListener)vector.elementAt(n)) != buddyHostListener) {
                        n2 = this.updateHandledState(n2, buddyHostListener2.buddyDelBuddies(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyDelBuddies " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    private void decodeWatcherListQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyWatcherListQuery SNAC");
        BuddyHostListener buddyHostListener = (BuddyHostListener)listener;
        int n = this.initHandledState();
        if (buddyHostListener != null) {
            n = this.updateHandledState(n, buddyHostListener.buddyWatcherListQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            BuddyHostListener buddyHostListener2 = (BuddyHostListener)vector.elementAt(n2);
            if (buddyHostListener2 != buddyHostListener) {
                n = this.updateHandledState(n, buddyHostListener2.buddyWatcherListQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void watcherListResponse(FLAPSock fLAPSock, BuddyHostListener buddyHostListener, Object object, int n, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyWatcherListResponse SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                ((SnacNickname)vector.elementAt(n2)).write(outputBuffer);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyHostListener, object, 3, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherListResponse " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeWatcherSubRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyWatcherSubRequest SNAC");
        BuddyHostListener buddyHostListener = (BuddyHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = this.initHandledState();
            if (buddyHostListener != null) {
                n2 = this.updateHandledState(n2, buddyHostListener.buddyWatcherSubRequest(fLAPSock, object, sNACHeader.reqID, n2, n));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                BuddyHostListener buddyHostListener2 = (BuddyHostListener)vector.elementAt(n3);
                if (buddyHostListener2 != buddyHostListener) {
                    n2 = this.updateHandledState(n2, buddyHostListener2.buddyWatcherSubRequest(fLAPSock, object, sNACHeader.reqID, n2, n));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherSubRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void watcherNotification(FLAPSock fLAPSock, BuddyHostListener buddyHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyWatcherNotification SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNicknameWdelta)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyHostListener, object, 3, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void rejectNotification(FLAPSock fLAPSock, BuddyHostListener buddyHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyRejectNotification SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyHostListener, object, 3, 10, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyRejectNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void arrived(FLAPSock fLAPSock, BuddyHostListener buddyHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyArrived SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNicknameWinfo)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyHostListener, object, 3, 11, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyArrived " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void departed(FLAPSock fLAPSock, BuddyHostListener buddyHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyDeparted SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNicknameWinfo)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyHostListener, object, 3, 12, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyDeparted " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeRightsQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeAddBuddies(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeDelBuddies(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeWatcherListQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeWatcherSubRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Buddy", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

