/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.ChatNavListener;
import snac.ChatRoomDesc;
import snac.ChatRoomID;
import snac.ChatRoomIDWDetail;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class ChatNavHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public ChatNavHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(13, 1, this);
    }

    public void requestChatRights(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing chatNavRequestChatRights SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestChatRights " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void requestExchangeInfo(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object, int n) {
        Log.log(MODULE, Log.DB1, "writing chatNavRequestExchangeInfo SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestExchangeInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void requestRoomInfo(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing chatNavRequestRoomInfo SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((ChatRoomIDWDetail)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestRoomInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void requestMoreRoomInfo(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing chatNavRequestMoreRoomInfo SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (byArray.length < 0) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 8192) {
                throw new IOException("write overflow");
            }
            outputBuffer.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestMoreRoomInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void requestOccupantList(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object, ChatRoomID chatRoomID) {
        Log.log(MODULE, Log.DB1, "writing chatNavRequestOccupantList SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            chatRoomID.write(outputBuffer);
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestOccupantList " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void searchForRoom(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing chatNavSearchForRoom SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavSearchForRoom " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void createRoom(FLAPSock fLAPSock, ChatNavListener chatNavListener, Object object, ChatRoomDesc chatRoomDesc) {
        Log.log(MODULE, Log.DB1, "writing chatNavCreateRoom SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            chatRoomDesc.write(outputBuffer);
            this.dispatcher.queueOutput(fLAPSock, chatNavListener, object, 13, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavCreateRoom " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeNavInfo(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavNavInfo SNAC");
        ChatNavListener chatNavListener = (ChatNavListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatNavListener != null) {
                        n2 = this.updateHandledState(n2, chatNavListener.chatNavNavInfo(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatNavListener chatNavListener2;
                    if ((chatNavListener2 = (ChatNavListener)vector.elementAt(n)) != chatNavListener) {
                        n2 = this.updateHandledState(n2, chatNavListener2.chatNavNavInfo(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavNavInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeNavInfo(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("ChatNav", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

