/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.LocateListener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class LocateHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public LocateHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(2, 1, this);
    }

    public void rightsQuery(FLAPSock fLAPSock, LocateListener locateListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing locateRightsQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, locateListener, object, 2, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateRightsQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRightsReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateRightsReply SNAC");
        LocateListener locateListener = (LocateListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (locateListener != null) {
                        n2 = this.updateHandledState(n2, locateListener.locateRightsReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    LocateListener locateListener2;
                    if ((locateListener2 = (LocateListener)vector.elementAt(n)) != locateListener) {
                        n2 = this.updateHandledState(n2, locateListener2.locateRightsReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateRightsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void setInfo(FLAPSock fLAPSock, LocateListener locateListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing locateSetInfo SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, locateListener, object, 2, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateSetInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void userInfoQuery(FLAPSock fLAPSock, LocateListener locateListener, Object object, int n, SnacNickname snacNickname) {
        Log.log(MODULE, Log.DB1, "writing locateUserInfoQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            snacNickname.write(outputBuffer);
            this.dispatcher.queueOutput(fLAPSock, locateListener, object, 2, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateUserInfoQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeUserInfoReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateUserInfoReply SNAC");
        LocateListener locateListener = (LocateListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                SnacNicknameWinfo snacNicknameWinfo;
                block7: {
                    snacNicknameWinfo = new SnacNicknameWinfo(dataInputStream);
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (locateListener != null) {
                        n2 = this.updateHandledState(n2, locateListener.locateUserInfoReply(fLAPSock, object, sNACHeader.reqID, n2, snacNicknameWinfo, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    LocateListener locateListener2;
                    if ((locateListener2 = (LocateListener)vector.elementAt(n)) != locateListener) {
                        n2 = this.updateHandledState(n2, locateListener2.locateUserInfoReply(fLAPSock, object, sNACHeader.reqID, n2, snacNicknameWinfo, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateUserInfoReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void watcherSubRequest(FLAPSock fLAPSock, LocateListener locateListener, Object object, int n) {
        Log.log(MODULE, Log.DB1, "writing locateWatcherSubRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            this.dispatcher.queueOutput(fLAPSock, locateListener, object, 2, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateWatcherSubRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeWatcherNotification(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateWatcherNotification SNAC");
        LocateListener locateListener = (LocateListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (locateListener != null) {
                        n2 = this.updateHandledState(n2, locateListener.locateWatcherNotification(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    LocateListener locateListener2;
                    if ((locateListener2 = (LocateListener)vector.elementAt(n)) != locateListener) {
                        n2 = this.updateHandledState(n2, locateListener2.locateWatcherNotification(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateWatcherNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeRightsReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeUserInfoReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeWatcherNotification(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Locate", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

