/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;

public class SnacTlv
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int type;
    public int length;
    public byte[] data;

    public SnacTlv(int n, int n2, byte[] byArray) {
        this.type = n;
        this.length = n2;
        this.data = byArray;
    }

    SnacTlv(DataInputStream dataInputStream) throws IOException {
        this.type = dataInputStream.readUnsignedShort();
        this.length = dataInputStream.readUnsignedShort();
        if (this.length < 0 || this.length > 8192) {
            throw new IOException("read length bad value: length = " + this.length + " type = " + this.type);
        }
        int n = dataInputStream.available();
        if (n < this.length) {
            throw new IOException("read underflow");
        }
        this.data = new byte[this.length];
        if (this.length > 0) {
            dataInputStream.read(this.data, 0, this.length);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.type);
        if (this.length < 0 || this.length > 8192) {
            throw new IOException("length bad value " + this.length);
        }
        dataOutputStream.writeShort(this.length);
        if (this.data.length < this.length) {
            throw new IOException("write underflow");
        }
        if (this.data.length > this.length) {
            throw new IOException("write overflow");
        }
        dataOutputStream.write(this.data, 0, this.data.length);
    }
}

