/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

class ColorSampler
extends Component {
    String label;
    Color fg;
    Color bg;
    Dimension ourSize;

    ColorSampler(String string, Color color, Color color2) {
        this.label = string;
        this.fg = color;
        this.bg = color2;
    }

    public void destroy() {
        this.label = null;
        this.fg = null;
        this.bg = null;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.bg);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.fg);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        graphics.drawString(this.label, 3, fontMetrics.getHeight() - fontMetrics.getDescent() + 3);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    public void setFG(Color color) {
        this.fg = color;
        this.repaint();
    }

    public void setBG(Color color) {
        this.bg = color;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.ourSize;
    }

    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.ourSize = new Dimension(fontMetrics.stringWidth(this.label) + 6, fontMetrics.getHeight() + 6);
    }
}

