/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import uiutil.ImageContainer;
import util.Log;

public class LedBar
extends Canvas {
    private int x0;
    private int x1;
    private int x2;
    private int x3;
    private double scale;
    private int value;
    private Color ledColor;
    private int litX;
    private int lastLitX;
    private int cWidth;
    private int rWidth;
    private int yWidth;
    private int gWidth;
    private Image background;
    private int W;
    private int H;
    private int hPad = 10;
    private int vPad = 5;
    private final int LED_WIDTH = 3;
    private final int BORDER = 2;
    private static Color DarkRed = new Color(51, 0, 0);
    private static Color DarkYellow = new Color(51, 51, 0);
    private static Color DarkGreen = new Color(0, 51, 0);
    private static Color DarkLed = new Color(51, 51, 51);
    private static Color Shading = new Color(102, 102, 102);
    private static Color Highlight = Color.white;
    private static Color BrightGreen = new Color(51, 204, 51);

    public LedBar() {
    }

    public LedBar(Color color) {
        this.ledColor = color;
    }

    public void setBorders(int n, int n2) {
        this.hPad = n;
        this.vPad = n2;
        if (this.isValid()) {
            this.calculateDimensions();
            this.calculateLitX();
            this.repaint();
        }
    }

    public void setColor(Color color) {
        this.ledColor = color;
        this.calculateDimensions();
        this.repaint();
    }

    public void setLimits(int n, int n2, int n3, int n4) {
        this.x0 = n;
        this.x1 = n2;
        this.x2 = n3;
        this.x3 = n4;
        this.calculateDimensions();
        this.calculateLitX();
        this.repaint();
    }

    public void setValue(int n) {
        this.value = n;
        this.calculateLitX();
        this.repaint();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calculateDimensions() {
        block6: {
            var1_1 = this.getSize();
            this.H = var1_1.height - 2 * this.vPad;
            this.W = var1_1.width - 2 * this.hPad;
            var2_2 = this.W - 4;
            var3_3 = 4;
            while (this.W % var3_3 != 0 && this.W > 0) {
                --this.W;
            }
            if (this.ledColor == null) break block6;
            this.cWidth = var2_2;
            if (true) ** GOTO lbl14
            do {
                --this.cWidth;
lbl14:
                // 2 sources

                if (this.cWidth % var3_3 == 0) return;
            } while (this.cWidth > 0);
            return;
        }
        if (this.x3 == this.x0) {
            this.gWidth = 0;
            this.yWidth = 0;
            this.rWidth = 0;
            return;
        }
        this.scale = (double)var2_2 / (double)(this.x3 - this.x0);
        this.gWidth = (int)((double)(this.x3 - this.x2) * this.scale);
        while (this.gWidth % var3_3 != 0 && this.gWidth > 0) {
            --this.gWidth;
        }
        this.yWidth = (int)((double)(this.x2 - this.x1) * this.scale);
        while (this.yWidth % var3_3 != 0 && this.yWidth > 0) {
            --this.yWidth;
        }
        this.rWidth = var2_2 - this.gWidth - this.yWidth;
        while (this.rWidth % var3_3 != 0 && this.rWidth > 0) {
            --this.rWidth;
        }
    }

    private void calculateLitX() {
        int n = (int)((double)(this.value - this.x0) * this.scale + (double)this.hPad);
        while (n % 4 != 0 && n > 0) {
            --n;
        }
        this.lastLitX = this.litX;
        this.litX = ++n;
    }

    private void fill(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n + n3;
        if (n5 < n) {
            graphics.setColor(color2);
            int n9 = n7;
            while (n9 < n8) {
                graphics.fillRect(n9, n2, 3, n4);
                n9 += 4;
            }
            return;
        }
        if (n5 >= n + n3) {
            graphics.setColor(color);
            int n10 = n7;
            while (n10 < n8) {
                graphics.fillRect(n10, n2, 3, n4);
                n10 += 4;
            }
            return;
        }
        graphics.setColor(color);
        int n11 = n7;
        while (n11 < n5) {
            graphics.fillRect(n11, n2, 3, n4);
            n11 += 4;
        }
        graphics.setColor(color2);
        int n12 = n5;
        while (n12 < n8) {
            graphics.fillRect(n12, n2, 3, n4);
            n12 += 4;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calculateDimensions();
        this.calculateLitX();
        if (this.background == null) {
            return;
        }
        this.background = null;
        this.setBackground();
    }

    public void paint(Graphics graphics) {
        if (this.background == null) {
            this.calculateDimensions();
            this.setBackground();
        }
        if (this.background != null) {
            Graphics graphics2 = this.background.getGraphics();
            int n = this.hPad + 3;
            int n2 = this.vPad + 3;
            if (this.ledColor != null) {
                this.fill(graphics2, this.ledColor, DarkLed, n, n2, this.cWidth, this.H - 6, this.litX, this.lastLitX);
            } else {
                this.fill(graphics2, Color.red, DarkRed, n, n2, this.rWidth, this.H - 6, this.litX, this.lastLitX);
                this.fill(graphics2, Color.yellow, DarkYellow, n + this.rWidth, n2, this.yWidth, this.H - 6, this.litX, this.lastLitX);
                this.fill(graphics2, BrightGreen, DarkGreen, n + this.rWidth + this.yWidth, n2, this.gWidth, this.H - 6, this.litX, this.lastLitX);
            }
            graphics.drawImage(this.background, 0, 0, this);
        }
    }

    public void removeNotify() {
        this.ledColor = null;
        this.background = null;
        super.removeNotify();
    }

    private void setBackground() {
        Rectangle rectangle = this.getBounds();
        ImageContainer imageContainer = (ImageContainer)((Object)this.getParent());
        Image image = imageContainer.getBackground(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (image == null) {
            return;
        }
        try {
            if (this.background == null) {
                this.background = this.createImage(rectangle.width, rectangle.height);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.log("LedBar", Log.WARNING, "Negative value(s) in argument.");
        }
        Graphics graphics = this.background.getGraphics();
        graphics.drawImage(image, 0, 0, this);
        this.getBackground();
        graphics.setColor(Shading);
        graphics.drawLine(this.hPad, this.vPad, this.hPad + this.W - 1, this.vPad);
        graphics.drawLine(this.hPad + 1, this.vPad + 1, this.hPad + this.W - 2, this.vPad + 1);
        graphics.drawLine(this.hPad, this.vPad, this.hPad, this.vPad + this.H - 1);
        graphics.drawLine(this.hPad + 1, this.vPad + 1, this.hPad + 1, this.vPad + this.H - 2);
        graphics.setColor(Highlight);
        graphics.drawLine(this.hPad + 1, this.vPad + this.H - 1, this.hPad + this.W - 1, this.vPad + this.H - 1);
        graphics.drawLine(this.hPad + 2, this.vPad + this.H - 2, this.hPad + this.W - 2, this.vPad + this.H - 2);
        graphics.drawLine(this.hPad + this.W, this.vPad, this.hPad + this.W, this.vPad + this.H - 1);
        graphics.drawLine(this.hPad + this.W - 1, this.vPad + 1, this.hPad + this.W - 1, this.vPad + this.H - 2);
        graphics.setColor(Color.black);
        graphics.drawRect(this.hPad + 2, this.vPad + 2, this.W - 4, this.H - 5);
        int n = this.hPad + 2;
        while (n < this.hPad + 2 + this.W - 4) {
            graphics.drawLine(n, this.vPad + 2, n, this.vPad + 2 + this.H - 5);
            n += 4;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

