/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import uiutil.MediaStoreItem;
import util.JarFile;
import util.KeyBindings;
import util.Log;

public class MediaStore {
    private static final String MODULE = "MediaStore";
    protected static Hashtable media = new Hashtable();
    protected static Hashtable loadedUIPacks = new Hashtable();
    protected static String[] preUIPacks = new String[0];
    protected static String[] postUIPacks = new String[]{"tool.share"};
    protected static String[] uiPackCreators = new String[]{"aol"};
    protected static String[] searchDirs;
    protected static KeyBindings keys;
    public static final int ALL = 255;
    public static final int SOUNDS = 1;
    public static final int IMAGES = 2;
    public static final int LAYOUTS = 4;

    public static void createMediaStore(KeyBindings keyBindings, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        if (keys != null) {
            System.out.println("Someone tried to create the MediaStore again!");
            System.exit(1);
        }
        keys = keyBindings;
        searchDirs = stringArray;
        uiPackCreators = stringArray2;
        preUIPacks = stringArray3 == null ? new String[0] : stringArray3;
        if (stringArray4 == null) {
            postUIPacks = new String[0];
            return;
        }
        postUIPacks = stringArray4;
    }

    public static void addMedia(String string, String string2, int n) {
        File file;
        try {
            file = new File(String.valueOf(string) + ".jar");
            if (file.exists()) {
                MediaStore.loadJarFileInfo(file, string2, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            file = new File(string);
            if (file.exists() && file.isDirectory()) {
                MediaStore.loadDirInfo(file, string2, n);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean unloadMedia(String[] stringArray, String string, String string2) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(stringArray, "images", string2);
        if (mediaStoreItem == null) {
            return false;
        }
        mediaStoreItem.object = null;
        return true;
    }

    public static void unloadUIPack(String string) {
        loadedUIPacks.remove(string);
        Enumeration enumeration = media.keys();
        String string2 = string;
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            MediaStoreItem mediaStoreItem = (MediaStoreItem)media.remove(string3);
            mediaStoreItem.filename = null;
            mediaStoreItem.object = null;
            mediaStoreItem.jarFile = null;
        }
    }

    public static Image getImage(String[] stringArray, String string) {
        return MediaStore.getImage(stringArray, string, true);
    }

    public static Image getImage(String[] stringArray, String string, boolean bl) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(stringArray, "images", string);
        if (mediaStoreItem == null) {
            return null;
        }
        if (mediaStoreItem.object == null) {
            Image image;
            if (mediaStoreItem.jarFile == null) {
                image = Toolkit.getDefaultToolkit().getImage(mediaStoreItem.filename);
            } else {
                byte[] byArray = mediaStoreItem.jarFile.getBytes(mediaStoreItem.filename);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
            }
            if (bl) {
                mediaStoreItem.object = image;
            } else {
                return image;
            }
        }
        return (Image)mediaStoreItem.object;
    }

    public static InputStream getSound(String[] stringArray, String string) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(stringArray, "sounds", string);
        if (mediaStoreItem == null) {
            return null;
        }
        if (mediaStoreItem.object != null) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)mediaStoreItem.object;
            byteArrayInputStream.reset();
            return byteArrayInputStream;
        }
        try {
            if (mediaStoreItem.jarFile == null) {
                return new FileInputStream(mediaStoreItem.filename);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mediaStoreItem.jarFile.getBytes(mediaStoreItem.filename));
            mediaStoreItem.object = byteArrayInputStream;
            return byteArrayInputStream;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getLayout(String[] stringArray, String string) {
        MediaStoreItem mediaStoreItem = MediaStore.getMSI(stringArray, "layouts", string);
        if (mediaStoreItem == null) {
            return null;
        }
        try {
            if (mediaStoreItem.jarFile == null) {
                return new BufferedReader(new FileReader(mediaStoreItem.filename));
            }
            return new BufferedReader(new InputStreamReader(mediaStoreItem.jarFile.getInputStream(mediaStoreItem.filename)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void loadJarFileUIPack(JarFile jarFile, String string, String string2, int n) {
        int n2 = string.length();
        String string3 = String.valueOf(string) + "sounds/";
        String string4 = String.valueOf(string) + "images/";
        String string5 = String.valueOf(string) + "layouts/";
        try {
            Enumeration enumeration = jarFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string6 = zipEntry.getName();
                if ((n & 1) == 1 && string6.startsWith(string3) && string6.endsWith(".au")) {
                    media.put(String.valueOf(string2) + '/' + string6.substring(n2), new MediaStoreItem(string6, jarFile));
                    continue;
                }
                if ((n & 2) == 2 && string6.startsWith(string4) && string6.endsWith(".gif")) {
                    media.put(String.valueOf(string2) + '/' + string6.substring(n2), new MediaStoreItem(string6, jarFile));
                    continue;
                }
                if ((n & 4) != 4 || !string6.startsWith(string5) || !string6.endsWith(".lay")) continue;
                media.put(String.valueOf(string2) + '/' + string6.substring(n2), new MediaStoreItem(string6, jarFile));
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void loadJarFileInfo(File file, String string, int n) {
        try {
            JarFile jarFile = new JarFile(file.getPath());
            MediaStore.loadJarFileUIPack(jarFile, "", string, n);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void loadDirInfo(File file, String string, int n) {
        int n2;
        String[] stringArray;
        File file2;
        if ((n & 1) == 1) {
            file2 = new File(file, "sounds");
            stringArray = file2.list();
            n2 = 0;
            while (stringArray != null && n2 < stringArray.length) {
                media.put(String.valueOf(string) + "/sounds/" + stringArray[n2], new MediaStoreItem(String.valueOf(file2.getPath()) + File.separator + stringArray[n2]));
                ++n2;
            }
        }
        if ((n & 2) == 2) {
            file2 = new File(file, "images");
            stringArray = file2.list();
            n2 = 0;
            while (stringArray != null && n2 < stringArray.length) {
                media.put(String.valueOf(string) + "/images/" + stringArray[n2], new MediaStoreItem(String.valueOf(file2.getPath()) + File.separator + stringArray[n2]));
                ++n2;
            }
        }
        if ((n & 4) == 4) {
            file2 = new File(file, "layouts");
            stringArray = file2.list();
            n2 = 0;
            while (stringArray != null && n2 < stringArray.length) {
                media.put(String.valueOf(string) + "/layouts/" + stringArray[n2], new MediaStoreItem(String.valueOf(file2.getPath()) + File.separator + stringArray[n2]));
                ++n2;
            }
        }
    }

    private static void loadUIPack(String string) {
        if (keys == null) {
            System.out.println("Media Store not created!");
            System.exit(0);
        }
        Log.log(MODULE, Log.DB0, "Loading UIPack " + string);
        String string2 = File.separator;
        keys.setKeySeparator('#');
        KeyBindings keyBindings = keys.getKeyBindings(string);
        int n = 0;
        while (n < searchDirs.length) {
            String string3;
            String string4;
            int n2 = 0;
            while (n2 < uiPackCreators.length) {
                string4 = String.valueOf(searchDirs[n]) + "uipacks" + string2 + string + "." + uiPackCreators[n2];
                MediaStore.addMedia(string4, string, 255);
                ++n2;
            }
            if (keyBindings != null && (string3 = keyBindings.getValue("images")) != null) {
                string4 = String.valueOf(searchDirs[n]) + "uipacks" + string2 + string + "." + string3;
                MediaStore.addMedia(string4, string, 2);
            }
            if (keyBindings != null && (string3 = keyBindings.getValue("sounds")) != null) {
                string4 = String.valueOf(searchDirs[n]) + "uipacks" + string2 + string + "." + string3;
                MediaStore.addMedia(string4, string, 1);
            }
            if (keyBindings != null && (string3 = keyBindings.getValue("layouts")) != null) {
                string4 = String.valueOf(searchDirs[n]) + "uipacks" + string2 + string + "." + string3;
                MediaStore.addMedia(string4, string, 4);
            }
            ++n;
        }
        keys.setKeySeparator('.');
        loadedUIPacks.put(string, string);
    }

    private static MediaStoreItem getMSI(String[] stringArray, String string, String string2) {
        MediaStoreItem mediaStoreItem;
        String string3;
        int n = 0;
        while (n < preUIPacks.length) {
            string3 = String.valueOf(preUIPacks[n]) + "/" + string + "/" + string2;
            if (loadedUIPacks.get(preUIPacks[n]) == null) {
                MediaStore.loadUIPack(preUIPacks[n]);
            }
            if ((mediaStoreItem = (MediaStoreItem)media.get(string3)) != null) {
                return mediaStoreItem;
            }
            ++n;
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                string3 = String.valueOf(stringArray[n]) + "/" + string + "/" + string2;
                if (loadedUIPacks.get(stringArray[n]) == null) {
                    MediaStore.loadUIPack(stringArray[n]);
                }
                if ((mediaStoreItem = (MediaStoreItem)media.get(string3)) != null) {
                    return mediaStoreItem;
                }
                ++n;
            }
        }
        n = 0;
        while (n < postUIPacks.length) {
            string3 = String.valueOf(postUIPacks[n]) + "/" + string + "/" + string2;
            if (loadedUIPacks.get(postUIPacks[n]) == null) {
                MediaStore.loadUIPack(postUIPacks[n]);
            }
            if ((mediaStoreItem = (MediaStoreItem)media.get(string3)) != null) {
                return mediaStoreItem;
            }
            ++n;
        }
        return null;
    }
}

