/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Component {
    public static int LEFT;
    public static int CENTER;
    public static int RIGHT;
    public static int BORDER_SIMPLE;
    public static int BORDER_IN;
    public static int BORDER_OUT;
    protected String[] lines;
    protected int num_lines;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected int alignment = LEFT;
    private boolean dimmed = false;
    private int borderType = BORDER_OUT + 1;
    private boolean attribLabel;
    private int cmaxWidth;
    private char separator;

    protected void newLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int n = 0;
        while (n < this.num_lines) {
            this.lines[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    protected void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.max_width = 0;
        int n = 0;
        while (n < this.num_lines) {
            this.line_widths[n] = fontMetrics.stringWidth(this.lines[n]);
            if (this.line_widths[n] > this.max_width) {
                this.max_width = this.line_widths[n];
            }
            ++n;
        }
        if (this.attribLabel) {
            this.breakupLines();
        }
    }

    public MultiLineLabel(String string, char c) {
        this.attribLabel = true;
        this.separator = c;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[2 * this.num_lines];
        this.line_widths = new int[this.num_lines];
        int n = 0;
        while (n < this.num_lines) {
            this.lines[n] = stringTokenizer.nextToken();
            ++n;
        }
        this.margin_width = 10;
        this.margin_height = 10;
        this.alignment = LEFT;
    }

    private void breakupLines() {
        if (this.lines[this.num_lines + 1] != null) {
            return;
        }
        int n = 0;
        while (n < this.num_lines) {
            int n2 = this.lines[n].indexOf(this.separator);
            if (n2 != -1) {
                this.lines[n + this.num_lines] = this.lines[n].substring(n2 + 1);
                this.lines[n] = this.lines[n].substring(0, n2);
            } else {
                this.lines[n + this.num_lines] = "\u0000";
            }
            ++n;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.cmaxWidth = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.num_lines) {
            this.cmaxWidth = Math.max(this.cmaxWidth, fontMetrics.stringWidth(this.lines[n4]));
            n3 = Math.max(n3, fontMetrics.stringWidth(this.lines[n4 + this.num_lines]));
            ++n4;
        }
        this.cmaxWidth += fontMetrics.stringWidth("  ");
        this.max_width = n3 + this.cmaxWidth + fontMetrics.stringWidth("  ");
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this.newLabel(string);
        this.margin_width = n;
        this.margin_height = n2;
        this.alignment = n3;
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, LEFT);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, LEFT);
    }

    public void destroy() {
        this.lines = null;
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setDim(boolean bl) {
        this.dimmed = bl;
        this.repaint();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.margin_width = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.margin_height = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    public void setBorder(int n) {
        this.borderType = n;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.dimmed) {
            graphics.setColor(Color.gray);
        }
        Dimension dimension = this.getSize();
        int n = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n2 = 0;
        while (n2 < this.num_lines) {
            int n3 = this.alignment == LEFT ? this.margin_width : (this.alignment == RIGHT ? dimension.width - this.margin_width - this.line_widths[n2] : (dimension.width - this.line_widths[n2]) / 2);
            if (!this.attribLabel) {
                graphics.drawString(this.lines[n2], n3, n);
            } else {
                graphics.drawString(this.lines[n2], n3, n);
                if (this.lines[n2 + this.num_lines] != null && !this.lines[n2 + this.num_lines].equals("\u0000")) {
                    graphics.drawString("  :  " + this.lines[n2 + this.num_lines], this.cmaxWidth, n);
                }
            }
            ++n2;
            n += this.line_height;
        }
        if (this.borderType > BORDER_OUT || this.borderType < 0) {
            return;
        }
        if (this.borderType == BORDER_SIMPLE) {
            this.drawBorderSimple(graphics, dimension);
            return;
        }
        if (this.borderType == BORDER_IN) {
            this.drawBorderIn(graphics, dimension);
            return;
        }
        if (this.borderType == BORDER_OUT) {
            this.drawBorderOut(graphics, dimension);
        }
    }

    private void drawBorderSimple(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    private void drawBorderIn(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(Color.white);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    private void drawBorderOut(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.white);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    static {
        CENTER = 1;
        RIGHT = 2;
        BORDER_IN = 1;
        BORDER_OUT = 2;
    }
}

