/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Window;
import uiutil.MultiLineLabel;
import uiutil.OFrame;

public class Popup {
    private static Window popup = new Window(OFrame.defaultFrame);
    private static String lastText;
    private static Color fgColor;
    private static Color bgColor;

    private Popup() {
    }

    public static void restoreColors() {
        popup.setForeground(fgColor);
        ((Component)popup).setBackground(bgColor);
    }

    public static void showPopup(String string, int n, int n2, boolean bl) {
        if (lastText == null || !lastText.equals(string)) {
            popup.removeAll();
            MultiLineLabel multiLineLabel = bl ? new MultiLineLabel(string, ':') : new MultiLineLabel(string, 2, 2);
            multiLineLabel.setBorder(MultiLineLabel.BORDER_SIMPLE);
            popup.add("Center", multiLineLabel);
            Dimension dimension = multiLineLabel.getPreferredSize();
            ((Component)popup).setSize(dimension.width, dimension.height);
            popup.pack();
            lastText = string;
        }
        ((Component)popup).setLocation(n, n2);
        ((Component)popup).setVisible(true);
    }

    public static void showPopup(String string, int n, int n2, Color color, Color color2, boolean bl) {
        popup.setForeground(color);
        ((Component)popup).setBackground(color2);
        Popup.showPopup(string, n, n2, bl);
    }

    public static void showPopup(String string, int n, int n2) {
        Popup.showPopup(string, n, n2, false);
    }

    public static void hidePopup() {
        ((Component)popup).setVisible(false);
    }

    public static void hidePopup(String string) {
        ((Component)popup).setVisible(false);
    }

    static {
        fgColor = SystemColor.infoText;
        bgColor = SystemColor.info;
        popup.setForeground(fgColor);
        ((Component)popup).setBackground(bgColor);
    }
}

