/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import component.FolderInfo;
import component.SetupUI;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import main.Nickname;
import main.Oscar;
import module.aolim.AolImConverter;
import module.rendezvous.Rendezvous;
import module.rendezvous.fileTransfer.CallBackObject;
import module.rendezvous.fileTransfer.FtTLV;
import module.rendezvous.fileTransfer.FxferUI;
import module.rendezvous.fileTransfer.TransferCore;
import snac.TLV;
import tool.BlockEvent;
import tool.EvilEvent;
import tool.ToolStatusEvent;
import tool.ToolStatusListener;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmSubModule;
import tool.icbm.RendezvousConstants;
import tool.icbm.RendezvousEvent;
import tool.icbm.RendezvousListener;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import uiutil.UIPack;
import util.EventBus;
import util.EventBusEvent;
import util.InputBuffer;
import util.JUtil;
import util.OutputBuffer;

public class FileTransfer
implements IcbmSubModule,
RendezvousConstants,
RendezvousListener,
ToolStatusListener,
UIPack,
ActionListener,
AolImConverter.WhiscerConstants {
    public static final int fileTlvTag = 10001;
    private static final String MODULE = "FileTransfer";
    private static final String MODULE_NAME = "rendezvous.fileTransfer";
    private static final String[] UIPACK_NAMES = new String[]{"rendezvous.fileTransfer", "icbm.rendezvous", "tool.icbm"};
    private static final String DISPLAY_NAME = "File Transfer";
    EventBus eventBus;
    EventBus systemBus;
    private Vector uis = new Vector(5);
    private Hashtable xfers = new Hashtable(1);
    private MenuItem fxferItem;
    private byte[] myService = this.uuidFromString("09461343-4C7F-11D1-8222-444553540000");
    private String localIPAddress;
    private byte[] byteIPAddress;
    private static int localPort = 2048;
    static /* synthetic */ Class class$tool$ToolStatusEvent;
    static /* synthetic */ Class class$tool$icbm$RendezvousEvent;

    public FileTransfer() {
        this.systemBus = EventBus.joinBus((String)EventBus.SYSTEM_BUS);
        this.systemBus.addListenerFor((EventListener)this, class$tool$ToolStatusEvent != null ? class$tool$ToolStatusEvent : (class$tool$ToolStatusEvent = FileTransfer.class$("tool.ToolStatusEvent")));
        if (Oscar.config.getValue("debug.fileXfer") != null) {
            this.fxferItem = new MenuItem(DISPLAY_NAME);
            this.fxferItem.addActionListener(this);
            Oscar.addMenuItem((String)"People", (MenuItem)this.fxferItem);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Cannot get local host address");
        }
        this.localIPAddress = inetAddress.getHostAddress();
        this.byteIPAddress = inetAddress.getAddress();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fxferItem) {
            Rendezvous.initService = "09461343-4C7F-11D1-8222-444553540000";
            Oscar.mainTool.rendezvousAction(Oscar.mainTool.getSelectedNickname());
        }
    }

    public static final long calculateChecksum(String string) {
        DataInputStream dataInputStream;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(string));
        }
        catch (IOException iOException) {
            ErrorMgr.diag((String)"FT.calc", (String)"Cannot open file", (Exception)iOException);
            return -1L;
        }
        long l = 0L;
        try {
            short s = dataInputStream.readShort();
            while (s > 0) {
                l += (long)(~s);
                s = dataInputStream.readShort();
            }
        }
        catch (IOException iOException) {
            ErrorMgr.diag((String)"FT.calc", (String)"read file exception", (Exception)iOException);
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void initiate(IcbmChannel icbmChannel, String string) {
        System.out.println("Rendezvous FileTransfer.initiate on channel " + icbmChannel + " bus=" + string);
        this.eventBus = EventBus.joinBus((String)string);
        this.eventBus.addListenerFor((EventListener)this, class$tool$icbm$RendezvousEvent != null ? class$tool$icbm$RendezvousEvent : (class$tool$icbm$RendezvousEvent = FileTransfer.class$("tool.icbm.RendezvousEvent")));
    }

    void sendEvil(String string, boolean bl) {
        EvilEvent evilEvent = new EvilEvent((Object)this, 1110, new Nickname(string), bl);
        this.systemBus.postEvent((EventBusEvent)evilEvent);
    }

    void block(String string) {
        BlockEvent blockEvent = new BlockEvent((Object)this, 1120, new Nickname(string));
        this.systemBus.postEvent((EventBusEvent)blockEvent);
    }

    void sendIM(String string) {
        Oscar.mainTool.icbmAction(string);
    }

    void getXferRequest(byte[] byArray, String string, String string2) {
        FtTLV ftTLV = new FtTLV(FtTLV.SUBTYPE_GET_FILE, 0, 0L, string2);
        byte[] byArray2 = null;
        try {
            byArray2 = ftTLV.getBytes();
        }
        catch (IOException iOException) {
            System.out.println("IOError while trying to extract fileTlv");
        }
        this.sendRequest(byArray, string, "GET", byArray2);
        CallBackObject callBackObject = new CallBackObject();
        callBackObject.setValues(null, byArray, string, ftTLV);
        TransferCore transferCore = new TransferCore(this, callBackObject, this.localIPAddress, localPort);
        this.xfers.put(new String(byArray), transferCore);
        transferCore.setListener(true);
        transferCore.setSender(false);
        transferCore.start();
    }

    void listXferRequest(byte[] byArray, String string) {
        FtTLV ftTLV = new FtTLV(FtTLV.SUBTYPE_GET_LIST, 0, 0L, null);
        byte[] byArray2 = null;
        try {
            byArray2 = ftTLV.getBytes();
        }
        catch (IOException iOException) {
            System.out.println("IOError while trying to extract fileTlv");
        }
        this.sendRequest(byArray, string, "DIR", byArray2);
        CallBackObject callBackObject = new CallBackObject();
        callBackObject.setValues(null, byArray, string, ftTLV);
        TransferCore transferCore = new TransferCore(this, callBackObject, this.localIPAddress, localPort);
        this.xfers.put(new String(byArray), transferCore);
        transferCore.setListener(true);
        transferCore.setSender(false);
        transferCore.start();
    }

    void sendXferRequest(byte[] byArray, String string, int n, int n2, long l, String string2, String string3) {
        FtTLV ftTLV = new FtTLV(n, n2, l, string2);
        byte[] byArray2 = null;
        try {
            byArray2 = ftTLV.getBytes();
        }
        catch (IOException iOException) {
            System.out.println("IOError while trying to extract fileTlv");
        }
        this.sendRequest(byArray, string, string3, byArray2);
        CallBackObject callBackObject = new CallBackObject();
        callBackObject.setValues(null, byArray, string, ftTLV);
        TransferCore transferCore = new TransferCore(this, callBackObject, this.localIPAddress, localPort);
        this.xfers.put(new String(byArray), transferCore);
        transferCore.setListener(true);
        transferCore.setSender(true);
        transferCore.start();
    }

    public static String prependWheader(String string) {
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeByte(1);
            outputBuffer.writeByte(1);
            outputBuffer.writeShort(4 + string.length());
            outputBuffer.writeShort(0);
            outputBuffer.writeShort(0);
            outputBuffer.writeBytes(string);
            return new String(outputBuffer.bytes());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String removeWheader(String string) {
        InputBuffer inputBuffer = new InputBuffer(string.getBytes());
        try {
            inputBuffer.d.readByte();
            inputBuffer.d.readByte();
            int n = inputBuffer.d.readUnsignedShort();
            inputBuffer.d.readUnsignedShort();
            byte[] byArray = new byte[n];
            inputBuffer.d.read(byArray, 0, n);
            return new String(byArray);
        }
        catch (IOException iOException) {
            System.out.println("removeWheader: " + iOException);
            return string;
        }
    }

    void sendRequest(byte[] byArray, String string, String string2, byte[] byArray2) {
        TLV tLV = new TLV(2);
        tLV.addTlv(3, this.byteIPAddress);
        tLV.addTlvU16(5, localPort);
        string2 = FileTransfer.prependWheader(string2);
        tLV.addTlv(6, string2);
        tLV.addTlv(10001, byArray2);
        byte[] byArray3 = Oscar.bosCore.getCookie();
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), byArray3, false, tLV, this.myService, 0, byArray, 0);
        if (string != null) {
            this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
        }
    }

    void sendAccept(CallBackObject callBackObject) {
        TransferCore transferCore;
        TLV tLV = new TLV(2);
        tLV.addTlvU16(0, 1);
        tLV.addTlvU16(10000, 5);
        tLV.addTlv(2, this.localIPAddress);
        tLV.addTlv(3, this.localIPAddress);
        tLV.addTlvU16(5, localPort);
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(callBackObject.nickname), null, false, tLV, this.myService, 0, callBackObject.rCookie, 2);
        if (callBackObject.nickname != null) {
            this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
        }
        if ((transferCore = (TransferCore)this.xfers.remove(new String(callBackObject.rCookie))) != null) {
            System.out.println("sendAcceptCB: Stoping thread " + transferCore);
            transferCore.stop();
        }
        transferCore = new TransferCore(this, callBackObject, this.localIPAddress, localPort);
        transferCore.setListener(true);
        transferCore.setSender(false);
        transferCore.start();
    }

    void sendAccept(byte[] byArray, byte[] byArray2, String string, TLV tLV, String string2) {
        FtTLV ftTLV;
        boolean bl = false;
        byte[] byArray3 = tLV.getTlvData(10001);
        if (byArray3 == null) {
            System.out.println("NO file TLV data!");
            bl = true;
        }
        if (!(ftTLV = new FtTLV(byArray3)).isValid() || bl) {
            System.out.println("BUSTED_PARAMETERS error!");
            this.sendError(byArray, byArray2, string, 3);
            return;
        }
        ftTLV.name = string2;
        String string3 = null;
        int n = 1025;
        int n2 = 4;
        if (!tLV.tlvTypePresent(n2)) {
            System.out.println("Verified IP Address found in rendezvous event");
            return;
        }
        string3 = this.getQuad(JUtil.bytesToHexString((byte[])tLV.getTlvData(n2)));
        n2 = 5;
        if (!tLV.tlvTypePresent(n2)) {
            System.out.println("No port info. found in rendezvous event");
            return;
        }
        n = tLV.getTlvDataAsU16(n2);
        CallBackObject callBackObject = new CallBackObject();
        callBackObject.setValues(byArray, byArray2, string, ftTLV);
        TransferCore transferCore = new TransferCore(this, callBackObject, string3, n);
        this.xfers.put(new String(byArray2), this);
        transferCore.setListener(false);
        transferCore.setSender(false);
        transferCore.start();
    }

    private final String getQuad(String string) {
        if (string.length() != 8) {
            return "xx.xx.xx.xx";
        }
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n < 8) {
            String string3 = string.substring(n, n + 2);
            try {
                n2 = Integer.parseInt(string3, 16);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            string2 = String.valueOf(string2) + n2;
            if ((n += 2) >= 8) continue;
            string2 = String.valueOf(string2) + ".";
        }
        return string2;
    }

    void sendExplicitIgnore(byte[] byArray, String string) {
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, this.myService, 1, byArray, 1);
        if (string != null) {
            this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
        }
    }

    void sendCancel(byte[] byArray, String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1101, 2, new Nickname(string), null, false, null, this.myService, 1, byArray, 1);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    void sendError(byte[] byArray, byte[] byArray2, String string, int n) {
        TLV tLV = new TLV(2);
        tLV.addTlv(n, byArray2);
        RendezvousEvent rendezvousEvent = new RendezvousEvent((Object)this, 1106, 2, new Nickname(string), byArray, false, tLV, this.myService, 0, byArray2, 100);
        this.eventBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    private byte[] uuidFromString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '-') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        byte[] byArray = null;
        try {
            byArray = JUtil.bytesFromHexString((String)string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn((String)MODULE, (String)("UUID caused number format exception. Id=" + string2));
        }
        return byArray;
    }

    private final boolean isMyService(byte[] byArray) {
        if (byArray == null || this.myService.length != byArray.length) {
            return false;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.myService[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void removeFxferUI(FxferUI fxferUI) {
        this.uis.removeElement((Object)fxferUI);
    }

    public void removeThread(String string) {
        this.xfers.remove(string);
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void receiveMessage(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        if (rendezvousEvent.getRendezvousType() != 2) {
            this.uis.addElement(new FxferUI(this, rendezvousEvent));
            return;
        }
        TLV tLV = rendezvousEvent.getRendezvousParams();
        String string = null;
        int n = 1025;
        int n2 = 4;
        if (!tLV.tlvTypePresent(n2)) {
            System.out.println("VIP Address not found in rendezvous event");
            return;
        }
        string = this.getQuad(JUtil.bytesToHexString((byte[])tLV.getTlvData(n2)));
        n2 = 5;
        if (!tLV.tlvTypePresent(n2)) {
            System.out.println("No port info. found in rendezvous event");
            return;
        }
        n = tLV.getTlvDataAsU16(n2);
        String string2 = new String(rendezvousEvent.getRendezvousCookie());
        TransferCore transferCore = (TransferCore)this.xfers.remove(string2);
        CallBackObject callBackObject = new CallBackObject();
        if (transferCore != null) {
            CallBackObject callBackObject2 = transferCore.cbo;
            callBackObject.setValues(callBackObject2.cookie, callBackObject2.rCookie, callBackObject2.nickname, callBackObject2.ftTLV);
        }
        if (transferCore != null) {
            System.out.println("receiveMsg: Stoping thread " + transferCore);
            transferCore.stop();
        }
        transferCore = new TransferCore(this, callBackObject, string, n);
        transferCore.setListener(false);
        if (callBackObject.ftTLV.totalSize > 0L) {
            transferCore.setSender(true);
            transferCore.start();
            return;
        }
        transferCore.setSender(false);
        transferCore.start();
    }

    public void sendMessage(RendezvousEvent rendezvousEvent) {
    }

    public void initiateMessage(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        this.uis.addElement(new FxferUI(this, rendezvousEvent));
    }

    public void payloadError(RendezvousEvent rendezvousEvent) {
    }

    public void channelError(RendezvousEvent rendezvousEvent) {
        if (!this.isMyService(rendezvousEvent.getRendezvousService())) {
            return;
        }
        if (rendezvousEvent.getId() == 1105) {
            this.uis.addElement(new FxferUI(this, rendezvousEvent));
        }
    }

    public void connect(ToolStatusEvent toolStatusEvent) {
    }

    public void disconnect(ToolStatusEvent toolStatusEvent) {
    }

    public void enableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            int n = this.uis.size();
            int n2 = 0;
            while (n2 < n) {
                FxferUI fxferUI = (FxferUI)((Object)this.uis.elementAt(n2));
                if (fxferUI != null) {
                    fxferUI.setEnabled(true);
                }
                ++n2;
            }
        }
    }

    public void disableUI(ToolStatusEvent toolStatusEvent) {
        if (toolStatusEvent.getToolName().equals("ICBM")) {
            int n = this.uis.size();
            int n2 = 0;
            while (n2 < n) {
                FxferUI fxferUI = (FxferUI)((Object)this.uis.elementAt(n2));
                if (fxferUI != null) {
                    fxferUI.setEnabled(false);
                }
                ++n2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

