/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.buddyChat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Window;
import main.Oscar;
import module.rendezvous.buddyChat.BuddyChat;
import module.rendezvous.buddyChat.ErrorPanel;
import module.rendezvous.buddyChat.ReceivePanel;
import module.rendezvous.buddyChat.SendPanel;
import tool.icbm.RendezvousEvent;
import uiutil.BoundedPanel;
import uiutil.OFrame;

public class ChatUI
extends OFrame {
    public static String MODULE = "RendezvousChatUI";
    private BuddyChat buddyChat;
    private SendPanel sendPanel;
    private ReceivePanel receivePanel;
    private ErrorPanel errorPanel;
    private byte[] cookie;
    String frameTitle;
    Panel mainPanel = new Panel(new BorderLayout());
    BoundedPanel boundedPanel;

    public ChatUI(BuddyChat buddyChat, RendezvousEvent rendezvousEvent) {
        this.buddyChat = buddyChat;
        int n = rendezvousEvent.getId();
        this.frameTitle = String.valueOf(rendezvousEvent.getNickname().nickname) + ":";
        this.cookie = rendezvousEvent.getRendezvousCookie();
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        if (n == 1100) {
            this.mainPanel.add("Center", new SendPanel(buddyChat, this, rendezvousEvent));
        } else if (n == 1102) {
            this.mainPanel.add("Center", new ReceivePanel(buddyChat, this, rendezvousEvent));
        } else if (n == 1105) {
            this.frameTitle = String.valueOf(this.frameTitle) + " Error";
            this.mainPanel.add("Center", new ErrorPanel(buddyChat, this, rendezvousEvent));
        } else {
            this.frameTitle = String.valueOf(this.frameTitle) + "Unknown Event Type";
            this.mainPanel.add("Center", new ErrorPanel(buddyChat, this, rendezvousEvent));
        }
        ((Frame)((Object)this)).setTitle(this.frameTitle);
        this.boundedPanel = new BoundedPanel((Component)this.mainPanel);
        ((Container)((Object)this)).add("Center", (Component)this.boundedPanel);
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setVisible(true);
    }

    public void setEnabled(boolean bl) {
        this.boundedPanel.setEnabled(bl);
        if (bl) {
            ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
            return;
        }
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void dispose() {
        ((Component)((Object)this)).setVisible(false);
        this.buddyChat.removeChatUI(this);
        super.dispose();
    }

    public void removeNotify() {
        this.boundedPanel = null;
        this.mainPanel = null;
        this.buddyChat = null;
        this.sendPanel = null;
        this.receivePanel = null;
        this.errorPanel = null;
    }
}

