/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous;

import component.FolderInfo;
import component.SetupUI;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import main.Oscar;
import module.Module;
import module.ModuleSelector;
import module.Modules;
import module.rendezvous.RendezvousConverter;
import snac.TLV;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmChannelEvent;
import tool.icbm.IcbmChannelListener;
import tool.icbm.IcbmSubModule;
import tool.icbm.IcbmTool;
import tool.icbm.RendezvousConstants;
import tool.icbm.RendezvousEvent;
import tool.icbm.RendezvousListener;
import uiutil.ChangeListener;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import util.EventBus;
import util.EventBusEvent;
import util.JUtil;
import util.KeyBindings;
import util.Timer;
import util.TimerEvent;
import util.TimerListener;

public class Rendezvous
implements Module,
IcbmChannel,
IcbmChannelListener,
RendezvousListener,
RendezvousConstants,
TimerListener {
    public static String initService;
    private static final String MODULE = "Rendezvous";
    private static final int MYCHANNEL = 2;
    private static final String MODULEBUS;
    public static final String MODULE_NAME = "icbm.rendezvous";
    private static final String[] UIPACK_NAMES;
    private static final String DISPLAY_NAME = "Rendezvous Channel";
    private static final int DEFAULT_SESSION_TIMEOUT = 60;
    private int sessionTimeout = 60;
    private Vector subTools = new Vector();
    private EventBus channelBus;
    private EventBus moduleBus;
    private Hashtable sessions = new Hashtable();
    private boolean messagesEnabled;
    private int maxIncommingIcbmSize;
    private long minInterIcbmInterval;
    private int maxSenderEvil;
    private int maxReceiverEvil;
    public static String RENDEZVOUS_KEY;
    public static String SESSION_TIMEOUT_KEY;
    static /* synthetic */ Class class$tool$icbm$IcbmSubModule;
    static /* synthetic */ Class class$tool$icbm$IcbmChannelEvent;
    static /* synthetic */ Class class$tool$icbm$RendezvousEvent;

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo((Module)this, 0, "Modules", MODULE)};
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        KeyBindings keyBindings = Oscar.config.getKeyBindings("im.RendezvousModules");
        return new ModuleSelector(keyBindings, "rendezvous.", (ChangeListener)setupUI);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void receiveMessage(RendezvousEvent rendezvousEvent) {
    }

    public void sendMessage(RendezvousEvent rendezvousEvent) {
        String string = new String(rendezvousEvent.getRendezvousCookie());
        TimerEvent timerEvent = (TimerEvent)this.sessions.get(string);
        boolean bl = false;
        System.out.println("Rendezvous.sendMessage cookie = " + JUtil.bytesToHexString((byte[])rendezvousEvent.getCookie()));
        System.out.println("Rendezvous.sendMessage rendezvous cookie = " + JUtil.bytesToHexString((byte[])rendezvousEvent.getRendezvousCookie()));
        if (rendezvousEvent.getRendezvousType() == 0) {
            if (timerEvent != null) {
                this.sessions.remove(string);
                Timer.removeEvent((TimerEvent)timerEvent);
            }
            timerEvent = Timer.createEvent((String)"System", (TimerListener)this, (int)0, (Object)rendezvousEvent, (int)(this.sessionTimeout * 1000));
            this.sessions.put(string, timerEvent);
            bl = true;
        } else if (rendezvousEvent.getRendezvousType() == 1) {
            if (timerEvent != null) {
                this.sessions.remove(string);
                Timer.removeEvent((TimerEvent)timerEvent);
                bl = true;
            }
        } else if (rendezvousEvent.getRendezvousType() == 2 && timerEvent != null) {
            this.sessions.remove(string);
            Timer.removeEvent((TimerEvent)timerEvent);
            bl = true;
        }
        if (bl) {
            this.channelBus.postEvent((EventBusEvent)RendezvousConverter.encodeOutgoingEvent(rendezvousEvent));
        }
    }

    public void initiateMessage(RendezvousEvent rendezvousEvent) {
        System.out.println("Rendezvous.initiateMessage with event " + rendezvousEvent);
    }

    public void payloadError(RendezvousEvent rendezvousEvent) {
    }

    public void channelError(RendezvousEvent rendezvousEvent) {
        if (rendezvousEvent.getId() == 1106) {
            RendezvousEvent rendezvousEvent2 = rendezvousEvent;
            String string = new String(rendezvousEvent2.getRendezvousCookie());
            TimerEvent timerEvent = (TimerEvent)this.sessions.get(string);
            if (timerEvent == null) {
                System.out.println("No request to which to report an error");
                return;
            }
            this.channelBus.postEvent((EventBusEvent)RendezvousConverter.encodeOutgoingEvent(rendezvousEvent2));
        }
    }

    public void initiate(IcbmTool icbmTool) {
        Object object;
        icbmTool.register(this.getChannelNumber(), (IcbmChannel)this);
        KeyBindings keyBindings = Oscar.config.getKeyBindings(RENDEZVOUS_KEY);
        if (keyBindings != null) {
            object = keyBindings.getValueDefault(SESSION_TIMEOUT_KEY, Integer.toString(60));
            try {
                this.sessionTimeout = new Integer((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.sessionTimeout = 60;
            }
        }
        if ((object = Oscar.config.getKeyBindings("im.RendezvousModules")) == null) {
            Oscar.config.addKeyBindings("im.RendezvousModules");
            object = Oscar.config.getKeyBindings("im.RendezvousModules");
            object.setKeySeparator('#');
            object.addKeyBindings("rendezvous.tester.jar");
            object.setKeySeparator('.');
        }
        Vector vector = Modules.loadModules((KeyBindings)object, (Class)(class$tool$icbm$IcbmSubModule != null ? class$tool$icbm$IcbmSubModule : (class$tool$icbm$IcbmSubModule = Rendezvous.class$("tool.icbm.IcbmSubModule"))));
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            IcbmSubModule icbmSubModule = (IcbmSubModule)vector.elementAt(n2);
            icbmSubModule.initiate((IcbmChannel)this, "CHANNEL" + 2);
            ++n2;
        }
        this.channelBus = EventBus.joinBus((String)"CHANNELBUS");
        this.channelBus.addListenerFor((EventListener)((Object)this), class$tool$icbm$IcbmChannelEvent != null ? class$tool$icbm$IcbmChannelEvent : (class$tool$icbm$IcbmChannelEvent = Rendezvous.class$("tool.icbm.IcbmChannelEvent")));
        this.moduleBus = EventBus.joinBus((String)("CHANNEL" + 2));
        this.moduleBus.addListenerFor((EventListener)((Object)this), class$tool$icbm$RendezvousEvent != null ? class$tool$icbm$RendezvousEvent : (class$tool$icbm$RendezvousEvent = Rendezvous.class$("tool.icbm.RendezvousEvent")));
    }

    public void setDefaults(boolean bl, int n, long l, int n2, int n3) {
        this.messagesEnabled = bl;
        this.maxIncommingIcbmSize = n;
        this.minInterIcbmInterval = l;
        this.maxSenderEvil = n2;
        this.maxReceiverEvil = n3;
    }

    public int getChannelNumber() {
        return 2;
    }

    public byte[] getChannelVersion() {
        byte[] byArray = new byte[]{1};
        return byArray;
    }

    public boolean getMessagesState() {
        return this.messagesEnabled;
    }

    public int getMaxIncommingIcbmSize() {
        return this.maxIncommingIcbmSize;
    }

    public int getMaxSenderEvil() {
        return this.maxSenderEvil;
    }

    public int getMaxReceiverEvil() {
        return this.maxReceiverEvil;
    }

    public long getMinInterIcbmInterval() {
        return this.minInterIcbmInterval;
    }

    public void receiveMessage(IcbmChannelEvent icbmChannelEvent) {
        if (icbmChannelEvent.getChannel() != 2) {
            return;
        }
        RendezvousEvent rendezvousEvent = RendezvousConverter.decodeIncomingEvent(icbmChannelEvent);
        String string = new String(rendezvousEvent.getRendezvousCookie());
        TimerEvent timerEvent = (TimerEvent)this.sessions.get(string);
        boolean bl = false;
        if (rendezvousEvent.getRendezvousType() == 0) {
            if (timerEvent != null) {
                this.sessions.remove(string);
                Timer.removeEvent((TimerEvent)timerEvent);
            }
            timerEvent = Timer.createEvent((String)"System", (TimerListener)this, (int)0, (Object)rendezvousEvent, (int)(this.sessionTimeout * 1000));
            this.sessions.put(string, timerEvent);
            bl = true;
        } else if (rendezvousEvent.getRendezvousType() == 1) {
            if (timerEvent != null) {
                this.sessions.remove(string);
                Timer.removeEvent((TimerEvent)timerEvent);
                bl = true;
            }
        } else if (rendezvousEvent.getRendezvousType() == 2 && timerEvent != null) {
            this.sessions.remove(string);
            Timer.removeEvent((TimerEvent)timerEvent);
            bl = true;
        }
        if (bl) {
            this.moduleBus.postEvent((EventBusEvent)rendezvousEvent);
        }
    }

    public void sendMessage(IcbmChannelEvent icbmChannelEvent) {
    }

    public void initiateMessage(IcbmChannelEvent icbmChannelEvent) {
        if (icbmChannelEvent.getChannel() != 2) {
            return;
        }
        RendezvousEvent rendezvousEvent = RendezvousConverter.decodeIncomingEvent(icbmChannelEvent);
        if (initService != null) {
            rendezvousEvent.setRendezvousService(this.uuidFromString(initService));
        }
        rendezvousEvent.setRendezvousCookie(Oscar.bosCore.getCookie());
        this.moduleBus.postEvent((EventBusEvent)rendezvousEvent);
    }

    private byte[] uuidFromString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '-') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        byte[] byArray = null;
        try {
            byArray = JUtil.bytesFromHexString((String)string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMgr.warn((String)MODULE, (String)("UUID caused number format exception. Id=" + string2));
        }
        return byArray;
    }

    public void payloadError(IcbmChannelEvent icbmChannelEvent) {
        if (icbmChannelEvent.getChannel() != 2) {
            return;
        }
        this.moduleBus.postEvent((EventBusEvent)RendezvousConverter.decodeIncomingEvent(icbmChannelEvent));
    }

    public void channelError(IcbmChannelEvent icbmChannelEvent) {
        if (icbmChannelEvent.getChannel() != 2) {
            return;
        }
        if (icbmChannelEvent.getId() == 1105) {
            System.out.println("Rendezvous.channelError cookie = " + JUtil.bytesToHexString((byte[])icbmChannelEvent.getCookie()));
            int n = 0;
            String string = null;
            RendezvousEvent rendezvousEvent = RendezvousConverter.decodeIncomingEvent(icbmChannelEvent);
            this.moduleBus.postEvent((EventBusEvent)rendezvousEvent);
            System.out.println("Rendezvous.channelError rendezvous cookie = " + JUtil.bytesToHexString((byte[])rendezvousEvent.getRendezvousCookie()));
            TLV tLV = rendezvousEvent.getRendezvousParams();
            int n2 = 0;
            while (n2 < 6) {
                if (tLV.tlvTypePresent(n2)) {
                    n = n2;
                    string = new String(tLV.getTlvData(n));
                    break;
                }
                ++n2;
            }
            if (string == null) {
                return;
            }
            TimerEvent timerEvent = (TimerEvent)this.sessions.get(string);
            this.sessions.remove(string);
            Timer.removeEvent((TimerEvent)timerEvent);
        }
    }

    public void timerEvent(String string, int n, Object object) {
        RendezvousEvent rendezvousEvent = (RendezvousEvent)object;
        String string2 = new String(rendezvousEvent.getRendezvousCookie());
        this.sessions.remove(string2);
        System.out.println("Rendezvous: timeout for session " + string2);
        if (rendezvousEvent.getId() != 1101) {
            return;
        }
        this.channelBus.postEvent((EventBusEvent)RendezvousConverter.encodeOutgoingEvent(new RendezvousEvent((Object)this, 1101, 2, rendezvousEvent.getNickname(), null, false, null, rendezvousEvent.getRendezvousService(), 2, rendezvousEvent.getRendezvousCookie(), 1)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MODULEBUS = "CHANNEL" + 2;
        UIPACK_NAMES = new String[]{MODULE_NAME, "tool.icbm"};
        RENDEZVOUS_KEY = "IM.rendezvous";
        SESSION_TIMEOUT_KEY = "sessionTimeout";
    }
}

