/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.audit.ConsoleAuditEvent_Login;
import com.sun.management.services.audit.ConsoleAuditEvent_Logout;
import com.sun.management.services.audit.ConsoleAuditEvent_RoleLogin;
import com.sun.management.services.audit.ConsoleAuditSession;
import com.sun.management.services.authentication.LoginData;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.management.services.authentication.UserPrincipal;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.common.Debug;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

public final class AuthenticationUtility {
    public static void auditLoginEvent(ConsoleAuditSession consoleAuditSession, int n) {
        if (consoleAuditSession != null && consoleAuditSession.isAuditOn()) {
            ConsoleAuditEvent_Login consoleAuditEvent_Login = null;
            try {
                consoleAuditEvent_Login = (ConsoleAuditEvent_Login)consoleAuditSession.getAuditEvent("com.sun.management.services.audit.ConsoleAuditEvent_Login");
                consoleAuditEvent_Login.putEvent(n);
            }
            catch (Exception exception) {
                Debug.trace3((String)("AuthUtil: audit login event error: " + exception.getMessage()));
            }
        }
    }

    public static void auditLogoutEvent(ConsoleAuditSession consoleAuditSession, int n) {
        if (consoleAuditSession != null && consoleAuditSession.isAuditOn()) {
            ConsoleAuditEvent_Logout consoleAuditEvent_Logout = null;
            try {
                consoleAuditEvent_Logout = (ConsoleAuditEvent_Logout)consoleAuditSession.getAuditEvent("com.sun.management.services.audit.ConsoleAuditEvent_Logout");
                consoleAuditEvent_Logout.putEvent(n);
            }
            catch (Exception exception) {
                Debug.trace3((String)("AuthUtil: audit logout event error: " + exception.getMessage()));
            }
        }
    }

    public static void auditRoleLoginEvent(ConsoleAuditSession consoleAuditSession, int n) {
        if (consoleAuditSession != null && consoleAuditSession.isAuditOn()) {
            ConsoleAuditEvent_RoleLogin consoleAuditEvent_RoleLogin = null;
            try {
                consoleAuditEvent_RoleLogin = (ConsoleAuditEvent_RoleLogin)consoleAuditSession.getAuditEvent("com.sun.management.services.audit.ConsoleAuditEvent_RoleLogin");
                consoleAuditEvent_RoleLogin.putEvent(n);
            }
            catch (Exception exception) {
                Debug.trace3((String)("AuthUtil: audit role login event error: " + exception.getMessage()));
            }
        }
    }

    public static boolean isRoleAssumed(LoginData loginData) {
        boolean bl = false;
        try {
            UserDataObject userDataObject = (UserDataObject)loginData;
            String string = userDataObject.getRole();
            if (string != null && !string.equals("**NOROLE**")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isRoleAssumed(Subject subject) {
        Set<Principal> set;
        boolean bl = false;
        UserRolePrincipal userRolePrincipal = null;
        if (subject != null && (set = subject.getPrincipals()) != null) {
            Iterator<Principal> iterator = set.iterator();
            while (iterator.hasNext()) {
                Principal principal = iterator.next();
                if (!(principal instanceof UserRolePrincipal)) continue;
                userRolePrincipal = (UserRolePrincipal)principal;
                break;
            }
        }
        if (userRolePrincipal != null && userRolePrincipal.getRoleName() != null) {
            bl = true;
        }
        return bl;
    }

    public static Subject createSubject(LoginData loginData) {
        Subject subject = null;
        try {
            Object object = null;
            UserDataObject userDataObject = (UserDataObject)loginData;
            object = AuthenticationUtility.isRoleAssumed(loginData) ? new UserRolePrincipal(userDataObject.getUser(), userDataObject.getRole()) : new UserPrincipal(userDataObject.getUser());
            HashSet<UserPrincipal> hashSet = new HashSet<UserPrincipal>(1);
            hashSet.add((UserPrincipal)object);
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            subject = new Subject(false, hashSet, hashSet2, hashSet3);
        }
        catch (Exception exception) {
            Debug.trace3((String)("AuthUtil: could not create subject from data: " + exception.getMessage()));
        }
        return subject;
    }
}

