/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.audit.ConsoleAuditService;
import com.sun.management.services.audit.ConsoleAuditSession;
import com.sun.management.services.authentication.AuthenticationUtility;
import com.sun.management.services.authentication.CliCallbackHandler;
import com.sun.management.services.authentication.JaasVBController;
import com.sun.management.services.authentication.LoginData;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.ConsoleException;
import com.sun.management.services.common.Debug;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CliAuthenticator {
    public static final String SERVICE_NAME_PROP = "authentication.login.cliservice";
    public static final String SERVICE_NAME_DEFAULT = "ConsoleLogin";
    public static final int SLEEP_TIME = 100;
    private HttpSession session = null;
    private Locale locale = null;
    private String service_name = ConsoleConfiguration.getProperty("authentication.login.cliservice");
    private ConsoleAuditSession audit_session;

    public CliAuthenticator() {
        if (this.service_name == null) {
            Debug.trace1((String)"CliAuth: using default JAAS service name");
            this.service_name = SERVICE_NAME_DEFAULT;
        }
    }

    public Subject cliLogin(HttpServletRequest httpServletRequest, LoginData loginData) throws ConsoleException {
        Object object;
        Locale locale = httpServletRequest.getLocale();
        HttpSession httpSession = httpServletRequest.getSession();
        String string = null;
        this.audit_session = null;
        try {
            this.audit_session = ConsoleAuditService.getAuditSession(null);
        }
        catch (Exception exception) {
            Debug.trace1((String)("CliLogin: error getting audit session: " + exception.getMessage()));
        }
        String string2 = httpServletRequest.getRemoteHost();
        int n = httpServletRequest.getServerPort();
        try {
            object = (UserDataObject)loginData;
            if (object.getRole() == null && object.getRoleCredential() == null) {
                object.setRole("**NOROLE**");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = new CliCallbackHandler(httpSession, locale);
            httpSession.setAttribute(loginData.getName(), (Object)loginData);
            JaasVBController jaasVBController = new JaasVBController(httpSession, (CallbackHandler)object, this.service_name);
            Thread thread = new Thread(jaasVBController);
            thread.start();
            string = this.getJaasResponse(httpSession);
            if (string.equals("auth_success")) {
                Subject subject = (Subject)httpSession.getAttribute("subject");
                if (this.audit_session != null) {
                    this.audit_session.setIdentity(subject, string2, n);
                    AuthenticationUtility.auditLoginEvent(this.audit_session, 0);
                    if (AuthenticationUtility.isRoleAssumed(loginData)) {
                        AuthenticationUtility.auditRoleLoginEvent(this.audit_session, 0);
                    }
                }
                return subject;
            }
            if (string.equals("auth_error")) {
                Exception exception = (Exception)httpSession.getAttribute("jaasloginexception");
                ConsoleException consoleException = new ConsoleException("login failed", exception);
                throw consoleException;
            }
        }
        catch (Exception exception) {
            if (this.audit_session != null) {
                this.audit_session.setIdentity(AuthenticationUtility.createSubject(loginData), string2, n);
                AuthenticationUtility.auditLoginEvent(this.audit_session, -1);
                this.audit_session.dispose();
                this.audit_session = null;
            }
            Debug.trace1((String)("CliLogin: could not authenticate user: " + exception.getMessage()));
            throw new ConsoleException("login failed", exception);
        }
        return null;
    }

    public void cliLogout(Subject subject) throws ConsoleException {
        ConsoleException consoleException = null;
        int n = 0;
        try {
            LoginContext loginContext = new LoginContext(this.service_name, subject);
            loginContext.logout();
        }
        catch (Exception exception) {
            Debug.trace1((String)("CliLogout: logout failed" + exception.getMessage()));
            n = -1;
            consoleException = new ConsoleException("logout failed", exception);
        }
        if (this.audit_session != null) {
            AuthenticationUtility.auditLogoutEvent(this.audit_session, n);
            this.audit_session.dispose();
            this.audit_session = null;
        }
        if (consoleException != null) {
            throw consoleException;
        }
    }

    protected String getJaasResponse(HttpSession httpSession) {
        boolean bl = true;
        String string = null;
        do {
            try {
                string = (String)httpSession.getAttribute("serverconv");
                if (string != null) {
                    bl = false;
                    httpSession.removeAttribute("serverconv");
                    continue;
                }
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                Debug.trace1((String)("timed out waiting for callback responce" + exception.getMessage()));
                break;
            }
        } while (bl);
        return string;
    }
}

