/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authorization;

import com.sun.management.services.authorization.AuthorizationException;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.authorization.PrincipalTypePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;

public final class PrincipalTypeAuthorizationService
implements AuthorizationService {
    private static final String PERM_ATTRIBUTE = "permission";
    private static final String PERM_CLASS_NAME = "com.sun.management.services.authorization.PrincipalTypePermission";

    public Permission createPermission(String string, String[][] stringArray) throws AuthorizationException {
        if (string == null || !string.equals(PERM_CLASS_NAME)) {
            throw new AuthorizationException("authz_err_15", string == null ? "null" : string);
        }
        String string2 = null;
        if (stringArray != null && stringArray.length > 0 && stringArray[0][0].equals(PERM_ATTRIBUTE)) {
            string2 = stringArray[0][1];
        }
        if (string2 == null || string2.length() == 0) {
            throw new AuthorizationException("authz_err_16");
        }
        PrincipalTypePermission principalTypePermission = new PrincipalTypePermission(string2);
        return principalTypePermission;
    }

    public boolean checkPermission(Permission permission) throws AuthorizationException {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        return this.checkPermission(subject, permission);
    }

    public boolean checkPermission(Principal principal, Permission permission) throws AuthorizationException {
        if (principal == null) {
            throw new AuthorizationException("authz_err_13");
        }
        PrincipalTypePermission principalTypePermission = this.validatePermission(permission);
        return this.isPermissionGranted(principal, principalTypePermission);
    }

    public boolean checkPermission(Subject subject, Permission permission) throws AuthorizationException {
        if (subject == null) {
            throw new AuthorizationException("authz_err_11");
        }
        PrincipalTypePermission principalTypePermission = this.validatePermission(permission);
        String string = principalTypePermission.getName();
        Principal principal = AuthorizationServiceFactory.getPrincipal((Subject)subject, (String)string);
        if (principal == null) {
            return false;
        }
        return this.checkPermission(principal, permission);
    }

    private PrincipalTypePermission validatePermission(Permission permission) throws AuthorizationException {
        PrincipalTypePermission principalTypePermission = null;
        if (permission == null) {
            throw new AuthorizationException("authz_err_12");
        }
        try {
            principalTypePermission = (PrincipalTypePermission)permission;
        }
        catch (Exception exception) {
            throw new AuthorizationException("authz_err_14");
        }
        return principalTypePermission;
    }

    private boolean isPermissionGranted(Principal principal, PrincipalTypePermission principalTypePermission) {
        boolean bl = false;
        String string = principalTypePermission.getName();
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (clazz.isInstance(principal)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }
}

