/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.common;

import com.sun.management.services.common.Debug;
import java.io.File;

public class CCServiceLibrary {
    private static final String JNI_LIBRARY_NAME = "webconsole_services";
    private static boolean library_loaded = false;

    private static native void doSyslog(byte[] var0, byte[] var1, int var2, int var3, int var4);

    private static native int getUid(String var0);

    private static native int getGid(String var0);

    private static native String getPswd();

    private static native int makeExecutable(String var0);

    private static native int makePrivate(String var0, String var1, int var2);

    private static native int isAdmin();

    public static int getUserId(String string) {
        int n = -1;
        if (library_loaded) {
            if (string != null) {
                n = CCServiceLibrary.getUid(string);
            }
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
        return n;
    }

    public static int getGroupId(String string) {
        int n = -1;
        if (library_loaded) {
            if (string != null) {
                n = CCServiceLibrary.getGid(string);
            }
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
        return n;
    }

    public static void writeSyslog(String string, String string2, int n) {
        if (library_loaded) {
            if (string == null) {
                string = "<null>";
            }
            if (string2 == null) {
                string2 = "<null>";
            }
            byte[] byArray = string.getBytes();
            byte[] byArray2 = string2.getBytes();
            CCServiceLibrary.doSyslog(byArray, byArray2, byArray.length, byArray2.length, n);
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
    }

    public static String getPassword() {
        String string = null;
        if (library_loaded) {
            string = CCServiceLibrary.getPswd();
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
        return string;
    }

    public static void makeFileExecutable(String string) {
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.toLowerCase().indexOf("windows") != -1) {
            String string3 = string + ".bat";
            try {
                File file = new File(string);
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                if (file.exists()) {
                    file.renameTo(file2);
                }
            }
            catch (Exception exception) {
                Debug.trace1((String)("Unable to rename file: " + string));
            }
        }
        if (library_loaded) {
            CCServiceLibrary.makeExecutable(string);
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
    }

    public static void makeFilePrivate(String string, String string2, boolean bl) {
        String string3 = System.getProperty("os.name");
        if (string3 != null && string3.toLowerCase().indexOf("windows") != -1) {
            Debug.trace1((String)("Unable to make file private: " + string));
            return;
        }
        if (library_loaded) {
            CCServiceLibrary.makePrivate(string, string2, bl ? 1 : 0);
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
    }

    public static int isUserAdmin() {
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().indexOf("windows") != -1) {
            return 0;
        }
        int n = 1;
        if (library_loaded) {
            n = CCServiceLibrary.isAdmin();
        } else {
            Debug.trace1((String)"ServiceLibrary: library not loaded");
        }
        return n;
    }

    static {
        try {
            System.loadLibrary(JNI_LIBRARY_NAME);
            library_loaded = true;
        }
        catch (Throwable throwable) {
            Debug.trace1((String)"ServiceLibrary: error loading webconsole_services library: ", (Throwable)throwable);
        }
    }
}

