/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.logging;

import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogRecord;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleDebugHandler
extends Handler {
    private static final String PREFIX = "Log(debug): ";

    public void publish(LogRecord logRecord) {
        String string;
        Object object;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        String string2 = logRecord.getMessage();
        Object[] objectArray = logRecord.getParameters();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        String string3 = string2;
        try {
            if (resourceBundle != null) {
                string3 = resourceBundle.getString(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string3;
        try {
            string4 = MessageFormat.format(string3, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = (ConsoleLogRecord)logRecord;
            string = object.getUserName();
            if (string != null) {
                string4 = "[" + string + "] " + string4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = logRecord.getSourceClassName();
        string = logRecord.getSourceMethodName();
        Throwable throwable = logRecord.getThrown();
        int n = 0;
        Level level = logRecord.getLevel();
        if (level != null) {
            n = level.equals(Level.SEVERE) ? 1 : (level.equals(Level.WARNING) ? 2 : 3);
        }
        Debug.trace((int)n, (String)string4, (String)object, (String)string, (Throwable)throwable);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public boolean isLoggable(LogRecord logRecord) {
        return true;
    }

    private String getClassMethod() {
        String string = null;
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (stackTraceElementArray.length > 4) {
            string = stackTraceElementArray[4].getClassName() + stackTraceElementArray[4].getMethodName();
        }
        return string;
    }
}

