/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.registration.AuthType;
import com.sun.management.services.registration.AuthTypes;
import com.sun.management.services.registration.Description;
import com.sun.management.services.registration.Help;
import com.sun.management.services.registration.Icon;
import com.sun.management.services.registration.LocalizableElement;
import com.sun.management.services.registration.ManagementApp;
import com.sun.management.services.registration.Masthead;
import com.sun.management.services.registration.Name;
import com.sun.management.services.registration.Parameter;
import com.sun.management.services.registration.PermissionParam;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.ShortDescription;
import com.sun.management.services.registration.UrlDesc;
import java.io.CharArrayWriter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AppDescriptorParser
extends DefaultHandler {
    private static final String APP_XML_DTD_FILE = "Registration.dtd";
    private RegistrationInfo app = new RegistrationInfo();
    private ManagementApp mgmtApp = new ManagementApp();
    private UrlDesc urlDesc = new UrlDesc();
    private AuthType authType;
    private PermissionParam permissionParam;
    private Parameter parameter;
    private CharArrayWriter contents = new CharArrayWriter();
    private boolean hasContent = false;
    private boolean bValidate = false;

    public AppDescriptorParser() {
        this.bValidate = false;
    }

    public AppDescriptorParser(boolean bl) {
        this.bValidate = bl;
    }

    public RegistrationInfo parse(InputSource inputSource) throws IOException, SAXException, RegistrationException {
        SAXParser sAXParser;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(this.bValidate);
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RegistrationException("Could not create parser!");
        }
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setEntityResolver(this);
        SAXException sAXException = null;
        try {
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
            sAXException = sAXParseException;
        }
        catch (SAXException sAXException2) {
            sAXException = sAXException2;
        }
        catch (IOException iOException) {
            throw new RegistrationException("Parser I/O error: " + iOException.getLocalizedMessage());
        }
        this.app.setManagementApp(this.mgmtApp);
        try {
            this.app.validate();
        }
        catch (RegistrationException registrationException) {
            StringBuffer stringBuffer = new StringBuffer("The application descriptor ").append("file is invalid for the following reason:\n\t").append(registrationException.getLocalizedMessage());
            if (sAXException != null) {
                stringBuffer.append("\nThe cause of this condition is:\n\t").append(sAXException.getLocalizedMessage());
                if (sAXException instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)sAXException;
                    stringBuffer.append("\n\tError on line " + sAXParseException.getLineNumber());
                    Exception exception = sAXException.getException();
                    if (exception != null) {
                        stringBuffer.append(":  " + exception.getLocalizedMessage());
                    }
                }
            }
            throw new RegistrationException(stringBuffer.toString());
        }
        return this.app;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        String string3;
        InputSource inputSource = null;
        if (string2 != null && string2.endsWith(APP_XML_DTD_FILE) && (string3 = ConsoleConfiguration.getConsoleHomePath()) != null) {
            if (!string3.startsWith("/") && string3.startsWith(":", 1)) {
                string3 = "/" + string3;
            }
            String string4 = "File://" + string3 + "/private/system/" + APP_XML_DTD_FILE;
            inputSource = new InputSource(string4);
        }
        return inputSource;
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string2.length() == 0) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase("registrationInfo")) {
            this.app.setVersion(attributes.getValue("version"));
        } else if (string4.equalsIgnoreCase("managementApp")) {
            this.mgmtApp.setVersion(attributes.getValue("version"));
            this.mgmtApp.setCategory(attributes.getValue("category"));
            this.mgmtApp.setPackage(attributes.getValue("package"));
            this.mgmtApp.setBundle(attributes.getValue("bundle"));
            this.mgmtApp.setBundleJar(attributes.getValue("bundleJar"));
            this.mgmtApp.setNativeDir(attributes.getValue("nativeDir"));
        } else if (string4.equalsIgnoreCase("name")) {
            this.contents.reset();
            this.hasContent = true;
            Name name = new Name();
            this.setLocalizable((LocalizableElement)name, attributes);
            this.mgmtApp.setName(name);
        } else if (string4.equalsIgnoreCase("pluginName")) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string4.equalsIgnoreCase("icon")) {
            this.contents.reset();
            this.hasContent = true;
            Icon icon = new Icon();
            this.setLocalizable((LocalizableElement)icon, attributes);
            this.mgmtApp.setIcon(icon);
        } else if (string4.equalsIgnoreCase("shortDescription")) {
            this.contents.reset();
            this.hasContent = true;
            ShortDescription shortDescription = new ShortDescription();
            this.setLocalizable((LocalizableElement)shortDescription, attributes);
            this.mgmtApp.setShortDescription(shortDescription);
        } else if (string4.equalsIgnoreCase("description")) {
            this.contents.reset();
            this.hasContent = true;
            Description description = new Description();
            this.setLocalizable((LocalizableElement)description, attributes);
            this.mgmtApp.setDescription(description);
        } else if (string4.equalsIgnoreCase("primaryProductName")) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string4.equalsIgnoreCase("secondaryProductName")) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string4.equalsIgnoreCase("versionProductName")) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string4.equalsIgnoreCase("masthead")) {
            Masthead masthead = new Masthead();
            masthead.setBundle(attributes.getValue("bundle"));
            masthead.setBundleJar(attributes.getValue("bundleJar"));
            masthead.setLogo(attributes.getValue("logo"));
            masthead.setLogoAltText(attributes.getValue("logoAltText"));
            masthead.setLogoBorder(attributes.getValue("logoBorder"));
            masthead.setLogoHeight(attributes.getValue("logoHeight"));
            masthead.setLogoWidth(attributes.getValue("logoWidth"));
            masthead.setVersionLogo(attributes.getValue("versionLogo"));
            masthead.setVersionLogoHeight(attributes.getValue("versionLogoHeight"));
            masthead.setVersionLogoWidth(attributes.getValue("versionLogoWidth"));
            String string5 = "showUserRole";
            masthead.setShowUserRole(Boolean.valueOf(attributes.getValue(string5)).booleanValue());
            string5 = "showServer";
            masthead.setShowServer(Boolean.valueOf(attributes.getValue(string5)).booleanValue());
            string5 = "showClose";
            masthead.setShowClose(Boolean.valueOf(attributes.getValue(string5)).booleanValue());
            string5 = "showHelp";
            masthead.setShowHelp(Boolean.valueOf(attributes.getValue(string5)).booleanValue());
            this.mgmtApp.setMasthead(masthead);
        } else if (string4.equalsIgnoreCase("help")) {
            Help help = new Help();
            help.setBundle(attributes.getValue("bundle"));
            help.setBundleJar(attributes.getValue("bundleJar"));
            help.setAnchor(attributes.getValue("anchor"));
            help.setPathPrefix(attributes.getValue("pathPrefix"));
            help.setHelpFileName(attributes.getValue("helpFileName"));
            help.setVersionFileName(attributes.getValue("versionFileName"));
            help.setStatus(attributes.getValue("status"));
            help.setHelpTooltip(attributes.getValue("helpTooltip"));
            help.setVersionTooltip(attributes.getValue("versionTooltip"));
            help.setMastheadTitle(attributes.getValue("mastheadTitle"));
            help.setMastheadAlt(attributes.getValue("mastheadAlt"));
            help.setWindowTitle(attributes.getValue("windowTitle"));
            help.setHeight(attributes.getValue("height"));
            help.setWidth(attributes.getValue("width"));
            String string6 = "showCloseButton";
            if (attributes.getValue(string6) != null) {
                help.setShowCloseButton(Boolean.valueOf(attributes.getValue(string6)).booleanValue());
            }
            help.setHelpLogoWidth(attributes.getValue("helpLogoWidth"));
            help.setHelpLogoHeight(attributes.getValue("helpLogoHeight"));
            help.setHelpType(attributes.getValue("helpType"));
            this.mgmtApp.setHelp(help);
        } else if (string4.equalsIgnoreCase("authTypes")) {
            this.app.setAuthTypes(new AuthTypes());
        } else if (string4.equalsIgnoreCase("authType")) {
            this.authType = new AuthType();
            this.authType.setName(attributes.getValue("name"));
        } else if (string4.equalsIgnoreCase("classType")) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string4.equalsIgnoreCase("permissionParam")) {
            this.contents.reset();
            this.hasContent = true;
            this.permissionParam = new PermissionParam();
            this.permissionParam.setName(attributes.getValue("name"));
        } else if (string4.equalsIgnoreCase("urlDesc")) {
            this.urlDesc = new UrlDesc();
        } else if (string4.equalsIgnoreCase("url")) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string4.equalsIgnoreCase("parameter")) {
            this.parameter = new Parameter();
            this.parameter.setName(attributes.getValue("name"));
            this.parameter.setValue(attributes.getValue("value"));
            this.urlDesc.addParameter(this.parameter);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string2.length() == 0) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase("name")) {
            this.mgmtApp.getName().setNameContent(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("pluginName")) {
            StringBuffer stringBuffer = new StringBuffer(this.contents.toString()).append("_").append(this.mgmtApp.getVersion());
            this.mgmtApp.setPluginName(stringBuffer.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("icon")) {
            this.mgmtApp.getIcon().setIconContent(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("shortDescription")) {
            this.mgmtApp.getShortDescription().setShortDescriptionContent(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("description")) {
            this.mgmtApp.getDescription().setDescriptionContent(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("primaryProductName")) {
            this.mgmtApp.setPrimaryProductName(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("secondaryProductName")) {
            this.mgmtApp.setSecondaryProductName(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("versionProductName")) {
            this.mgmtApp.setVersionProductName(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("authType")) {
            this.app.getAuthTypes().addAuthType(this.authType);
        } else if (string4.equalsIgnoreCase("classType")) {
            this.authType.setClassType(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("urlDesc")) {
            this.app.setUrlDesc(this.urlDesc);
        } else if (string4.equalsIgnoreCase("url")) {
            this.urlDesc.setUrl(this.contents.toString());
            this.hasContent = false;
        } else if (string4.equalsIgnoreCase("permissionParam")) {
            this.permissionParam.setPermissionParamContent(this.contents.toString());
            this.authType.addPermissionParam(this.permissionParam);
            this.hasContent = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.hasContent) {
            return;
        }
        String string = new String(cArray, n, n2);
        if ((string = string.trim()).length() > 0) {
            char[] cArray2 = string.toCharArray();
            this.contents.write(cArray2, 0, cArray2.length);
        }
    }

    public void setLocalizable(LocalizableElement localizableElement, Attributes attributes) {
        localizableElement.setLocalizable(Boolean.valueOf(attributes.getValue("localizable")).booleanValue());
    }
}

