/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.registration.AuthType;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import java.security.Permission;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

public class AppFilter {
    private Subject subject = null;
    private String type = null;
    private AuthorizationService service = null;
    private Permission permission = null;

    public boolean checkUserPermission(HttpServletRequest httpServletRequest, String string) throws RegistrationException {
        String string2 = MgmtAppRegistrationServiceFactory.getPluginName((String)string);
        RegistrationInfo registrationInfo = MgmtAppRegistrationServiceFactory.getRegistrationInfo((String)string2);
        return this.checkUserPermission(httpServletRequest, registrationInfo);
    }

    public boolean checkUserPermission(HttpServletRequest httpServletRequest, RegistrationInfo registrationInfo) throws RegistrationException {
        boolean bl = true;
        this.subject = this.getSubject(httpServletRequest);
        this.getAuthType(registrationInfo);
        if (this.type != null && this.service != null) {
            try {
                bl = this.service.checkPermission(this.subject, this.permission);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public String getAuthType(RegistrationInfo registrationInfo) {
        this.type = null;
        this.service = null;
        this.permission = null;
        ArrayList arrayList = registrationInfo.getAuthTypes().getAuthTypeList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AuthType authType = (AuthType)arrayList.get(i);
            if (!authType.isSet()) {
                this.type = authType.getName();
                return this.type;
            }
            String string = authType.getClassType();
            String[][] stringArray = authType.getPermissionParams();
            AuthorizationService authorizationService = null;
            try {
                authorizationService = AuthorizationServiceFactory.getAuthorizationService((String)authType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (authorizationService == null) continue;
            this.type = authType.getName();
            this.service = authorizationService;
            try {
                this.permission = authorizationService.createPermission(string, stringArray);
            }
            catch (Exception exception) {}
            break;
        }
        return this.type;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String getType() {
        return this.type;
    }

    private Subject getSubject(HttpServletRequest httpServletRequest) throws RegistrationException {
        Subject subject = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            subject = sSOToken.getSubject();
        }
        catch (Exception exception) {
            throw new RegistrationException("er_nosubject", exception.getLocalizedMessage());
        }
        return subject;
    }
}

