/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.AppFilter;
import com.sun.management.services.registration.Category;
import com.sun.management.services.registration.CategoryApp;
import com.sun.management.services.registration.CategoryElement;
import com.sun.management.services.registration.ManagementApp;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;

public class CategoryUtility {
    private static CategoryElement[] cats = null;
    private static String[] syscatNames = null;
    private static Object osync = new Object();
    private static long lastRegTime = 0L;
    private static final String CONSOLE_NAME = "console";
    private static final String OTHER_CATEGORY = "Other";
    private static final String CATEGORY_PROP = "category.name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategoryElement[] getCategorizedApplications() {
        CategoryElement[] categoryElementArray = osync;
        synchronized (osync) {
            CategoryApp categoryApp;
            String string;
            String string2;
            Map.Entry entry;
            RegistrationInfo registrationInfo;
            String string3;
            Object object;
            String[] stringArray;
            String string4;
            if (cats != null) {
                // ** MonitorExit[var6] (shouldn't be in output)
                return cats;
            }
            // ** MonitorExit[var6] (shouldn't be in output)
            categoryElementArray = osync;
            synchronized (categoryElementArray) {
                if (syscatNames == null) {
                    CategoryUtility.getSystemCategoryNames();
                }
            }
            categoryElementArray = new CategoryElement[]{};
            ArrayList<Category> arrayList = new ArrayList<Category>();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            MgmtAppRegistrationService mgmtAppRegistrationService = MgmtAppRegistrationServiceFactory.getRegistrationService();
            if (mgmtAppRegistrationService == null) {
                Debug.trace1((String)"CatUtil: no registration service");
                return categoryElementArray;
            }
            String string5 = CONSOLE_NAME;
            String string6 = mgmtAppRegistrationService.getPluginName(CONSOLE_NAME);
            RegistrationInfo registrationInfo2 = null;
            ManagementApp managementApp = null;
            if (string5 != null) {
                registrationInfo2 = mgmtAppRegistrationService.getRegistrationInfo(string6);
                managementApp = registrationInfo2.getManagementApp();
            }
            if (syscatNames.length > 0) {
                for (int i = 0; i < syscatNames.length; ++i) {
                    string4 = syscatNames[i] + "+";
                    treeMap.put(string4, string4);
                }
            }
            if ((stringArray = mgmtAppRegistrationService.getAllRegisteredApps()) != null && stringArray.length > 0) {
                object = new AppFilter();
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = stringArray[i];
                    String string7 = mgmtAppRegistrationService.getRegisteredAppDir(string3);
                    registrationInfo = mgmtAppRegistrationService.getRegistrationInfo(string3);
                    entry = registrationInfo.getManagementApp();
                    if (mgmtAppRegistrationService.isAppRegistered(string3)) {
                        string2 = CategoryUtility.getCategoryName(entry.getCategory());
                        string4 = string2 + "+" + string3;
                        string = new CategoryApp(string7, string2);
                        string.setPluginName(string3);
                        string.setUrl(registrationInfo.getUrlDesc().getUrl());
                        string.setBundleName(entry.getBundle());
                        string.setNameKey(entry.getName().getNameContent());
                        string.setNameLocalizable(entry.getName().isLocalizable());
                        string.setTooltipKey(null);
                        string.setAuthType(((AppFilter)object).getAuthType(registrationInfo));
                        string.setAuthPerm(((AppFilter)object).getPermission());
                        categoryApp = entry.getDescription();
                        if (categoryApp != null) {
                            String string8 = categoryApp.getDescriptionContent();
                            boolean bl = categoryApp.isLocalizable();
                            string.setDescKey(string8);
                            string.setDescLocalizable(bl);
                            if (!bl) {
                                string.setDesc(string8);
                            }
                        }
                        treeMap.put(string4, string);
                        continue;
                    }
                    Debug.trace1((String)("CatUtil: app not registered: " + string7));
                }
            }
            if ((object = treeMap.entrySet()) != null && object.size() > 0) {
                Iterator iterator = object.iterator();
                String string9 = "";
                registrationInfo = null;
                while (iterator.hasNext()) {
                    entry = (Map.Entry)iterator.next();
                    string = (String)entry.getKey();
                    categoryApp = null;
                    int n = string.indexOf("+");
                    if (n >= 0) {
                        string2 = string.substring(0, n);
                        if (n < string.length() - 1) {
                            string3 = string.substring(n + 1);
                            categoryApp = (CategoryApp)entry.getValue();
                        } else {
                            string3 = null;
                        }
                    } else {
                        Debug.trace1((String)("CatUtil: bad sort name: " + string));
                        continue;
                    }
                    if (!string9.equalsIgnoreCase(string2)) {
                        Category category = new Category(string2);
                        if (string3 == null) {
                            category.setOrderNumber(CategoryUtility.getOrderNumber(string2));
                            category.setSystemCategory(true);
                        } else {
                            category.setSystemCategory(false);
                        }
                        arrayList.add(category);
                        string9 = string2;
                        registrationInfo = category;
                        Debug.trace2((String)("Adding system category: " + string2));
                    }
                    if (string3 == null) continue;
                    registrationInfo.addElement((CategoryElement)categoryApp);
                    Debug.trace2((String)("Adding application category: " + categoryApp.getName()));
                }
            }
            Object object2 = osync;
            synchronized (object2) {
                cats = new CategoryElement[arrayList.size()];
                cats = arrayList.toArray(cats);
            }
            return cats;
        }
    }

    public static CategoryElement[] getCategorizedApplications(Subject subject) {
        CategoryElement[] categoryElementArray = new CategoryElement[]{};
        CategoryElement[] categoryElementArray2 = CategoryUtility.getCategorizedApplications();
        if (categoryElementArray2 == null || categoryElementArray2.length == 0 || subject == null) {
            return categoryElementArray;
        }
        ArrayList<Category> arrayList = new ArrayList<Category>(categoryElementArray2.length);
        for (int i = 0; i < categoryElementArray2.length; ++i) {
            Category category = (Category)categoryElementArray2[i];
            Category category2 = (Category)category.copy();
            CategoryElement[] categoryElementArray3 = category.getApplications();
            boolean bl = false;
            if (categoryElementArray3 != null && categoryElementArray3.length > 0) {
                for (int j = 0; j < categoryElementArray3.length; ++j) {
                    CategoryApp categoryApp = (CategoryApp)categoryElementArray3[j];
                    if (!categoryApp.checkAccess(subject)) continue;
                    category2.addElement(categoryApp.copy());
                    bl = true;
                }
            }
            if (!category.isSystemCategory() && !bl) continue;
            arrayList.add(category2);
        }
        categoryElementArray = new CategoryElement[arrayList.size()];
        categoryElementArray = arrayList.toArray(categoryElementArray);
        return categoryElementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRegistrationTimestamp() {
        Object object = osync;
        synchronized (object) {
            return lastRegTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRegistrationTimestamp() {
        Object object = osync;
        synchronized (object) {
            lastRegTime = System.currentTimeMillis();
            cats = null;
        }
    }

    private static void getSystemCategoryNames() {
        syscatNames = ConsoleConfiguration.getPropertyList(CATEGORY_PROP);
        if (syscatNames == null) {
            syscatNames = new String[0];
        }
    }

    private static int getOrderNumber(String string) {
        int n = 0;
        for (int i = 0; i < syscatNames.length; ++i) {
            if (!string.equalsIgnoreCase(syscatNames[i])) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    private static String getCategoryName(String string) {
        String string2 = OTHER_CATEGORY;
        if (string != null && string.length() > 0) {
            for (int i = 0; i < syscatNames.length; ++i) {
                if (!string.equalsIgnoreCase(syscatNames[i])) continue;
                string2 = syscatNames[i];
                break;
            }
        }
        return string2;
    }
}

