/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.session;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpSession;

public class SessionTimeoutManager {
    private final TreeMap entryTreeMap = new TreeMap();
    private final HashMap entryHashMap = new HashMap();
    private TimeoutThread timeoutThread = null;
    private long timeToNextTimeout = Long.MAX_VALUE;
    private static final int DEFAULT_TIMEOUT_VALUE = 15;
    private static final String DEFAULT_TIMEOUT_PROP = "session.timeout.value";
    private static int sessiontimeout = 15;
    private static SessionTimeoutManager manager = new SessionTimeoutManager();

    private SessionTimeoutManager() {
        try {
            String string = ConsoleConfiguration.getProperty(DEFAULT_TIMEOUT_PROP);
            sessiontimeout = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Debug.trace1((String)"SessionTimeoutManager: invalid timeout property value");
        }
        if (sessiontimeout > 10080) {
            sessiontimeout = 10080;
        }
        sessiontimeout = sessiontimeout * 60 * 1000;
    }

    public static SessionTimeoutManager getInstance() {
        return manager;
    }

    synchronized void updateTimeout(HttpSession httpSession) {
        String string = (String)httpSession.getAttribute("tokenID");
        if (string == null) {
            throw new IllegalArgumentException("Token_ID does not exist  in HttpSession");
        }
        Entry entry = (Entry)this.entryHashMap.get(string);
        if (entry == null) {
            throw new IllegalArgumentException("No Entry maches the Token_ID");
        }
        if (entry != null) {
            this.removeEntry(entry);
        }
        entry.addSession(httpSession);
        this.addEntry(entry);
    }

    synchronized boolean isTimeout(String string) {
        if (string == null) {
            return false;
        }
        Entry entry = (Entry)this.entryHashMap.get(string);
        if (entry != null) {
            this.removeEntry(entry);
            entry.recalcTimeout();
            this.addEntry(entry);
            return false;
        }
        return true;
    }

    public synchronized void login(HttpSession httpSession) {
        String string = (String)httpSession.getAttribute("tokenID");
        if (string == null) {
            throw new IllegalArgumentException("tokenId string cannot be null");
        }
        Entry entry = (Entry)this.entryHashMap.get(string);
        if (entry != null) {
            throw new IllegalArgumentException("tokenId alread exists");
        }
        entry = new Entry(string);
        entry.addSession(httpSession);
        this.addEntry(entry);
    }

    public synchronized void logout(HttpSession httpSession) {
        String string = (String)httpSession.getAttribute("tokenID");
        if (string == null) {
            throw new IllegalArgumentException("SSO Token not found");
        }
        Entry entry = (Entry)this.entryHashMap.get(string);
        if (entry != null) {
            this.timeoutEntry(entry);
        }
    }

    private void removeEntry(Entry entry) {
        this.entryHashMap.remove(entry.getId());
        this.entryTreeMap.remove(entry);
    }

    private void addEntry(Entry entry) {
        this.entryHashMap.put(entry.getId(), entry);
        this.entryTreeMap.put(entry, entry);
        this.calctimeToNextTimeout();
    }

    private void timeoutEntry(Entry entry) {
        this.removeEntry(entry);
        entry.timeout();
        this.calctimeToNextTimeout();
    }

    private void calctimeToNextTimeout() {
        long l = Long.MAX_VALUE;
        long l2 = System.currentTimeMillis();
        while (this.entryTreeMap.size() > 0) {
            Entry entry = (Entry)this.entryTreeMap.lastKey();
            if (l2 >= entry.timeOutTime) {
                this.removeEntry(entry);
                entry.timeout();
                continue;
            }
            l = entry.timeOutTime;
            break;
        }
        if (this.timeoutThread == null && l < Long.MAX_VALUE) {
            this.createTimeoutThread();
        } else if (this.timeToNextTimeout > l || l == Long.MAX_VALUE) {
            this.notifyAll();
        }
        this.timeToNextTimeout = l;
    }

    private void createTimeoutThread() {
        this.timeoutThread = new TimeoutThread();
        this.timeoutThread.start();
    }

    private class TimeoutThread
    extends Thread {
        public TimeoutThread() {
            super("SessionManager timeout");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    SessionTimeoutManager sessionTimeoutManager = SessionTimeoutManager.this;
                    synchronized (sessionTimeoutManager) {
                        long l = System.currentTimeMillis();
                        while (SessionTimeoutManager.this.timeToNextTimeout > l) {
                            if (SessionTimeoutManager.this.timeToNextTimeout == Long.MAX_VALUE) {
                                SessionTimeoutManager.this.timeoutThread = null;
                                return;
                            }
                            SessionTimeoutManager.this.wait(SessionTimeoutManager.this.timeToNextTimeout - l);
                            l = System.currentTimeMillis();
                        }
                        try {
                            Entry entry = (Entry)SessionTimeoutManager.this.entryTreeMap.lastKey();
                            if (entry.timeOutTime <= l) {
                                SessionTimeoutManager.this.timeoutEntry(entry);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Debug.trace1((String)"no keys");
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class Entry
    implements Comparable {
        private long timeOutTime = Long.MAX_VALUE;
        private String id;
        private HashMap sessionMap = new HashMap(5);

        public Entry(String string) {
            this.id = string;
        }

        public String getId() {
            return this.id;
        }

        public void recalcTimeout() {
            this.timeOutTime = System.currentTimeMillis() + (long)sessiontimeout;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            Entry entry = (Entry)object;
            if (this.timeOutTime < entry.timeOutTime) {
                return 1;
            }
            return -1;
        }

        public void addSession(HttpSession httpSession) {
            String string = httpSession.getId();
            if (this.sessionMap.get(string) == null) {
                httpSession.setMaxInactiveInterval(-1);
                this.sessionMap.put(string, httpSession);
            }
            this.recalcTimeout();
        }

        public void timeout() {
            Collection collection = this.sessionMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                HttpSession httpSession = (HttpSession)iterator.next();
                try {
                    httpSession.removeAttribute("tokenID");
                    httpSession.invalidate();
                }
                catch (Exception exception) {}
            }
            this.logout();
        }

        private void logout() {
            try {
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                SSOToken sSOToken = sSOTokenManager.createSSOToken(this.id);
                try {
                    LoginContext loginContext = new LoginContext("ConsoleLogin", sSOToken.getSubject());
                    loginContext.logout();
                }
                catch (Exception exception) {
                    Debug.trace1((String)("Error logging out session: " + exception.getMessage()));
                }
                sSOTokenManager.destroyToken(sSOToken);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Debug.trace1((String)exception.getMessage(), (Throwable)exception);
            }
        }

        public void dump() {
            System.out.println("**** +++++++++++++++++++ ");
            Collection collection = this.sessionMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                HttpSession httpSession = (HttpSession)iterator.next();
                System.out.println("**** session ID: " + httpSession.getId());
                System.out.println("**** session isNew: " + httpSession.isNew());
            }
            System.out.println("**** ------------------- ");
        }
    }
}

