/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config.tomcat;

import com.sun.web.console.config.ConsoleConfigModule51;
import com.sun.web.console.config.tomcat.ManagerRolePrincipal;
import com.sun.web.console.config.tomcat.ManagerUserPrincipal;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ManagerLoginModule
implements LoginModule {
    private static final String MANAGER_ROLE = "manager";
    private static final String PASS_FILE = "passfile";
    private Subject subject;
    private CallbackHandler cbh;
    private Map state;
    private Map options;
    private boolean succeeded;
    private boolean commitSucceeded;
    private String user;
    private String pswd;
    private String path;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.cbh = callbackHandler;
        this.state = map;
        this.options = map2;
        this.user = null;
        this.pswd = null;
        this.path = null;
        if (this.options != null) {
            this.path = (String)this.options.get(PASS_FILE);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
    }

    public boolean login() throws LoginException {
        if (this.path == null) {
            String string = "Initialization options missing";
            throw new LoginException(string);
        }
        Callback[] callbackArray = new Callback[2];
        NameCallback nameCallback = null;
        PasswordCallback passwordCallback = null;
        try {
            nameCallback = new NameCallback("User", "User");
            passwordCallback = new PasswordCallback("Password", false);
            callbackArray[0] = nameCallback;
            callbackArray[1] = passwordCallback;
            this.cbh.handle(callbackArray);
        }
        catch (Exception exception) {
            String string = "Callback error: " + exception.getMessage();
            LoginException loginException = new LoginException(string);
            loginException.initCause(exception);
            throw loginException;
        }
        this.user = nameCallback.getName();
        char[] cArray = passwordCallback.getPassword();
        if (cArray != null && cArray.length > 0) {
            this.pswd = new String(cArray);
        }
        if (this.user == null || this.pswd == null) {
            String string = "No login data returned from callback handler";
            throw new LoginException(string);
        }
        String string = "Authentication failed";
        String string2 = null;
        String string3 = this.readPassfileEntry(this.path, this.user);
        if (string3 != null && string3.length() > 2) {
            try {
                ConsoleConfigModule51 consoleConfigModule51 = new ConsoleConfigModule51();
                string2 = consoleConfigModule51.get51Format(string3, this.pswd);
                this.succeeded = string3.equals(string2);
            }
            catch (Exception exception) {
                string = "Error generating hash: " + exception.getMessage();
            }
        }
        if (!this.succeeded) {
            throw new LoginException(string);
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.succeeded && this.subject != null) {
            ManagerUserPrincipal managerUserPrincipal = new ManagerUserPrincipal(this.user);
            ManagerRolePrincipal managerRolePrincipal = new ManagerRolePrincipal(MANAGER_ROLE);
            Set<Principal> set = this.subject.getPrincipals();
            set.add(managerUserPrincipal);
            set.add(managerRolePrincipal);
            this.commitSucceeded = true;
        }
        return this.succeeded;
    }

    public boolean abort() throws LoginException {
        if (this.commitSucceeded) {
            this.logout();
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.subject != null) {
            Object[] objectArray = this.subject.getPrincipals().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof ManagerUserPrincipal) {
                    this.subject.getPrincipals().remove(objectArray[i]);
                }
                if (!(objectArray[i] instanceof ManagerRolePrincipal)) continue;
                this.subject.getPrincipals().remove(objectArray[i]);
            }
        }
        return true;
    }

    private String readPassfileEntry(String string, String string2) throws LoginException {
        String string3 = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        File file = new File(string);
        try {
            fileInputStream = new FileInputStream(file.getCanonicalPath());
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((string4 = string4.trim()).length() == 0 || string4.startsWith("#") || (stringArray = string4.split(":")).length < 2 || !string2.equals(stringArray[0])) continue;
                string3 = stringArray[1];
                break;
            }
        }
        catch (Exception exception) {
            throw new LoginException("Error reading passfile: " + exception.getMessage());
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string3;
    }
}

