/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.login;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.audit.ConsoleAuditService;
import com.sun.management.services.audit.ConsoleAuditSession;
import com.sun.management.services.authentication.AuthenticationUtility;
import com.sun.management.services.authentication.ConsoleCallbackHandler;
import com.sun.management.services.authentication.JaasVBController;
import com.sun.management.services.authentication.LoginData;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.management.services.session.SessionTimeoutManager;
import com.sun.web.console.login.ConsoleAppException;
import com.sun.web.console.login.LoginClientSniffer;
import com.sun.web.console.login.LoginError;
import java.security.Principal;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class LoginControlBean {
    protected static final String ERROR_DATA = "error_data";
    protected static final String LOGIN_CURRVB = "com.sun.web.console.login.currvb";
    protected static final String LOGIN_PSYNC = "com.sun.web.console.login.psync";
    protected static final String LOGIN_PSTATE = "com.sun.web.console.login.pstate";
    protected static final String LOGIN_PS_START = "START";
    protected static final String LOGIN_PS_FINISH = "FINISH";
    protected static final String LOGIN_PS_DATA = "DATA";
    protected static final String LOGIN_PS_ERROR = "ERROR";
    private static final String RESTART_PAGE = "/jsp/login/BeginLogin.jsp";
    private static final String JAAS_SERVICE_NAME = "ConsoleLogin";
    private static final String FACES_MAPPING = "/faces";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginLogin(PageContext pageContext) throws ServletException {
        Object object;
        HttpSession httpSession;
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        try {
            ServletContext servletContext = pageContext.getServletContext();
            httpServletRequest = (HttpServletRequest)pageContext.getRequest();
            httpServletResponse = (HttpServletResponse)pageContext.getResponse();
            httpSession = httpServletRequest.getSession(true);
        }
        catch (Exception exception) {
            throw new ServletException("Error initializing begin method: " + exception.getMessage());
        }
        String[] stringArray = new String[]{""};
        this.setRedirectURL(httpServletRequest);
        Debug.trace2((String)"Begin display new ...");
        LoginClientSniffer loginClientSniffer = new LoginClientSniffer(httpServletRequest);
        if (loginClientSniffer.isNav4()) {
            Debug.trace2((String)"Netscape Navigator 4.x is not a supported browser");
            String string = "";
            string = loginClientSniffer.isSun() ? "webconsole.unsupportedbrowser_sundetail" : (loginClientSniffer.isWin() ? "webconsole.unsupportedbrowser_windetail" : "webconsole.unsupportedbrowser_linuxdetail");
            this.setLoginError(httpSession, "webconsole.unsupportedbrowser_summary", string, "error", stringArray);
            String string2 = "/console/faces/jsp/login/UnsupportedBrowser.jsp";
            try {
                httpServletResponse.sendRedirect(string2);
                return;
            }
            catch (Exception exception) {
                Debug.trace1((String)"Unexpected error redirecting to: /console/faces/jsp/login/UnsupportedBrowser.jsp");
                return;
            }
        }
        String string = null;
        LoginError loginError = LoginControlBean.getLoginError(httpSession);
        if (loginError == null) {
            string = httpServletRequest.getParameter("ConsoleLogout");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.setLoginError(httpSession, "logout_summary", "logout_detail", "info", stringArray);
            } else {
                string = httpServletRequest.getParameter("ConsoleTimeout");
                if (string != null && string.equalsIgnoreCase("true")) {
                    this.setLoginError(httpSession, "timeout_summary", "timeout_detail", "info", stringArray);
                }
            }
        }
        String string3 = RESTART_PAGE;
        Thread thread = null;
        httpSession.setMaxInactiveInterval(-1);
        Object object2 = object = this.getLoginSynchronizer(httpSession);
        synchronized (object2) {
            thread = (Thread)httpSession.getAttribute("loginThread");
            if (thread == null || !thread.isAlive()) {
                if (this.alreadyLoggedIn(httpSession)) {
                    Debug.trace2((String)"Session already exists...");
                    String string4 = this.getRedirectURL(httpSession);
                    this.takeSuccessActionInternal(httpServletRequest, httpServletResponse, string4);
                    return;
                }
                Debug.trace2((String)"Starting new JAAS thread...");
                httpSession.setAttribute(LOGIN_PSTATE, (Object)LOGIN_PS_START);
                try {
                    thread = this.startLoginThread(httpSession, httpServletRequest.getLocale());
                }
                catch (Exception exception) {
                    ConsoleAppException consoleAppException = new ConsoleAppException("jaas_start_error", exception.getMessage());
                    String string5 = consoleAppException.getMessage();
                    Debug.trace1((String)string5);
                    this.setSystemError(httpSession, string5);
                    this.gotoErrorPage(httpServletResponse);
                    return;
                }
            }
        }
        Debug.trace3((String)("WAITING FOR CALLBACK RESPONSE IN : " + string3));
        object2 = this.getCallbackResponse(thread, httpSession);
        Debug.trace3((String)("DONE WAITING FOR CALLBACK: " + (String)object2));
        if (object2 != null && ((String)object2).indexOf("forward_to") != -1) {
            int n = ((String)object2).lastIndexOf(":");
            String string6 = ((String)object2).substring(n + 1);
            httpSession.setAttribute(LOGIN_CURRVB, (Object)string6);
            try {
                string6 = FACES_MAPPING + string6;
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string6);
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception exception) {
                ConsoleAppException consoleAppException = new ConsoleAppException("login_firstpage_error", exception.getMessage());
                String string7 = consoleAppException.getMessage();
                Debug.trace1((String)string7);
                this.setSystemError(httpSession, string7);
                this.gotoErrorPage(httpServletResponse);
            }
        } else {
            ConsoleAppException consoleAppException = new ConsoleAppException("jaas_invalid_status", (String)object2);
            String string8 = consoleAppException.getMessage();
            Debug.trace1((String)string8);
            this.setSystemError(httpSession, string8);
            httpSession.setAttribute(LOGIN_PSTATE, (Object)LOGIN_PS_ERROR);
            this.gotoErrorPage(httpServletResponse);
        }
    }

    public void gotoRestartPage(FacesContext facesContext, String string) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(false);
        String string2 = RESTART_PAGE;
        if (string != null && string.length() > 0) {
            string2 = string2 + "?" + "redirect_url" + "=" + string;
        }
        try {
            externalContext.redirect(externalContext.encodeResourceURL(string2));
        }
        catch (Exception exception) {
            ConsoleAppException consoleAppException = new ConsoleAppException("login_restart_error", exception.getMessage());
            String string3 = consoleAppException.getMessage();
            Debug.trace1((String)string3);
            this.setSystemError(string3);
            this.gotoErrorPage(externalContext);
        }
    }

    public String action() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        String string = this.getRedirectURL(httpSession);
        httpSession.removeAttribute(ERROR_DATA);
        LoginData loginData = (LoginData)httpSession.getAttribute("dataobject");
        String string2 = this.processData(facesContext, string, loginData);
        Debug.trace2((String)("Returning action: " + string2));
        return this.setNextPage(facesContext, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processData(FacesContext facesContext, String string, LoginData loginData) {
        Object object;
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        String string2 = facesContext.getViewRoot().getViewId();
        Locale locale = externalContext.getRequestLocale();
        Thread thread = null;
        Object object2 = object = this.getLoginSynchronizer(httpSession);
        synchronized (object2) {
            thread = (Thread)httpSession.getAttribute("loginThread");
            String string3 = (String)httpSession.getAttribute(LOGIN_PSTATE);
            String string4 = (String)httpSession.getAttribute(LOGIN_CURRVB);
            String string5 = "DATA:" + string4;
            Debug.trace3((String)("Process data, state=" + string3 + " currView=" + string4));
            if (!(string4 != null && !string2.equals(string4) || string3 != null && string3.equals("DATA:" + string4))) {
                if (thread != null && thread.isAlive()) {
                    Debug.trace3((String)"Notifying JAAS thread...");
                    httpSession.setAttribute(LOGIN_PSTATE, (Object)string5);
                    httpSession.setAttribute("dataobject", (Object)loginData);
                    Thread thread2 = thread;
                    synchronized (thread2) {
                        httpSession.removeAttribute("serverconv");
                        httpSession.setAttribute("clientconv", (Object)"data_entry_complete");
                        thread.notifyAll();
                    }
                }
                if (this.alreadyLoggedIn(httpSession)) {
                    Debug.trace3((String)"Session already exists...");
                    this.takeSuccessAction(facesContext, string);
                    return null;
                }
                Debug.trace2((String)"Restarting JAAS thread...");
                try {
                    this.startLoginThread(httpSession, locale);
                    thread = (Thread)httpSession.getAttribute("loginThread");
                    httpSession.setAttribute(LOGIN_PSTATE, (Object)string5);
                    httpSession.setAttribute("dataobject", (Object)loginData);
                }
                catch (Exception exception) {
                    ConsoleAppException consoleAppException = new ConsoleAppException("jaas_restart_error", exception.getMessage());
                    String string6 = consoleAppException.getMessage();
                    Debug.trace1((String)string6);
                    this.setSystemError(string6);
                    this.gotoRestartPage(facesContext, string);
                }
            }
        }
        return this.waitForHandler(thread, facesContext, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForHandler(Thread thread, FacesContext facesContext, String string) {
        Object object;
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        String string2 = null;
        String string3 = facesContext.getViewRoot().getViewId();
        LoginData loginData = (LoginData)httpSession.getAttribute("dataobject");
        Debug.trace3((String)("WAITING FOR CALLBACK RESPONSE IN : " + string3));
        string2 = this.getCallbackResponse(thread, httpSession);
        Debug.trace3((String)("DONE WAITING FOR CALLBACK : " + string2));
        if (string2 != null) {
            if (string2.equals("auth_success")) {
                this.takeSuccessAction(facesContext, string);
                return null;
            }
            if (string2.equals("auth_error")) {
                return this.takeErrorAction(facesContext, string, loginData);
            }
            if (string2.indexOf("forward_to") != -1) {
                int n = string2.lastIndexOf(":");
                String string4 = string2.substring(n + 1);
                return this.takeForwardAction(facesContext, string, string4);
            }
        }
        Debug.trace1((String)("Unexpected state from JAAS thread: " + string2));
        String string5 = null;
        Object object2 = object = this.getLoginSynchronizer(httpSession);
        synchronized (object2) {
            string5 = (String)httpSession.getAttribute(LOGIN_PSTATE);
        }
        if (string5 != null && string5.equals(LOGIN_PS_FINISH)) {
            this.takeSuccessAction(facesContext, string);
            return null;
        }
        httpSession.setAttribute("auth_message", (Object)"ConsoleTimeout");
        return this.takeErrorAction(facesContext, string, loginData);
    }

    private Thread startLoginThread(HttpSession httpSession, Locale locale) {
        httpSession.removeAttribute("serverconv");
        httpSession.removeAttribute("jaasloginexception");
        httpSession.removeAttribute("dataobject");
        ConsoleCallbackHandler consoleCallbackHandler = new ConsoleCallbackHandler(httpSession, locale);
        JaasVBController jaasVBController = new JaasVBController(httpSession, (CallbackHandler)consoleCallbackHandler, JAAS_SERVICE_NAME);
        Thread thread = new Thread((Runnable)jaasVBController);
        thread.start();
        httpSession.setAttribute("loginThread", (Object)thread);
        return thread;
    }

    private String getRedirectURL(HttpSession httpSession) {
        String string = (String)httpSession.getAttribute("redirect_url");
        if (string != null) {
            return string.trim();
        }
        return null;
    }

    private boolean alreadyLoggedIn(HttpSession httpSession) {
        String string;
        SSOToken sSOToken = null;
        String string2 = (String)httpSession.getAttribute(LOGIN_PSTATE);
        if (string2 != null && string2.equals(LOGIN_PS_FINISH) && (string = (String)httpSession.getAttribute("tokenID")) != null) {
            try {
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                sSOToken = sSOTokenManager.createSSOToken(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sSOToken != null;
    }

    private Object getLoginSynchronizer(HttpSession httpSession) {
        Object object = null;
        try {
            object = httpSession.getAttribute(LOGIN_PSYNC);
            if (object == null) {
                object = new Object();
                httpSession.setAttribute(LOGIN_PSYNC, object);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)"Unable to access session attributes");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCallbackResponse(Thread thread, HttpSession httpSession) {
        try {
            Thread thread2 = thread;
            synchronized (thread2) {
                String string = (String)httpSession.getAttribute("serverconv");
                while (string == null) {
                    thread.wait();
                    string = (String)httpSession.getAttribute("serverconv");
                }
                return string;
            }
        }
        catch (Exception exception) {
            ConsoleAppException consoleAppException = new ConsoleAppException("jaas_waiting_error", exception.getMessage());
            Debug.trace1((String)consoleAppException.getMessage());
            return null;
        }
    }

    private void redirect(FacesContext facesContext, String string) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
        this.redirectInternal(httpServletRequest, httpServletResponse, string);
        facesContext.responseComplete();
    }

    private void redirectInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        String string2 = null;
        String string3 = httpServletRequest.getRequestURI();
        StringBuffer stringBuffer = new StringBuffer(string3.length() + 256);
        if (string != null && string.equals("/console/faces/jsp/launch/Launch.jsp")) {
            string = null;
        }
        if (string == null) {
            stringBuffer.append("/console/faces/jsp/launch/Launch.jsp");
            httpSession.removeAttribute("open_windows");
            string2 = httpServletResponse.encodeRedirectURL(stringBuffer.toString());
        } else {
            stringBuffer.append(string);
            string2 = httpServletResponse.encodeRedirectURL(stringBuffer.toString());
            httpSession.removeAttribute("redirect_url");
        }
        try {
            httpServletResponse.sendRedirect(string2);
        }
        catch (Exception exception) {
            ConsoleAppException consoleAppException = new ConsoleAppException("login_redirection_error", exception.getMessage());
            String string4 = consoleAppException.getMessage();
            Debug.trace1((String)string4);
            this.setSystemError(httpSession, string4);
            return;
        }
    }

    public static LoginData readLoginData() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        LoginData loginData = null;
        try {
            loginData = (LoginData)httpSession.getAttribute("dataobject");
        }
        catch (ClassCastException classCastException) {
            ConsoleAppException consoleAppException = new ConsoleAppException("login_dataobject_error", classCastException.getMessage());
            Debug.trace3((String)consoleAppException.getMessage());
        }
        return loginData;
    }

    public static LoginError readLoginError() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        return LoginControlBean.getLoginError(httpSession);
    }

    private static LoginError getLoginError(HttpSession httpSession) {
        LoginError loginError = null;
        try {
            loginError = (LoginError)httpSession.getAttribute(ERROR_DATA);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loginError;
    }

    private void gotoErrorPage(ExternalContext externalContext) {
        try {
            externalContext.redirect("/console/faces/jsp/login/LoginError.jsp");
        }
        catch (Exception exception) {
            ConsoleAppException consoleAppException = new ConsoleAppException("login_errorpage_error", exception.getMessage());
            Debug.trace1((String)consoleAppException.getMessage());
        }
    }

    private void gotoErrorPage(HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.sendRedirect("/console/faces/jsp/login/LoginError.jsp");
        }
        catch (Exception exception) {
            ConsoleAppException consoleAppException = new ConsoleAppException("login_errorpage_error", exception.getMessage());
            Debug.trace1((String)consoleAppException.getMessage());
        }
    }

    public void createLoginError(String string, String string2, String string3, String[] stringArray) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        this.setLoginError(httpSession, string, string2, string3, stringArray);
    }

    private void setLoginError(HttpSession httpSession, String string, String string2, String string3, String[] stringArray) {
        LoginError loginError = new LoginError();
        loginError.setSummary(string);
        loginError.setDetail(string2);
        loginError.setType(string3);
        loginError.setDetailArgs(stringArray);
        httpSession.setAttribute(ERROR_DATA, (Object)loginError);
    }

    private void setRedirectURL(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = httpServletRequest.getParameter("redirect_url");
        if (string != null && !string.startsWith("/")) {
            Debug.trace1((String)("Invalid redirect url: " + string + ". The redirect url is external to the application."));
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer;
            string = string.trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\"");
            while (stringTokenizer2.hasMoreTokens()) {
                string = stringTokenizer2.nextToken();
            }
            StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getRequestURI().length() + 256);
            stringBuffer.append(string);
            String string2 = httpServletRequest.getQueryString();
            if (string2 != null && (stringTokenizer = new StringTokenizer(string2, "&")).countTokens() > 1) {
                boolean bl = true;
                do {
                    if (bl) {
                        stringBuffer.append("?");
                        bl = false;
                    } else {
                        stringBuffer.append("&");
                    }
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("redirect_url")) continue;
                    stringBuffer.append(string3);
                } while (stringTokenizer.hasMoreTokens());
            }
            string = stringBuffer.toString();
            httpSession.setAttribute("redirect_url", (Object)string);
        } else {
            string = (String)httpSession.getAttribute("redirect_url");
            httpSession.setAttribute("redirect_url", (Object)string);
        }
    }

    private void logFailure(LoginData loginData) {
        String string = null;
        UserDataObject userDataObject = null;
        Logger logger = ConsoleLogService.getConsoleLogger();
        try {
            userDataObject = (UserDataObject)loginData;
            string = userDataObject.getUser();
        }
        catch (Exception exception) {
            string = "??";
        }
        Object[] objectArray = new String[]{string};
        try {
            logger.logrb(Level.WARNING, "LoginControlBean", " ", "com.sun.web.console.resources.Resources", "log_auth_failure", objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logResult(Subject subject) {
        Object[] objectArray;
        Object object;
        Logger logger = ConsoleLogService.getConsoleLogger();
        String string = null;
        String string2 = null;
        Object[] objectArray2 = subject.getPrincipals().toArray();
        if (objectArray2 != null) {
            for (int i = 0; i < objectArray2.length; ++i) {
                object = (Principal)objectArray2[i];
                if (i == 0) {
                    string = object.getName();
                }
                if (!(object instanceof UserRolePrincipal)) continue;
                UserRolePrincipal userRolePrincipal = (UserRolePrincipal)object;
                string2 = userRolePrincipal.getRoleName();
                string = userRolePrincipal.getUserName();
                break;
            }
        }
        if (string2 == null) {
            objectArray = new String[]{string};
            object = "log_auth_successful";
        } else {
            objectArray = new String[]{string, string2};
            object = "log_roleauth_successful";
        }
        try {
            logger.logrb(Level.INFO, "LoginControlBean", " ", "com.sun.web.console.resources.Resources", (String)object, objectArray);
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error while logging : " + exception.getMessage()));
        }
    }

    private void setSystemError(String string) {
        String[] stringArray = new String[]{string};
        this.createLoginError("system_failure", "general_auth_failure", "error", stringArray);
    }

    private void setSystemError(HttpSession httpSession, String string) {
        String[] stringArray = new String[]{string};
        this.setLoginError(httpSession, "system_failure", "general_auth_failure", "error", stringArray);
    }

    private void takeSuccessAction(FacesContext facesContext, String string) {
        Debug.trace2((String)"Login success action...");
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
        this.takeSuccessActionInternal(httpServletRequest, httpServletResponse, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSuccessActionInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2;
        Object object;
        HttpSession httpSession = httpServletRequest.getSession(true);
        Object object2 = object = this.getLoginSynchronizer(httpSession);
        synchronized (object2) {
            string2 = (String)httpSession.getAttribute(LOGIN_PSTATE);
            if (string2 != null && !string2.equals(LOGIN_PS_FINISH)) {
                Debug.trace3((String)("Creating new session, state=" + string2));
                httpSession.setAttribute(LOGIN_PSTATE, (Object)LOGIN_PS_FINISH);
                Subject subject = (Subject)httpSession.getAttribute("subject");
                try {
                    SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                    SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
                    String string3 = sSOToken.getTokenID().toString();
                    httpSession.removeAttribute("subject");
                    httpSession.removeAttribute("loginThread");
                    httpSession.removeAttribute("dataobject");
                    httpSession.removeAttribute("thisVB");
                    SessionTimeoutManager sessionTimeoutManager = SessionTimeoutManager.getInstance();
                    sessionTimeoutManager.login(httpSession);
                    try {
                        ConsoleAuditSession consoleAuditSession = ConsoleAuditService.getAuditSession((SSOToken)sSOToken);
                        if (consoleAuditSession != null) {
                            consoleAuditSession.setIdentity(subject, httpServletRequest.getRemoteHost(), httpServletRequest.getServerPort());
                            AuthenticationUtility.auditLoginEvent((ConsoleAuditSession)consoleAuditSession, (int)0);
                            if (AuthenticationUtility.isRoleAssumed((Subject)subject)) {
                                AuthenticationUtility.auditRoleLoginEvent((ConsoleAuditSession)consoleAuditSession, (int)0);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Debug.trace1((String)("Login audit failed" + exception.getMessage()));
                    }
                }
                catch (Exception exception) {
                    ConsoleAppException consoleAppException = new ConsoleAppException("login_successacton_error", exception.getMessage());
                    String string4 = consoleAppException.getMessage();
                    Debug.trace1((String)string4);
                    this.setSystemError(httpSession, string4);
                    return;
                }
                this.logResult(subject);
            }
        }
        object2 = (String)httpSession.getAttribute("tokenID");
        if (object2 != null) {
            string2 = new Cookie("tokenID", (String)object2);
            string2.setPath("/");
            string2.setSecure(true);
            httpServletResponse.addCookie((Cookie)string2);
        }
        Debug.trace3((String)("Redirecting to: " + string));
        this.redirectInternal(httpServletRequest, httpServletResponse, string);
    }

    private String takeForwardAction(FacesContext facesContext, String string, String string2) {
        Debug.trace2((String)("Take forward action to: " + string2));
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        if (string != null) {
            httpSession.setAttribute("redirect_url", (Object)string);
        }
        httpSession.setAttribute(LOGIN_CURRVB, (Object)string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String takeErrorAction(FacesContext facesContext, String string, LoginData loginData) {
        String[] stringArray;
        String string2;
        Object object;
        Debug.trace2((String)"Take error action...");
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpSession httpSession = (HttpSession)externalContext.getSession(true);
        Object object2 = object = this.getLoginSynchronizer(httpSession);
        synchronized (object2) {
            string2 = (String)httpSession.getAttribute(LOGIN_PSTATE);
            if (string2 != null && !string2.equals(LOGIN_PS_ERROR)) {
                httpSession.setAttribute(LOGIN_PSTATE, (Object)LOGIN_PS_ERROR);
                try {
                    stringArray = ConsoleAuditService.getAuditSession(null);
                    if (stringArray != null) {
                        Subject subject = AuthenticationUtility.createSubject((LoginData)loginData);
                        stringArray.setIdentity(subject, httpServletRequest.getRemoteHost(), httpServletRequest.getServerPort());
                        AuthenticationUtility.auditLoginEvent((ConsoleAuditSession)stringArray, (int)-1);
                        stringArray.dispose();
                    }
                }
                catch (Exception exception) {
                    Debug.trace1((String)"Login: login failure audit event error", (Throwable)exception);
                }
                this.logFailure(loginData);
            }
        }
        httpSession.removeAttribute("thisVB");
        boolean bl = false;
        string2 = (String)httpSession.getAttribute("auth_message");
        if (string2 != null && (string2 = string2.trim()).equals("ConsoleTimeout")) {
            bl = true;
        }
        stringArray = new String[]{""};
        if (!bl) {
            this.createLoginError("auth_failed_summary", "auth_failed_detail", "error", stringArray);
        } else {
            this.createLoginError("timeout_summary", "timeout_detail", "information", stringArray);
            this.gotoRestartPage(facesContext, string);
        }
        return null;
    }

    private String setNextPage(FacesContext facesContext, String string) {
        if (string == null) {
            facesContext.renderResponse();
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            UIViewRoot uIViewRoot = viewHandler.createView(facesContext, string);
            facesContext.setViewRoot(uIViewRoot);
            facesContext.renderResponse();
        }
        catch (Exception exception) {
            ConsoleAppException consoleAppException = new ConsoleAppException("login_nextpage_error", string, exception.getMessage());
            String string2 = consoleAppException.getMessage();
            Debug.trace1((String)string2);
            this.setSystemError(string2);
            ExternalContext externalContext = facesContext.getExternalContext();
            this.gotoErrorPage(externalContext);
            facesContext.responseComplete();
            return null;
        }
        return null;
    }
}

