/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.login;

import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.web.console.login.LoginControlBean;
import com.sun.webui.jsf.util.ClientSniffer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

public class UserLoginBean
implements Serializable {
    private String serverName;
    private String userName = null;
    private String password = null;
    private UIInput usernameField;
    private UIInput passwordField;
    private String browserType;
    private PasswordCredential pc = null;
    private static final String SUN_NAV6_CLIENT = "sunnav6";

    public String getServerName() {
        try {
            this.serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.serverName = "localhost";
        }
        return this.serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        try {
            UserDataObject userDataObject = (UserDataObject)LoginControlBean.readLoginData();
            userDataObject.setUser(string);
            userDataObject.setHost(this.serverName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.userName = "";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        try {
            this.pc = new PasswordCredential(string);
            UserDataObject userDataObject = (UserDataObject)LoginControlBean.readLoginData();
            userDataObject.setUserCredential(this.pc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.password = "";
    }

    public UIInput getUsernameField() {
        return this.usernameField;
    }

    public void setUsernameField(UIInput uIInput) {
        this.usernameField = uIInput;
    }

    public UIInput getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(UIInput uIInput) {
        this.passwordField = uIInput;
    }

    public String getBrowserType() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ClientSniffer clientSniffer = new ClientSniffer(facesContext);
        this.browserType = clientSniffer.isNav6() && clientSniffer.isSun() ? SUN_NAV6_CLIENT : "";
        return this.browserType;
    }

    public void validateData(FacesContext facesContext, UIComponent uIComponent, Object object) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        String[] stringArray = new String[]{""};
        FacesMessage facesMessage = new FacesMessage();
        LoginControlBean loginControlBean = new LoginControlBean();
        try {
            string = this.usernameField.getLocalValue().toString();
            string2 = this.passwordField.getLocalValue().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isValidData(string2) || !this.isValidData(string)) {
            bl = true;
        }
        if (bl) {
            loginControlBean.createLoginError("auth_failed_summary", "auth_failed_detail", "error", stringArray);
            this.usernameField.setValue((Object)"");
            this.passwordField.setValue((Object)"");
            throw new ValidatorException(facesMessage);
        }
    }

    private boolean isValidData(String string) {
        return string != null && string.trim().length() != 0;
    }
}

