/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.client.WorkMod51;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;

public class CIMOMLibrary {
    public static final String CIMOM_LIBRARY = "cimom";
    private static boolean library_loaded = false;
    private static Object lockObject = new Object();

    public static String getEncryptedPassword(String username, int usertype) throws CIMException {
        String encrypted_password = null;
        if (library_loaded) {
            encrypted_password = CIMOMLibrary.getPassword(username, usertype);
            if (encrypted_password == null) {
                return null;
            }
            if (encrypted_password.trim().length() < 2) {
                return "";
            }
        } else {
            Debug.trace1((String)"Cannot find user password provider library");
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)username);
        }
        byte[] sf = encrypted_password.getBytes();
        byte[] salt = new byte[]{sf[0], sf[1]};
        byte[] tf = new WorkMod51().mod51Format(new byte[20], salt);
        String tfs = new String(tf);
        if (tfs.equals(encrypted_password)) {
            return "";
        }
        return encrypted_password;
    }

    public static boolean authenticateUser(String username, String password) throws CIMException {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUserOrRole(username, password, null);
    }

    public static boolean authenticateRole(String rolename, String password, String roleuser) throws CIMException {
        if (password == null || password.trim().length() == 0 || rolename == null || rolename.trim().length() == 0 || roleuser == null || roleuser.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUserOrRole(rolename, password, roleuser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean authenticateUserOrRole(String userOrRole, String password, String roleUser) throws CIMException {
        if (library_loaded) {
            if (password == null) {
                return false;
            }
            if (password.trim().length() == 0) {
                password = "";
            }
        } else {
            Debug.trace1((String)"Cannot find user password provider library");
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)userOrRole);
        }
        boolean authenticated = false;
        try {
            Object object = lockObject;
            synchronized (object) {
                authenticated = CIMOMLibrary.doAuthenticate(userOrRole, password, roleUser);
            }
        }
        catch (Exception ex) {
            Debug.trace1((String)"Unexpected exception from native method doAuthenticate: ", (Throwable)ex);
        }
        if (!authenticated) {
            if (roleUser != null) {
                Debug.trace1((String)("CIMOMLibrary.authenticateUserOrRole : failed to authenticate role " + userOrRole + " for user " + roleUser));
            } else {
                Debug.trace1((String)("CIMOMLibrary.authenticateUserOrRole : failed to authenticate user " + userOrRole));
            }
        }
        return authenticated;
    }

    public static String writeLocalAuthenticator(String username, String dir, String value) throws CIMException {
        String filename = null;
        if (!library_loaded) {
            Debug.trace1((String)"Cannot find passwd access library");
            throw new CIMSecurityException("CIM_ERR_FAILED");
        }
        filename = CIMOMLibrary.writeLocalFile(username, dir, value);
        return filename;
    }

    public static void writeToSyslog(String message, String identity, int severity) throws CIMException {
        if (!library_loaded) {
            throw new CIMException("Cannot log");
        }
        CIMOMLibrary.doSyslog(message, identity, severity);
    }

    public static int getUid(String username) throws CIMException {
        int uid = -1;
        if (username == null || username.trim().length() == 0) {
            return uid;
        }
        if (!library_loaded) {
            throw new CIMSecurityException("CIM_ERR_FAILED");
        }
        uid = CIMOMLibrary.nativeGetUid(username);
        return uid;
    }

    public static int getGid(String username) throws CIMException {
        int gid = -1;
        if (username == null || username.trim().length() == 0) {
            return gid;
        }
        if (!library_loaded) {
            throw new CIMSecurityException("CIM_ERR_FAILED");
        }
        gid = CIMOMLibrary.nativeGetGid(username);
        return gid;
    }

    private static native String getPassword(String var0, int var1);

    private static native String writeLocalFile(String var0, String var1, String var2);

    private static native void doSyslog(String var0, String var1, int var2);

    private static native boolean doAuthenticate(String var0, String var1, String var2) throws Exception;

    private static native int nativeGetUid(String var0);

    private static native int nativeGetGid(String var0);

    static {
        try {
            System.loadLibrary(CIMOM_LIBRARY);
            library_loaded = true;
        }
        catch (SecurityException exception) {
            Debug.trace1((String)"Unexpected SecurityException: ", (Throwable)exception);
        }
        catch (UnsatisfiedLinkError exception) {
            Debug.trace1((String)"Unexpected UnsatisfiedLinkError: ", (Throwable)exception);
        }
    }
}

