/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.snmp;

public abstract class SnmpReaderWriter {
    protected int activeReaders = 0;
    protected int activeWriters = 0;
    protected int waitingReaders = 0;
    protected int waitingWriters = 0;

    protected abstract Object read_(String var1);

    protected abstract void write_();

    public Object read(String s) {
        this.beforeRead();
        Object o = this.read_(s);
        this.afterRead();
        return o;
    }

    public void write() {
        this.beforeWrite();
        this.write_();
        this.afterWrite();
    }

    protected boolean allowReader() {
        return this.waitingWriters == 0 && this.activeWriters == 0;
    }

    protected boolean allowWriter() {
        return this.activeReaders == 0 && this.activeWriters == 0;
    }

    protected synchronized void beforeRead() {
        ++this.waitingReaders;
        while (!this.allowReader()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.waitingReaders;
        ++this.activeReaders;
    }

    protected synchronized void afterRead() {
        --this.activeReaders;
        this.notifyAll();
    }

    protected synchronized void beforeWrite() {
        ++this.waitingWriters;
        while (!this.allowWriter()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.waitingWriters;
        ++this.activeWriters;
    }

    protected synchronized void afterWrite() {
        --this.activeWriters;
        this.notifyAll();
    }
}

