/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.jni;

import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.provider.jni.SolarisNativeAdapter;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;

public class JniProviderAdapter
implements ProviderProtocolAdapterIF {
    private static final String DESCRIPTION = "A JNI provider adapter";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 1;
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private boolean passAllCheck = false;

    public void initialize(ProviderCIMOMHandle pCimom) {
        this.mCimom = pCimom;
        String passAll = System.getProperty("passAllProviderCheck", "false");
        if (passAll != null) {
            this.passAllCheck = passAll.compareToIgnoreCase("true") == 0;
        }
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 1;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Object loadProvider(String pNamespace, String pName, String[] pParams, CIMClass pCimClass) throws ClassNotFoundException, CIMClassException {
        try {
            SolarisNativeAdapter provider = null;
            provider = new SolarisNativeAdapter(pName, pParams, pCimClass.getName());
            provider.getProvider().initialize((CIMOMHandle)this.mCimom);
            return provider;
        }
        catch (CIMException ce) {
            throw new CIMClassException(ce.toString(), (Object)ce);
        }
    }

    public void unloadProvider(Object pUnique) throws CIMClassException {
    }

    public ProviderAdapterIF getProviderAdapter(Object pProvider) throws CIMClassException {
        if (pProvider instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)pProvider;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }
}

