/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.sunjava;

import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.provider.sunjava.ComSunCompatibilityProvider;
import com.sun.wbem.cimom.util.DynClassLoader;
import com.sun.wbem.provider.CIMProvider;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public class SunJavaProviderAdapter
implements ProviderProtocolAdapterIF {
    private static final String DESCRIPTION = "A Java class provider adapter, for the old com.sun.wbem.provider interfaces";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 2;
    private static final String PROVIDERPATHCLASS = "solaris_providerpath";
    private static final String SYSTEMNS = "\\root\\system";
    private static final String PATHURLPROPERTY = "pathurl";
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private boolean passAllCheck = false;
    private InstanceProvider internalProvider;
    private DynClassLoader dcl = null;

    public SunJavaProviderAdapter() {
        ClassLoader cl = this.getClass().getClassLoader();
        this.dcl = cl instanceof DynClassLoader ? (DynClassLoader)cl : new DynClassLoader(cl);
    }

    void updatePath(String path) throws CIMException {
        try {
            this.dcl.addToClassPath(path);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void initialize(ProviderCIMOMHandle pCimom) {
        this.mCimom = pCimom;
        String passAll = System.getProperty("passAllProviderCheck", "false");
        if (passAll != null) {
            this.passAllCheck = passAll.compareToIgnoreCase("true") == 0;
        }
        CIMObjectPath provPath = new CIMObjectPath(PROVIDERPATHCLASS);
        provPath.setNameSpace(SYSTEMNS);
        try {
            this.internalProvider = this.mCimom.getInternalProvider();
            CIMObjectPath[] ops = this.internalProvider.enumerateInstanceNames(provPath, null);
            for (int i = 0; i < ops.length; ++i) {
                CIMObjectPath pathOp = ops[i];
                CIMProperty pathProp = (CIMProperty)pathOp.getKeys().elementAt(0);
                try {
                    String url = (String)pathProp.getValue().getValue();
                    this.updatePath(url);
                    continue;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 2;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Object loadProvider(String pNamespace, String pName, String[] pParams, CIMClass pCimClass) throws ClassNotFoundException, CIMClassException {
        try {
            Object obj = null;
            Class c = this.dcl.loadClass(pName);
            obj = c.newInstance();
            if (obj instanceof CIMProvider) {
                ComSunCompatibilityProvider provider = new ComSunCompatibilityProvider(obj);
                provider.initialize((CIMOMHandle)this.mCimom);
                return provider;
            }
        }
        catch (InstantiationException ie) {
            throw new ClassNotFoundException(ie.toString(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new CIMClassException(iae.toString(), (Object)iae);
        }
        catch (CIMException ce) {
            throw new ClassNotFoundException(ce.toString(), ce);
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS");
    }

    public void unloadProvider(Object pUnique) throws CIMClassException {
    }

    public ProviderAdapterIF getProviderAdapter(Object pProvider) throws CIMClassException {
        if (pProvider instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)pProvider;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }
}

