/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.audit;

import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.CIMOMLibrary;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.client.SolarisUserRolePrincipal;
import java.io.Serializable;
import java.security.Principal;
import javax.wbem.cim.CIMException;
import javax.wbem.client.Debug;

public class SolarisWbemAuditSession
implements WbemAuditSession,
Serializable {
    private AuditSession auditSession = null;
    private final String RMIPORT = "5987";
    private final String RMIPORTPROP = "com.sun.wbem.rmiport";

    public SolarisWbemAuditSession() {
        byte[] context = null;
        this.auditSession = new AuditSession(context);
        if (this.auditSession != null && !this.auditSession.auditOn()) {
            this.auditSession = null;
            Debug.trace1((String)"SolarisWbemAuditSession() : auditing subsytem unavailable");
        }
    }

    public SolarisWbemAuditSession(byte[] context) {
        this.auditSession = new AuditSession(context);
        if (this.auditSession != null && !this.auditSession.auditOn()) {
            this.auditSession = null;
            Debug.trace1((String)"SolarisWbemAuditSession(context) : auditing subsytem unavailable");
        }
    }

    public Object getPlatformAuditSession() throws CIMException {
        return this.auditSession;
    }

    public String getSessionId() throws CIMException {
        if (this.auditSession == null) {
            return null;
        }
        String sessionID = null;
        try {
            sessionID = this.auditSession.getSessionId();
        }
        catch (Exception ex) {
            throw new CIMException(ex.getLocalizedMessage());
        }
        return sessionID;
    }

    public boolean auditOn() {
        if (this.auditSession == null) {
            return false;
        }
        return this.auditSession.auditOn();
    }

    public byte[] exportSession() throws CIMException {
        if (this.auditSession == null) {
            return null;
        }
        byte[] es = null;
        try {
            es = this.auditSession.exportSession();
        }
        catch (Exception ex) {
            throw new CIMException(ex.getLocalizedMessage());
        }
        return es;
    }

    public void setIdentity(Principal principal, String host, int port) {
        if (principal instanceof SolarisUserRolePrincipal) {
            if (this.auditSession == null) {
                return;
            }
            SolarisUserRolePrincipal sup = (SolarisUserRolePrincipal)principal;
            String username = sup.getName();
            int uid = -1;
            int gid = -1;
            try {
                uid = CIMOMLibrary.getUid(username);
                gid = CIMOMLibrary.getGid(username);
            }
            catch (Exception ex) {
                Debug.trace3((String)"Exception getting Uid or Gid", (Throwable)ex);
            }
            this.auditSession.setUser(uid, gid, uid, gid, host, 0);
            if (sup.isRoleAssumed()) {
                String rolename = sup.getRoleName();
                uid = -1;
                gid = -1;
                try {
                    uid = CIMOMLibrary.getUid(rolename);
                    gid = CIMOMLibrary.getGid(rolename);
                }
                catch (Exception ex) {
                    Debug.trace3((String)"Exception getting Uid or Gid", (Throwable)ex);
                }
                this.auditSession.setUser(uid, gid, uid, gid, host, 1);
            }
        }
    }

    public void setIdentity(Principal principal, String host) {
        String rmiport = System.getProperty("com.sun.wbem.rmiport", "5987");
        int port = 0;
        try {
            port = Integer.parseInt(rmiport);
        }
        catch (Exception ex) {
            port = 5987;
        }
        this.setIdentity(principal, host, port);
    }

    public void setLabel(String label) throws CIMException {
    }
}

