/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sunvts.bean;

import com.sun.deg.sunvts.ms.ServerAdapter;
import com.sun.sunvts.bean.LogicalTestBean;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class HostSessionBean
implements Serializable {
    protected static final String LOAD_SESSION = "Load Session";
    protected static final String RESET_SESSION = "Reset Session";
    protected static final String SAVE_SESSION = "Save Session";
    protected static final String DELETE_SESSION = "Delete Session";
    protected static final String LIST_SESSIONS = "List Sessions";
    private String[] hostSessionCommands = null;
    private String hostSessionCommand = "";
    private String hostSessionName = "";
    private String testMode = null;
    private String defaultTestMode = "    ----    ";
    private String[] testModes = this.getTestModes();
    private String sessionType = null;
    private String[] sessionTypes = this.getSessionTypes();
    private String defaultSessionType = "    ----    ";
    private LogicalTestBean logicalTestBean;
    private Boolean chkboxValue = null;
    private static HostSessionBean hostsessionbean = null;
    private ServerAdapter serverAdapter = ServerAdapter.getServerAdapter();

    private HostSessionBean() {
    }

    public static HostSessionBean getHostSessionBean() {
        if (hostsessionbean == null) {
            hostsessionbean = new HostSessionBean();
        }
        return hostsessionbean;
    }

    public String[] getTestModes() {
        ResourceBundle messages = ResourceBundle.getBundle("com.sun.sunvts.ui.resources.Messages");
        if (this.testModes == null) {
            String DEFAULT_TEST_MODE = "    ----    ";
            String onlineStress = "Online Stress";
            String systemExerciser = "System Exerciser";
            String componentStress = "Component Stress";
            try {
                onlineStress = messages.getString("Test_Mode_OnlineStress");
                systemExerciser = messages.getString("Test_Mode_SystemExerciser");
                componentStress = messages.getString("Test_Mode_ComponentStress");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.testModes = new String[4];
            this.testModes[0] = new String(DEFAULT_TEST_MODE);
            this.testModes[1] = new String(onlineStress);
            this.testModes[2] = new String(systemExerciser);
            this.testModes[3] = new String(componentStress);
        }
        return this.testModes;
    }

    public String[] getSessionTypes() {
        ResourceBundle messages = ResourceBundle.getBundle("com.sun.sunvts.ui.resources.Messages");
        if (this.sessionTypes == null) {
            String genericType = "Generic";
            String hostSpecificType = "Host Specific";
            try {
                genericType = messages.getString("Session_Generic");
                hostSpecificType = messages.getString("Session_HostSpecific");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.sessionTypes = new String[2];
            this.sessionTypes[0] = new String(genericType);
            this.sessionTypes[1] = new String(hostSpecificType);
        }
        return this.sessionTypes;
    }

    public String[] getHostSessionCommands() {
        if (this.hostSessionCommands == null) {
            String DEFAULT_SESSION_COMMAND = "    ----    ";
            String loadSession = LOAD_SESSION;
            String resetSession = RESET_SESSION;
            String saveSession = SAVE_SESSION;
            String deleteSession = DELETE_SESSION;
            String listSessions = LIST_SESSIONS;
            try {
                ResourceBundle messages = ResourceBundle.getBundle("ResourceBundle.Messages");
                loadSession = messages.getString("Test_Session_LoadSession");
                resetSession = messages.getString("Test_Session_ResetSession");
                saveSession = messages.getString("Test_Session_SaveSession");
                deleteSession = messages.getString("Test_Session_DeleteSession");
                listSessions = messages.getString("Test_Session_ListSessions");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.hostSessionCommands = new String[6];
            this.hostSessionCommands[0] = new String(DEFAULT_SESSION_COMMAND);
            this.hostSessionCommands[1] = new String(loadSession);
            this.hostSessionCommands[2] = new String(resetSession);
            this.hostSessionCommands[3] = new String(saveSession);
            this.hostSessionCommands[4] = new String(deleteSession);
            this.hostSessionCommands[5] = new String(listSessions);
        }
        return this.hostSessionCommands;
    }

    public String getHostSessionCommand() {
        return this.hostSessionCommand;
    }

    public void setHostSessionCommand(String hostSessionCommand) {
        this.hostSessionCommand = hostSessionCommand;
    }

    public void resetHostSessionCommand() {
        this.hostSessionCommand = "";
        this.testMode = null;
        this.hostSessionName = "";
        this.setChkboxValue(null);
    }

    public String getTestMode() {
        return this.defaultTestMode;
    }

    public void setTestMode(String testMode) {
        this.testMode = testMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeHostSessionCommand() {
        if ("".equals(this.hostSessionName)) {
            if (LOAD_SESSION.equals(this.hostSessionCommand) || DELETE_SESSION.equals(this.hostSessionCommand)) {
                JOptionPane.showMessageDialog(null, "Unable to execute the " + this.hostSessionCommand + " command without session name ", "Please Select Session Name", 0);
            } else {
                JOptionPane.showMessageDialog(null, "Unable to execute the " + this.hostSessionCommand + " command without session name ", "Please Provide Session Name", 0);
            }
        }
        try {
            if (LOAD_SESSION.equals(this.hostSessionCommand)) {
                if (this.testMode.equalsIgnoreCase(this.defaultTestMode)) {
                    this.serverAdapter.loadSession(null, this.hostSessionName);
                } else {
                    this.serverAdapter.loadSession(this.testMode, this.hostSessionName);
                }
            } else if (SAVE_SESSION.equals(this.hostSessionCommand)) {
                boolean OvrWrtValue = false;
                if (this.getChkboxValue() != null) {
                    OvrWrtValue = this.getChkboxValue();
                }
                if (this.testMode.equalsIgnoreCase(this.defaultTestMode)) {
                    this.serverAdapter.saveSession(OvrWrtValue, null, this.sessionType, this.hostSessionName);
                } else {
                    this.serverAdapter.saveSession(OvrWrtValue, this.testMode, this.sessionType, this.hostSessionName);
                }
            } else if (DELETE_SESSION.equals(this.hostSessionCommand)) {
                this.serverAdapter.deleteSession(this.hostSessionName);
            }
            this.resetHostSessionCommand();
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Error on executing " + this.hostSessionCommand + " command", sunVTSException.getMessage(), 0);
        }
        finally {
            this.resetHostSessionName();
        }
    }

    public String cancelHostSessionCommand() {
        this.resetHostSessionCommand();
        this.resetHostSessionName();
        return "windowclose";
    }

    public String[] getHostSessions() {
        try {
            List hostSessionNames = this.serverAdapter.listSessions();
            if (hostSessionNames == null) {
                return new String[0];
            }
            int listSize = hostSessionNames.size();
            String[] hostSessions = new String[listSize];
            for (int count = 0; count < listSize; ++count) {
                String sessionName = (String)hostSessionNames.get(count);
                hostSessions[count] = new String(sessionName);
            }
            return hostSessions;
        }
        catch (Exception sunVTSException) {
            return new String[0];
        }
    }

    public String getHostSessionName() {
        return this.hostSessionName;
    }

    public void setHostSessionName(String hostSessionName) {
        this.hostSessionName = hostSessionName;
    }

    public void resetHostSessionName() {
        this.hostSessionName = "";
    }

    public String getHostName() {
        String hostName = null;
        LogicalTestBean logicalTestBean = this.getLogicalTestBean();
        if (logicalTestBean != null) {
            hostName = logicalTestBean.getHostName();
        }
        return hostName;
    }

    public LogicalTestBean getLogicalTestBean() {
        return this.logicalTestBean;
    }

    public Boolean getChkboxValue() {
        return this.chkboxValue;
    }

    public void setChkboxValue(Boolean chkboxValue) {
        this.chkboxValue = chkboxValue;
    }

    public String getSessionType() {
        return this.defaultSessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }
}

