/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sunvts.bean;

import com.sun.deg.sunvts.data.LTPageData;
import com.sun.deg.sunvts.data.LogicalTest;
import com.sun.deg.sunvts.ms.ServerAdapter;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class LogicalTestBean {
    private ResourceBundle messages = ResourceBundle.getBundle("com.sun.sunvts.ui.resources.Messages");
    private String testMode = null;
    private String sessionName = null;
    private ArrayList logicalTests = null;
    private String hostName = new String();
    private final String IDLE_SYSTEM_STATUS = "idle";
    private final String STOPPING_SYSTEM_STATUS = "stopping";
    private boolean stopping = false;
    private final int MEDIUM_REFRESH_INTERVAL = 20000;
    private int pageRefreshInterval = 20000;
    private String systemStatus = null;
    private String elapsedTime = null;
    private String supportInfo = null;
    private String supportSummary = null;
    private String[] testModes;
    private LTPageData ltpagedata = null;
    private ServerAdapter serverAdapter = ServerAdapter.getServerAdapter();
    private static LogicalTestBean logicalTestBean = null;

    private LogicalTestBean() {
    }

    public static LogicalTestBean getLogicalTestBean() {
        if (logicalTestBean == null) {
            logicalTestBean = new LogicalTestBean();
        }
        return logicalTestBean;
    }

    public String[] getTestModes() {
        if (this.testModes == null) {
            String onlineStress = "Online Stress";
            String systemExerciser = "System Exerciser";
            String componentStress = "Component Stress";
            try {
                onlineStress = this.messages.getString("Test_Mode_OnlineStress");
                systemExerciser = this.messages.getString("Test_Mode_SystemExerciser");
                componentStress = this.messages.getString("Test_Mode_ComponentStress");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.testModes = new String[3];
            this.testModes[0] = new String(onlineStress);
            this.testModes[1] = new String(systemExerciser);
            this.testModes[2] = new String(componentStress);
        }
        return this.testModes;
    }

    public String getTestMode() {
        return this.testMode;
    }

    public void setTestMode(String testMode) {
        this.testMode = testMode;
    }

    public String executeSetModeCommand() {
        try {
            this.serverAdapter.setMode(this.testMode);
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to execute the set mode command : \n" + sunVTSException.getMessage(), "Error on executing the set mode command", 0);
        }
        return "showLTs";
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String executeResetSessionCommand() {
        try {
            this.serverAdapter.resetSession();
            return this.showLogicalTests();
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to execute the Reset Session command : \n" + sunVTSException.getMessage(), "Error on executing the Reset Session command", 0);
            return "showLTs";
        }
    }

    public ArrayList getLogicalTests() {
        return this.logicalTests;
    }

    public void setLogicalTests(ArrayList logicalTests) {
        this.logicalTests = logicalTests;
    }

    public void doStart() {
        try {
            this.serverAdapter.start();
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to Start the Tests:" + sunVTSException.getMessage(), "Error Starting the test(s).", 0);
        }
    }

    public void doStop() {
        try {
            this.serverAdapter.stop();
            this.stopping = true;
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to Stop the Tests:" + sunVTSException.getMessage(), "Error Stopping the test(s).", 0);
        }
    }

    public void doEnableTest(Object[] objectArr) throws Exception {
        for (int i = 0; i < objectArr.length; ++i) {
            if (!objectArr[i].equals(true)) continue;
            LogicalTest logicalTest = (LogicalTest)this.logicalTests.get(i);
            this.serverAdapter.enableTest(logicalTest.getLogicalTestName());
        }
    }

    public void doDisableTest(Object[] objectArr) throws Exception {
        for (int i = 0; i < objectArr.length; ++i) {
            if (!objectArr[i].equals(true)) continue;
            LogicalTest logicalTest = (LogicalTest)this.logicalTests.get(i);
            this.serverAdapter.disableTest(logicalTest.getLogicalTestName());
        }
    }

    public String showLogicalTests() {
        try {
            this.setLogicalTests(null);
            this.ltpagedata = this.serverAdapter.getLTPageData();
            ArrayList lts = (ArrayList)this.ltpagedata.getTestList();
            this.setTestMode(this.ltpagedata.getTestMode());
            this.setSessionName(this.ltpagedata.getSessionName());
            this.setSystemStatus(this.ltpagedata.getStatus());
            this.setElapsedTime(this.ltpagedata.getElapsedTime());
            this.setSupportInfo(this.ltpagedata.getSupportInfo());
            if (lts == null || lts.size() == 0) {
                this.setLogicalTests(null);
            } else {
                this.setLogicalTests(lts);
            }
            if (this.stopping && !this.isSystemStopping()) {
                this.stopping = false;
            }
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to get the List of Tests:\n " + sunVTSException.getMessage(), "Error on getting the Lists of tests.", 0);
            System.exit(0);
        }
        return "showLTs";
    }

    public String doReset() {
        try {
            this.serverAdapter.resetTestCounters();
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to Reset: " + sunVTSException.getMessage(), "Unable to Reset.", 0);
        }
        return this.showLogicalTests();
    }

    public void doReprobe() {
        try {
            this.serverAdapter.reprobe();
            this.showLogicalTests();
            JOptionPane.showMessageDialog(null, "All the Logical Tests have been reprobed on the host.", "Reprobe done.", 1);
        }
        catch (Exception sunVTSException) {
            JOptionPane.showMessageDialog(null, "Unable to reprobe the tests: " + sunVTSException.getMessage(), "Error on reprobing the tests.", 0);
        }
    }

    public void doQuitUiKernel() throws Exception {
        this.serverAdapter.quit();
    }

    public String getVersion() {
        String version = "";
        try {
            version = this.serverAdapter.getVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public boolean isTestEnabled() {
        boolean i = false;
        if (this.isSystemNotIdle()) {
            return true;
        }
        if (this.logicalTests != null) {
            ListIterator li = this.logicalTests.listIterator();
            while (li.hasNext()) {
                LogicalTest logicalTest = (LogicalTest)this.logicalTests.get(li.nextIndex());
                if (logicalTest.isLogicalTestEnabled()) {
                    return false;
                }
                li.next();
            }
        }
        return true;
    }

    public boolean isSystemIdle() {
        return "idle".equals(this.systemStatus);
    }

    public boolean isSystemNotIdle() {
        return this.systemStatus != null && !"".equals(this.systemStatus) && !"idle".equals(this.systemStatus);
    }

    public boolean isSystemStopping() {
        return "stopping".equals(this.systemStatus);
    }

    public String showGlobalOptions() {
        return "showGlobalOptions";
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String HostName) {
        this.hostName = HostName;
    }

    public int getPageRefreshInterval() {
        return this.pageRefreshInterval;
    }

    public void setPageRefreshInterval(int pageRefreshInterval) {
        this.pageRefreshInterval = pageRefreshInterval;
    }

    public String getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(String systemStatus) {
        this.systemStatus = systemStatus;
    }

    public String getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(String elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public String getSupportInfo() {
        return this.supportInfo;
    }

    public void setSupportInfo(String supportInfo) {
        if ("".equals(supportInfo)) {
            supportInfo = null;
        }
        this.supportInfo = supportInfo;
        if (supportInfo == null) {
            this.setSupportSummary(null);
        } else {
            this.setSupportSummary(this.messages.getString("Test_SupportInfo"));
        }
    }

    public String getSupportSummary() {
        return this.supportSummary;
    }

    public void setSupportSummary(String supportSummary) {
        this.supportSummary = supportSummary;
    }
}

