/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authorization;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.authorization.AuthorizationException;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

public final class AuthorizationServiceFactory {
    private static final String AUTHZ_DEFAULT_CLASS_PROP = "authorization.default.type";
    private static final String AUTHZ_CLASS_PROP_PART1 = "authorization.";
    private static final String AUTHZ_CLASS_PROP_PART2 = ".class";
    private static final String AUTHZ_SERVICE_PACKAGE = "com.sun.management.services.authorization.";
    private static final String AUTHZ_SERVICE_SUFFIX = "AuthorizationService";
    private static HashMap table = new HashMap();

    public static AuthorizationService getAuthorizationService() throws AuthorizationException {
        return AuthorizationServiceFactory.getAuthorizationService(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthorizationService getAuthorizationService(String string) throws AuthorizationException {
        String string2 = string;
        if (string2 == null) {
            string2 = AuthorizationServiceFactory.getDefaultType();
        }
        AuthorizationService authorizationService = null;
        HashMap hashMap = table;
        synchronized (hashMap) {
            authorizationService = (AuthorizationService)table.get(string2);
            if (authorizationService == null) {
                String string3 = AuthorizationServiceFactory.getClassName(string2);
                authorizationService = AuthorizationServiceFactory.createService(string3);
                table.put(string2, authorizationService);
            }
        }
        return authorizationService;
    }

    public static String getServiceType(AuthorizationService authorizationService) {
        String string = "(null)";
        int n = AUTHZ_CLASS_PROP_PART1.length();
        int n2 = AUTHZ_CLASS_PROP_PART2.length();
        if (authorizationService != null) {
            String string2 = authorizationService.getClass().getName();
            String[] stringArray = ConsoleConfiguration.getPropertyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string3.startsWith(AUTHZ_CLASS_PROP_PART1) || !string3.endsWith(AUTHZ_CLASS_PROP_PART2)) continue;
                String string4 = ConsoleConfiguration.getProperty((String)string3);
                try {
                    if (!string2.equals(string4)) continue;
                    int n3 = string3.length() - (n + n2);
                    string = string3.substring(n, n3);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public static Principal getPrincipal(HttpServletRequest httpServletRequest, String string) {
        Principal principal = null;
        if (httpServletRequest != null) {
            Subject subject = null;
            try {
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
                subject = sSOToken.getSubject();
                principal = AuthorizationServiceFactory.getPrincipal(subject, string);
            }
            catch (Exception exception) {
                Debug.trace3("Authz: exception in getPrincipal: " + exception.getMessage());
            }
        }
        return principal;
    }

    public static Principal getPrincipal(Subject subject, String string) {
        Principal principal;
        block6: {
            principal = null;
            if (subject != null) {
                try {
                    Object[] objectArray;
                    Set<Principal> set;
                    if (string == null) {
                        set = subject.getPrincipals();
                    } else {
                        objectArray = Class.forName(string);
                        set = subject.getPrincipals(objectArray);
                    }
                    if (set == null || set.size() <= 0) break block6;
                    objectArray = set.toArray();
                    principal = (Principal)objectArray[0];
                    if (string != null || objectArray.length <= 1) break block6;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof UserRolePrincipal)) continue;
                        principal = (Principal)objectArray[i];
                        break;
                    }
                }
                catch (Exception exception) {
                    Debug.trace3("Authz: exception in getPrincipal: " + exception.getMessage());
                }
            }
        }
        return principal;
    }

    private static String getDefaultType() throws AuthorizationException {
        String string = ConsoleConfiguration.getProperty((String)AUTHZ_DEFAULT_CLASS_PROP);
        if (string == null) {
            Debug.trace1("Authz: no default service class defined");
            AuthorizationException authorizationException = new AuthorizationException("authz_err_01");
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, authorizationException.getLocalizedMessage());
            throw authorizationException;
        }
        return string;
    }

    private static String getClassName(String string) throws AuthorizationException {
        String string2 = AUTHZ_CLASS_PROP_PART1 + string + AUTHZ_CLASS_PROP_PART2;
        String string3 = ConsoleConfiguration.getProperty((String)string2);
        if (string3 == null) {
            Debug.trace1("Authz: no service class property found for type " + string + ", using name pattern");
            AuthorizationException authorizationException = new AuthorizationException("authz_err_02", string);
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, authorizationException.getLocalizedMessage());
            string3 = AUTHZ_SERVICE_PACKAGE + string + AUTHZ_SERVICE_SUFFIX;
        }
        return string3;
    }

    private static Class loadClass(String string) throws AuthorizationException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            Debug.trace1("Authz: error loading " + string + " class: " + exception.getMessage());
            AuthorizationException authorizationException = new AuthorizationException("authz_err_03", string);
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, authorizationException.getLocalizedMessage());
            throw authorizationException;
        }
        return clazz;
    }

    private static AuthorizationService createService(String string) throws AuthorizationException {
        AuthorizationService authorizationService = null;
        Class clazz = AuthorizationServiceFactory.loadClass(string);
        try {
            authorizationService = (AuthorizationService)clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.trace1("Authz: error creating " + string + " service: " + exception.getMessage());
            AuthorizationException authorizationException = new AuthorizationException("authz_err_04", string, exception.getLocalizedMessage());
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, authorizationException.getLocalizedMessage());
            throw authorizationException;
        }
        return authorizationService;
    }
}

