/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class ConsoleInfo {
    private static Object lock = new Object();
    private static String fullVersion;
    private static int major;
    private static int minor;
    private static int revision;
    private static String releaseType;
    private static String versionDate;
    private static String productName;
    private static String defaultFormat;
    private static boolean loaded;

    private static void loadVersion() {
        if (loaded) {
            return;
        }
        major = 3;
        minor = 1;
        revision = 0;
        releaseType = "";
        versionDate = "03/03/15";
        productName = "Oracle Java(TM) Web Console";
        fullVersion = String.valueOf(major) + "." + String.valueOf(minor);
        if (revision > 0) {
            fullVersion = fullVersion + "." + String.valueOf(revision);
        }
        if (releaseType != null && releaseType.trim().length() > 0) {
            fullVersion = fullVersion + "-" + releaseType;
        }
        loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProductName() {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return productName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayVersion() {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return fullVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMajorVersion() {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return major;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinorVersion() {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return minor;
        }
    }

    public static int getVersion() {
        return ConsoleInfo.getMajorVersion() * 100 + ConsoleInfo.getMinorVersion();
    }

    public static String getVersionDate(String string, Locale locale) {
        if (string == null) {
            string = defaultFormat;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
            Date date = simpleDateFormat.parse(versionDate);
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return versionDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayVersion(Locale locale) {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return fullVersion;
        }
    }

    public static String getDisplayVersion(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            return ConsoleInfo.getDisplayVersion(httpServletRequest.getLocale());
        }
        return ConsoleInfo.getDisplayVersion((Locale)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMajorVersion(Locale locale) {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return major;
        }
    }

    public static int getMajorVersion(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            return ConsoleInfo.getMajorVersion(httpServletRequest.getLocale());
        }
        return ConsoleInfo.getMajorVersion((Locale)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinorVersion(Locale locale) {
        Object object = lock;
        synchronized (object) {
            ConsoleInfo.loadVersion();
            return minor;
        }
    }

    public static int getMinorVersion(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            return ConsoleInfo.getMinorVersion(httpServletRequest.getLocale());
        }
        return ConsoleInfo.getMinorVersion((Locale)null);
    }

    public static int getVersion(Locale locale) {
        return ConsoleInfo.getMajorVersion(locale) * 100 + ConsoleInfo.getMinorVersion(locale);
    }

    public static int getVersion(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            return ConsoleInfo.getVersion(httpServletRequest.getLocale());
        }
        return ConsoleInfo.getVersion((Locale)null);
    }

    static {
        defaultFormat = "MM/dd/yy HH:mm";
        loaded = false;
    }
}

