/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.common;

import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.DebugTrace;
import com.sun.management.services.common.DebugTraceImpl;
import java.io.File;

public final class Debug {
    private static final boolean ON = true;
    private static final String TRACE_LEVEL_PROP = "debug.trace.level";
    private static final String TRACE_PATH_PROP = "debug.trace.path";
    private static final String TRACE_OPTIONS_PROP = "debug.trace.options";
    private static final String TRACE_MAXSIZE_PROP = "debug.trace.maxsize";
    private static final String TRACE_MAXFILES_PROP = "debug.trace.maxfiles";
    private static final String TRACE_STACKSIZE_PROP = "debug.trace.stacksize";
    private static final String LOG_DIR_PROP = "com.sun.web.console.logdir";
    private static final String TRACE_OPTIONS_DEFAULT = "m";
    private static final int TRACE_LEVEL_DEFAULT = 0;
    private static final int TRACE_MAXSIZE_DEFAULT = 10;
    private static final int TRACE_MAXFILES_DEFAULT = 5;
    private static final int TRACE_STACKSIZE_DEFAULT = 10;
    private static final String TRACE_FILENAME = "console_debug_log";
    private static final String TRACE_OFF_VALUE = "off";
    private static final int TRACE_OFF = 0;
    private static final int TRACE_RETRY = 5;
    private static final String TRACE_HEADER_MSG = "Debug trace created on ";
    private static boolean trace_init = false;
    private static String trace_file = null;
    private static int trace_level = 0;
    private static String trace_options = "m";
    private static int trace_maxsize = 10;
    private static int trace_maxfiles = 5;
    private static int trace_stacksize = 10;
    private static DebugTraceImpl trace_impl = null;

    public static final synchronized void traceOpen() {
        if (!trace_init) {
            Debug.getTraceProperties();
            if (trace_level > 0) {
                trace_impl = new DebugTraceImpl(trace_file, trace_level, trace_options, trace_maxsize, trace_maxfiles, trace_stacksize);
                if (trace_impl == null) {
                    trace_level = 0;
                }
                trace_impl.enableTrace(trace_level);
            }
            trace_init = true;
        }
    }

    public static final synchronized void traceClose() {
        if (trace_init) {
            if (trace_impl != null) {
                trace_impl.disableTrace();
            }
            trace_level = 0;
        }
    }

    public static DebugTrace getDebugTrace() throws Exception {
        DebugTraceImpl debugTraceImpl = null;
        if (trace_level > 0 && trace_impl != null) {
            debugTraceImpl = trace_impl;
        }
        return debugTraceImpl;
    }

    public static final boolean isOn() {
        return trace_level > 0;
    }

    public static final void trace1(String string) {
        if (trace_level > 0) {
            String[] stringArray = Debug.getClassMethodNames();
            Debug.trace(trace_level, string, stringArray[0], stringArray[1], null);
        }
    }

    public static final void trace1(String string, Throwable throwable) {
        if (trace_level > 0) {
            String[] stringArray = Debug.getClassMethodNames();
            Debug.trace(trace_level, string, stringArray[0], stringArray[1], throwable);
        }
    }

    public static final void trace2(String string) {
        if (trace_level > 1) {
            String[] stringArray = Debug.getClassMethodNames();
            Debug.trace(trace_level, string, stringArray[0], stringArray[1], null);
        }
    }

    public static final void trace2(String string, Throwable throwable) {
        if (trace_level > 1) {
            String[] stringArray = Debug.getClassMethodNames();
            Debug.trace(trace_level, string, stringArray[0], stringArray[1], throwable);
        }
    }

    public static final void trace3(String string) {
        if (trace_level > 2) {
            String[] stringArray = Debug.getClassMethodNames();
            Debug.trace(trace_level, string, stringArray[0], stringArray[1], null);
        }
    }

    public static final void trace3(String string, Throwable throwable) {
        if (trace_level > 2) {
            String[] stringArray = Debug.getClassMethodNames();
            Debug.trace(trace_level, string, stringArray[0], stringArray[1], throwable);
        }
    }

    public static final void trace(int n, String string, String string2, String string3, Throwable throwable) {
        if (trace_level >= n && trace_impl != null) {
            trace_impl.trace(n, string, string2, string3, throwable);
        }
    }

    private static void getTraceProperties() {
        String string = ConsoleConfiguration.getProperty((String)TRACE_LEVEL_PROP);
        if (string != null) {
            if (string.equalsIgnoreCase(TRACE_OFF_VALUE)) {
                trace_level = 0;
            } else {
                try {
                    trace_level = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    trace_level = 0;
                }
            }
        }
        if (trace_level == 0) {
            return;
        }
        string = ConsoleConfiguration.getProperty((String)TRACE_PATH_PROP);
        if (string == null) {
            string = ConsoleConfiguration.getConsoleLogPath();
        }
        trace_file = string + File.separator + TRACE_FILENAME;
        trace_options = ConsoleConfiguration.getProperty((String)TRACE_OPTIONS_PROP);
        if (trace_options == null) {
            trace_options = TRACE_OPTIONS_DEFAULT;
        }
        trace_maxsize = 10;
        string = ConsoleConfiguration.getProperty((String)TRACE_MAXSIZE_PROP);
        if (string != null) {
            try {
                trace_maxsize = Integer.parseInt(string);
                if (trace_maxsize < 1) {
                    trace_maxsize = 10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        trace_maxfiles = 5;
        string = ConsoleConfiguration.getProperty((String)TRACE_MAXFILES_PROP);
        if (string != null) {
            try {
                trace_maxfiles = Integer.parseInt(string);
                if (trace_maxfiles < 1) {
                    trace_maxfiles = 10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        trace_stacksize = 10;
        string = ConsoleConfiguration.getProperty((String)TRACE_STACKSIZE_PROP);
        if (string != null) {
            try {
                trace_stacksize = Integer.parseInt(string);
                if (trace_stacksize < 0) {
                    trace_stacksize = 10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String[] getClassMethodNames() {
        String[] stringArray = new String[]{"", ""};
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (stackTraceElementArray.length > 2) {
            String string;
            String string2 = stackTraceElementArray[2].getClassName();
            if (string2 != null) {
                stringArray[0] = string2;
            }
            if ((string = stackTraceElementArray[2].getMethodName()) != null) {
                stringArray[1] = string;
            }
        }
        return stringArray;
    }
}

