/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.logging;

import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.Debug;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class ConsoleLogService {
    private static final String CONSOLE_LOG_NAME = "com.sun.web.console.log";
    private static final String DEBUG_LOG_NAME = "com.sun.web";
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.management.services.logging.ConsoleDebugHandler";
    private static final String DEFAULT_RESOURCE_BUNDLE = "com.sun.management.services.logging.resources.Resources";
    private static final String DEFAULT_LEVEL = "info";
    private static final String DEBUG_HANDLER_CLASS = "com.sun.management.services.logging.ConsoleDebugHandler";
    private static final String DEBUG_LEVEL = "severe";
    private static final String DEFAULT_HANDLER_CLASS_PROP = "logging.default.handler";
    private static final String DEFAULT_RESOURCE_BUNDLE_PROP = "logging.default.resource";
    private static final String DEFAULT_LEVEL_PROP = "logging.default.level";
    private static final String DEFAULT_FILTER_CLASS_PROP = "logging.default.filter";
    private static final String DEBUG_LEVEL_PROP = "logging.debug.level";
    private static final String LEVEL_SEVERE = "severe";
    private static final String LEVEL_WARNING = "warning";
    private static final String LEVEL_INFO = "info";
    private static final String LEVEL_OFF = "off";
    private static final String LEVEL_ALL = "all";
    private static final String LEVEL_DEBUG = "debug";
    private static final String LEVEL_TRACE = "trace";
    private static final String FILTER_CLASS_NONE = "none";
    private static boolean init = false;
    private static Handler dfltHandler;
    private static Level dfltLevel;
    private static String dfltBundleName;
    private static Filter dfltFilter;
    private static Handler debugHandler;
    private static Level debugLevel;

    public static Logger getNamedLogger(String string) {
        if (!init) {
            ConsoleLogService.initialize();
        }
        if (string == null) {
            return ConsoleLogService.getDebugLogger();
        }
        if (string.equals(CONSOLE_LOG_NAME)) {
            return ConsoleLogService.getConsoleLogger();
        }
        if (string.equals(DEBUG_LOG_NAME)) {
            return ConsoleLogService.getDebugLogger();
        }
        Logger logger = Logger.getLogger(string);
        logger.setUseParentHandlers(false);
        logger.addHandler(debugHandler);
        logger.setLevel(dfltLevel);
        logger.setFilter(dfltFilter);
        LogManager logManager = LogManager.getLogManager();
        logManager.addLogger(logger);
        return logger;
    }

    public static Logger getConsoleLogger() {
        if (!init) {
            ConsoleLogService.initialize();
        }
        Logger logger = Logger.getAnonymousLogger(dfltBundleName);
        logger.setUseParentHandlers(false);
        logger.addHandler(dfltHandler);
        logger.setLevel(dfltLevel);
        logger.setFilter(dfltFilter);
        return logger;
    }

    public static Logger getDebugLogger() {
        if (!init) {
            ConsoleLogService.initialize();
        }
        Logger logger = Logger.getLogger(DEBUG_LOG_NAME);
        logger.setUseParentHandlers(false);
        logger.addHandler(debugHandler);
        logger.setLevel(debugLevel);
        LogManager logManager = LogManager.getLogManager();
        logManager.addLogger(logger);
        return logger;
    }

    private static synchronized void initialize() {
        String string = ConsoleConfiguration.getProperty((String)DEFAULT_HANDLER_CLASS_PROP);
        if (string == null) {
            string = "com.sun.management.services.logging.ConsoleDebugHandler";
        }
        if ((dfltHandler = (Handler)ConsoleLogService.createInstance(string)) == null && !string.equals("com.sun.management.services.logging.ConsoleDebugHandler")) {
            dfltHandler = (Handler)ConsoleLogService.createInstance("com.sun.management.services.logging.ConsoleDebugHandler");
        }
        string = ConsoleConfiguration.getProperty((String)DEFAULT_LEVEL_PROP);
        dfltLevel = ConsoleLogService.createLevel(string, "info");
        dfltBundleName = ConsoleConfiguration.getProperty((String)DEFAULT_RESOURCE_BUNDLE_PROP);
        if (dfltBundleName == null) {
            dfltBundleName = DEFAULT_RESOURCE_BUNDLE;
        }
        if ((string = ConsoleConfiguration.getProperty((String)DEFAULT_FILTER_CLASS_PROP)) != null && !string.equalsIgnoreCase(FILTER_CLASS_NONE)) {
            dfltFilter = (Filter)ConsoleLogService.createInstance(string);
        }
        string = ConsoleConfiguration.getProperty((String)DEBUG_LEVEL_PROP);
        debugLevel = ConsoleLogService.createLevel(string, "severe");
        debugHandler = (Handler)ConsoleLogService.createInstance("com.sun.management.services.logging.ConsoleDebugHandler");
        init = true;
    }

    private static Object createInstance(String string) {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_1 = clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.trace1("Log: error creating instance of class: " + string + "  Error: " + exception.getMessage());
        }
        return var1_1;
    }

    private static Level createLevel(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            string = string2;
        }
        Level level = null;
        if (string.equalsIgnoreCase("severe")) {
            level = Level.SEVERE;
        } else if (string.equalsIgnoreCase(LEVEL_WARNING)) {
            level = Level.WARNING;
        } else if (string.equalsIgnoreCase("info")) {
            level = Level.INFO;
        } else if (string.equalsIgnoreCase(LEVEL_ALL)) {
            level = Level.ALL;
        } else if (string.equalsIgnoreCase(LEVEL_OFF)) {
            level = Level.OFF;
        } else if (string.equalsIgnoreCase(LEVEL_DEBUG)) {
            level = Level.FINE;
        } else if (string.equalsIgnoreCase(LEVEL_TRACE)) {
            level = Level.FINEST;
        }
        if (level == null) {
            level = Level.OFF;
        }
        return level;
    }
}

