/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deg.sunvts.ms;

import com.sun.deg.sunvts.data.CompositeTypeOption;
import com.sun.deg.sunvts.data.DeviceOption;
import com.sun.deg.sunvts.data.LTOption;
import java.util.List;

class DataEncoder {
    DataEncoder() {
    }

    String encodeTestOptions(List testOptions) {
        StringBuffer testOptionsBuf = new StringBuffer("[");
        if (testOptions == null) {
            return "[]";
        }
        int optionCount = 0;
        for (int i = 0; i < testOptions.size(); ++i) {
            Object nextObject = testOptions.get(i);
            if (!(nextObject instanceof LTOption)) continue;
            LTOption lTOption = (LTOption)nextObject;
            if (optionCount++ > 0) {
                testOptionsBuf.append(",");
            }
            testOptionsBuf.append(this.encodeTestOption(lTOption));
        }
        testOptionsBuf.append("]");
        return testOptionsBuf.toString();
    }

    private String encodeTestOption(LTOption lTOption) {
        StringBuffer value = new StringBuffer("");
        String[] valueField = lTOption.getValue();
        if (valueField != null) {
            if (valueField[0] != null) {
                value.append(valueField[0]);
            }
            for (int count = 1; count < valueField.length; ++count) {
                if (valueField[count] == null) continue;
                value.append("/" + valueField[count]);
            }
        }
        StringBuffer testOptionBuf = new StringBuffer(lTOption.getName() + ":" + value);
        if (lTOption instanceof CompositeTypeOption) {
            List nestedOptions = ((CompositeTypeOption)lTOption).getNestedOptionsList();
            String nestedString = "";
            int nestedSize = nestedOptions.size();
            for (int i = 0; i < nestedSize; ++i) {
                testOptionBuf.append("," + this.encodeTestOption((LTOption)nestedOptions.get(i)));
            }
        }
        return testOptionBuf.toString();
    }

    String encodeDeviceOptions(List deviceOptions) {
        StringBuffer deviceOptionsBuf = new StringBuffer("[");
        if (deviceOptions == null) {
            return "[]";
        }
        int optionCount = 0;
        for (int i = 0; i < deviceOptions.size(); ++i) {
            Object nextObject = deviceOptions.get(i);
            if (!(nextObject instanceof DeviceOption)) continue;
            DeviceOption deviceOption = (DeviceOption)nextObject;
            if (optionCount++ > 0) {
                deviceOptionsBuf.append(",");
            }
            deviceOptionsBuf.append(this.encodeDeviceOption(deviceOption));
        }
        deviceOptionsBuf.append("]");
        return deviceOptionsBuf.toString();
    }

    private String encodeDeviceOption(DeviceOption deviceOption) {
        StringBuffer value = new StringBuffer("");
        String[] valueField = deviceOption.getValue();
        if (valueField != null) {
            if (valueField[0] != null) {
                value.append(valueField[0]);
            }
            for (int count = 1; count < valueField.length; ++count) {
                if (valueField[count] == null) continue;
                value.append("/" + valueField[count]);
            }
        }
        StringBuffer testOptionBuf = new StringBuffer(deviceOption.getName() + ":" + value);
        return testOptionBuf.toString();
    }

    String encodeSaveSessionParams(boolean overwrite, String defaultMode, String sessionType, String sessionName) {
        StringBuffer paramString = new StringBuffer(50);
        paramString.append("[overwrite:");
        paramString.append(overwrite ? "yes" : "no");
        if (defaultMode != null) {
            paramString.append(",defaultMode:");
            paramString.append(defaultMode);
        }
        if (sessionType != null) {
            if (sessionType.equalsIgnoreCase("Generic")) {
                paramString.append(",generic:yes");
            } else if (sessionType.equalsIgnoreCase("Host Specific")) {
                paramString.append(",generic:no");
            }
        }
        paramString.append(",name:");
        paramString.append(sessionName);
        paramString.append("]");
        return paramString.toString();
    }

    String encodeLoadSessionParams(String defaultMode, String sessionName) {
        StringBuffer paramString = new StringBuffer(50);
        paramString.append("[name:");
        paramString.append(sessionName);
        if (defaultMode != null) {
            paramString.append(",defaultMode:");
            paramString.append(defaultMode);
        }
        paramString.append("]");
        return paramString.toString();
    }
}

