/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deg.sunvts.ms;

import com.sun.deg.sunvts.data.CompositeTypeOption;
import com.sun.deg.sunvts.data.DeviceOption;
import com.sun.deg.sunvts.data.HostConfig;
import com.sun.deg.sunvts.data.LTOption;
import com.sun.deg.sunvts.data.LTPageData;
import com.sun.deg.sunvts.data.LogicalTest;
import com.sun.deg.sunvts.data.SimpleTypeOption;
import java.util.ArrayList;
import java.util.List;

class DataParser {
    DataParser() {
    }

    List parseDelimitedNames(String delimitedNameString, String delimitor) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (delimitedNameString == null || delimitedNameString.length() == 0) {
            return nameList;
        }
        String[] names = delimitedNameString.split(delimitor);
        for (int i = 0; i < names.length; ++i) {
            nameList.add(names[i].trim());
        }
        return nameList;
    }

    HostConfig parseHostConfig(String hostConfigString) {
        HostConfig hostConfig = new HostConfig();
        if (hostConfigString == null || hostConfigString.length() == 0) {
            return hostConfig;
        }
        String[] configField = hostConfigString.split(";");
        for (int j = 0; j < configField.length; ++j) {
            if (configField[j].startsWith("\n")) {
                configField[j] = configField[j].substring(1);
            }
            String[] values = configField[j].split(":");
            String val = null;
            val = values.length < 2 ? "" : values[1];
            if (values[0].equalsIgnoreCase("Host Machine Name")) {
                hostConfig.setHostName(val);
                continue;
            }
            if (values[0].equalsIgnoreCase("Operating System")) {
                hostConfig.setOS(val);
                continue;
            }
            if (values[0].equalsIgnoreCase("Machine Type")) {
                hostConfig.setMachineType(val);
                continue;
            }
            if (values[0].equalsIgnoreCase("IP Address")) {
                hostConfig.setIPAddress(val);
                continue;
            }
            if (values[0].equalsIgnoreCase("Number of Processors")) {
                hostConfig.setNumProcessors(val);
                continue;
            }
            if (values[0].equalsIgnoreCase("Architecture")) {
                hostConfig.setArchitecture(val);
                continue;
            }
            if (values[0].equalsIgnoreCase("Hardware Platform")) {
                hostConfig.setHardwarePlatform(val);
                continue;
            }
            if (!values[0].equalsIgnoreCase("Support Info")) continue;
            hostConfig.setSupportInfo(val);
        }
        return hostConfig;
    }

    List parseTestOptions(String allOptionsString) {
        ArrayList<LTOption> optionsList = new ArrayList<LTOption>();
        if (allOptionsString == null || allOptionsString.length() == 0) {
            return optionsList;
        }
        String[] optionString = allOptionsString.split(";");
        for (int i = 0; i < optionString.length; ++i) {
            LTOption lTOption;
            if (optionString[i] == null || optionString[i].trim().equals("") || (lTOption = this.parseTestOption(optionString[i])) == null) continue;
            optionsList.add(lTOption);
        }
        return optionsList;
    }

    private LTOption parseTestOption(String optionString) {
        String[] optionField = optionString.split(",");
        if (optionField.length < 3) {
            return null;
        }
        LTOption lTOption = null;
        String name = optionField[0].trim();
        int type = 3;
        String valueString = null;
        String rangeString = null;
        String[] value = null;
        String[] range = null;
        String unit = null;
        String inLineHelp = null;
        if (optionField.length > 3 && optionField[3] != null && optionField[3].trim().startsWith("[")) {
            String unitAndHelpString;
            int unitStartIndex;
            String typeString = optionField[1].trim();
            type = typeString == null ? 0 : (typeString.equalsIgnoreCase("CHECKBOX") ? 1 : 0);
            valueString = optionField[2].trim();
            value = valueString == null || valueString.length() == 0 ? new String[]{""} : valueString.split("\\/");
            int firstCommaIndex = optionString.indexOf(44);
            int secondCommaIndex = optionString.indexOf(44, firstCommaIndex + 1);
            int thirdCommaIndex = optionString.indexOf(44, secondCommaIndex + 1);
            int nestedOptionStartIndex = optionString.indexOf(91, thirdCommaIndex + 1) + 1;
            int nestedOptionEndIndex = optionString.indexOf(93, nestedOptionStartIndex);
            if (nestedOptionEndIndex + 1 < optionString.length() && (unitStartIndex = (unitAndHelpString = optionString.substring(nestedOptionEndIndex + 1).trim()).indexOf(",")) != -1) {
                int unitEndIndex = (unitAndHelpString = unitAndHelpString.substring(unitStartIndex + 1).trim()).indexOf(",");
                if (unitEndIndex == -1) {
                    unit = unitAndHelpString;
                } else {
                    unit = unitAndHelpString.substring(0, unitEndIndex).trim();
                    inLineHelp = unitAndHelpString.substring(unitEndIndex + 1).trim();
                }
            }
            lTOption = new CompositeTypeOption(name, type, value, unit, inLineHelp);
            String allNestedOptionsString = optionString.substring(nestedOptionStartIndex, nestedOptionEndIndex);
            String[] nestedOptionString = allNestedOptionsString.split("\\|");
            for (int j = 0; j < nestedOptionString.length; ++j) {
                LTOption nestedOption = this.parseTestOption(nestedOptionString[j]);
                if (nestedOption == null) continue;
                ((CompositeTypeOption)lTOption).addNestedOption(nestedOption);
            }
        } else {
            String typeString = optionField[1].trim();
            type = typeString == null ? 3 : (typeString.equalsIgnoreCase("NUMERIC") ? 4 : (typeString.equalsIgnoreCase("CHECKBOX") ? 1 : (typeString.equalsIgnoreCase("RADIO") ? 0 : 3)));
            valueString = optionField[2].trim();
            value = valueString == null || valueString.length() == 0 ? new String[]{""} : valueString.split("\\/");
            if (optionField.length > 3) {
                rangeString = optionField[3].trim();
                range = rangeString == null || rangeString.length() == 0 ? new String[]{""} : rangeString.split("\\/");
            }
            if (optionField.length > 4) {
                unit = optionField[4].trim();
                if (optionField.length > 5) {
                    inLineHelp = optionField[5].trim();
                }
            }
            lTOption = new SimpleTypeOption(name, type, value, range, unit, inLineHelp);
        }
        return lTOption;
    }

    List parseDeviceOptions(String allOptionsString) {
        ArrayList<DeviceOption> optionsList = new ArrayList<DeviceOption>();
        if (allOptionsString == null || allOptionsString.length() == 0) {
            return optionsList;
        }
        String[] optionString = allOptionsString.split(";");
        for (int i = 0; i < optionString.length; ++i) {
            DeviceOption deviceOption;
            if (optionString[i] == null || optionString[i].trim().equals("") || (deviceOption = this.parseDeviceOption(optionString[i])) == null) continue;
            optionsList.add(deviceOption);
        }
        return optionsList;
    }

    private DeviceOption parseDeviceOption(String optionString) {
        String[] optionField = optionString.split(",");
        if (optionField.length < 3) {
            return null;
        }
        SimpleTypeOption deviceOption = null;
        String name = optionField[0].trim();
        int type = 3;
        String valueString = null;
        String rangeString = null;
        String[] value = null;
        String[] range = null;
        String typeString = optionField[1].trim();
        type = typeString == null ? 3 : (typeString.equalsIgnoreCase("NUMERIC") ? 4 : (typeString.equalsIgnoreCase("CHECKBOX") ? 1 : (typeString.equalsIgnoreCase("RADIO") ? 0 : 3)));
        valueString = optionField[2].trim();
        value = valueString == null || valueString.length() == 0 ? new String[]{""} : valueString.split("\\/");
        if (optionField.length > 3) {
            rangeString = optionField[3].trim();
            range = rangeString == null || rangeString.length() == 0 ? new String[]{""} : rangeString.split("\\/");
        }
        deviceOption = new SimpleTypeOption(name, type, value, range, " ", " ");
        return deviceOption;
    }

    List parseTestList(String testListString) {
        ArrayList<LogicalTest> testList = new ArrayList<LogicalTest>();
        if (testListString == null || testListString.length() == 0) {
            return testList;
        }
        String[] testString = testListString.split(",");
        for (int j = 0; j < testString.length; ++j) {
            LogicalTest logicalTest = new LogicalTest();
            if (testString[j].startsWith("\n")) {
                testString[j] = testString[j].substring(1);
            }
            String[] testOptions = testString[j].split(";");
            for (int i = 0; i < testOptions.length; ++i) {
                String[] ErrCount;
                String[] PassCount;
                String PassError;
                String[] PassErr;
                int seperatorIndexStartBracket;
                String[] values = testOptions[i].split(":");
                if (values.length <= 0) continue;
                if (values[0].equalsIgnoreCase("Logical Test")) {
                    if (values.length <= 1 || values[1] == null) continue;
                    logicalTest.setLogicalTestName(values[1]);
                    continue;
                }
                if (values[0].equalsIgnoreCase("Enabled")) {
                    if (values.length <= 1 || values[1] == null) continue;
                    logicalTest.setLogicalTestEnabled(values[1].equalsIgnoreCase("TRUE"));
                    continue;
                }
                if (values[0].equalsIgnoreCase("Scheduling Policy")) {
                    String[] policy;
                    if (values.length <= 1 || values[1] == null || (policy = values[1].split("=")).length <= 0 || policy[0] == null) continue;
                    logicalTest.setSchedulingPolicy(policy[0]);
                    continue;
                }
                if (values[0].equalsIgnoreCase("Stress")) {
                    if (values.length <= 1 || values[1] == null) continue;
                    logicalTest.setStress(values[1]);
                    continue;
                }
                if (values[0].equalsIgnoreCase("Progress")) {
                    if (values.length <= 1 || values[1] == null) continue;
                    logicalTest.setProgress(Integer.parseInt(values[1]));
                    continue;
                }
                if (!values[0].equalsIgnoreCase("Status") || values.length < 2 || values[1] == null || (seperatorIndexStartBracket = values[1].indexOf("(")) <= -1) continue;
                String status = values[1].substring(0, seperatorIndexStartBracket);
                logicalTest.setStatus(status);
                int seperatorIndexEndBracket = values[1].indexOf(")");
                if (seperatorIndexEndBracket <= -1 || (PassErr = (PassError = values[1].substring(seperatorIndexStartBracket + 1, seperatorIndexEndBracket)).split("/")).length <= 0 || (PassCount = PassErr[0].split("=")).length <= 0) continue;
                if (PassCount[0].equalsIgnoreCase("Pass") && PassCount.length > 1 && PassCount[1] != null) {
                    logicalTest.setPass(Integer.parseInt(PassCount[1]));
                }
                if (PassErr.length <= 1 || (ErrCount = PassErr[1].split("=")).length <= 0 || !ErrCount[0].equalsIgnoreCase("Error") || ErrCount.length <= 1 || ErrCount[1] == null) continue;
                try {
                    int error = Integer.parseInt(ErrCount[1]);
                    logicalTest.setError(error);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            testList.add(logicalTest);
        }
        return testList;
    }

    String getFieldValue(String fieldString, String delimitor) {
        if (fieldString == null) {
            return null;
        }
        String[] fieldParts = fieldString.split(delimitor);
        if (fieldParts != null && fieldParts.length > 1 && fieldParts[1] != null) {
            return fieldParts[1].trim();
        }
        return "";
    }

    LTPageData parseLTPageData(String ltPageDataString) {
        String systemStatus;
        if (ltPageDataString == null) {
            return null;
        }
        String testMode = "";
        String sessionName = "";
        String hostStatus = "";
        String elapsedTime = "";
        int errorCount = 0;
        String supportInfo = null;
        List testList = new ArrayList();
        String[] ltPageDataParts = ltPageDataString.split("\\|");
        if (ltPageDataParts.length > 0) {
            testList = this.parseTestList(ltPageDataParts[0]);
        }
        if (ltPageDataParts.length > 1) {
            testMode = this.getFieldValue(ltPageDataParts[1], ":");
        }
        if (ltPageDataParts.length > 2) {
            sessionName = this.getFieldValue(ltPageDataParts[2], ":");
        }
        if (ltPageDataParts.length > 3 && (systemStatus = this.getFieldValue(ltPageDataParts[3], ":")) != null && systemStatus.length() > 0) {
            String[] statusParts = systemStatus.split("/");
            int numParts = statusParts.length;
            hostStatus = statusParts[0];
            if (numParts > 2) {
                try {
                    errorCount = Integer.parseInt(this.getFieldValue(statusParts[2], "="));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                if (numParts > 3) {
                    elapsedTime = this.getFieldValue(statusParts[3], "=");
                }
            }
        }
        if (ltPageDataParts.length > 4) {
            supportInfo = this.getFieldValue(ltPageDataParts[4], ":");
        }
        if (ltPageDataParts.length > 0) {
            // empty if block
        }
        return new LTPageData(testList, testMode, sessionName, hostStatus, elapsedTime, errorCount, supportInfo);
    }
}

