/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset;

import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.sql.rowset.BaseRowSet;

public abstract class BaseRowSetX
extends BaseRowSet {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.Bundle", Locale.getDefault());
    private int maxRows = 0;
    private int fetchDir = 1000;
    private int fetchSize = 0;

    public void setCommand(String cmd) throws SQLException {
        super.setCommand(cmd == null || cmd.length() == 0 ? null : cmd);
    }

    public void setUrl(String url) throws SQLException {
        super.setUrl(url == null || url.length() == 0 ? null : url);
    }

    public void setDataSourceName(String name) throws SQLException {
        super.setDataSourceName(name == null || name.length() == 0 ? null : name);
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException(rb.getString("MAX_ROWS_INVALID") + " " + max);
        }
        this.maxRows = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException(rb.getString("INVALID_FETCH_DIRECTION"));
        }
        this.fetchDir = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException(rb.getString("INVALID_FETCH_SIZE") + " " + rows);
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }
}

