/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration.servlet;

import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.RegistrationUtil;
import com.sun.management.services.registration.UrlDesc;
import com.sun.management.services.registration.WebXmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;

public class WebConsoleRegistrarServlet
extends HttpServlet {
    private MgmtAppRegistrationService registrationSvc = null;
    private Logger logger;
    private static final String SERVLET_NAME = "WebConsoleRegistrarServlet";
    private static final String DTD_START = "<!DOCTYPE";
    private static final String DTD_END_DQ = "web-app_2_3.dtd\">";
    private static final String DTD_END_SQ = "web-app_2_3.dtd'>";
    private static final String RESOURCE_PKG = "com.sun.management.services.registration.servlet.resources.Resources";
    private static final String FILTER_TAG = "<filter>";
    private static final String FILTER_TAG_END = "</filter>";
    private static final String FILTER_CLASS_TAG = "<filter-class>";
    private static final String FILTER_CLASS_TAG_END = "</filter-class>";
    private static final String APP_FILTER_CLASS = "com.sun.management.services.session.AppSessionManagerFilter";
    private static final String CONSOLE_FILTER_CLASS = "com.sun.management.services.session.WebConsoleSMFilter";
    private static final String CONSOLE_PLUGIN_NAME = "com.sun.web.console";
    private static final String COMMON_PLUGIN_NAME = "com.sun.web.ui";
    private static final String PLUGIN_NAME = "com_sun_web_console_plugin_name";
    private static final String CONF_DIR_NAME = "conf";
    private static final String WEB_XML_FILE = "web.xml";

    public void init(ServletConfig servletConfig) throws ServletException {
        block14: {
            super.init(servletConfig);
            try {
                String string;
                Object object;
                int n;
                this.logger = ConsoleLogService.getConsoleLogger();
                ServletContext servletContext = this.getServletContext();
                if (servletContext == null) {
                    Debug.trace1((String)"Servlet context is null");
                    this.writeLogRecord(Level.SEVERE, "init", "log_context_null", null);
                    return;
                }
                String string2 = "/WEB-INF/lib/registrationservlet.jar";
                String string3 = null;
                URL uRL = servletContext.getResource(string2);
                if (uRL != null && (n = ((String)(object = uRL.getPath())).indexOf(string2)) > 0 && (n = ((String)(object = ((String)object).substring(0, n))).lastIndexOf(47)) >= 0) {
                    string3 = ((String)object).substring(n + 1);
                }
                object = MgmtAppRegistrationServiceFactory.getRegistrationService();
                InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/app.xml");
                if (inputStream == null && (inputStream = servletContext.getResourceAsStream("/app.xml")) == null) {
                    Debug.trace1((String)"no app.xml found for this app");
                    this.writeLogRecord(Level.SEVERE, "init", "log_no_app_xml", null);
                    return;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                RegistrationInfo registrationInfo = null;
                try {
                    registrationInfo = object.parseDescriptor((Reader)inputStreamReader);
                }
                catch (RegistrationException registrationException) {
                    string3 = string3 != null ? string3 : "unknown";
                    StringBuffer stringBuffer = new StringBuffer("Problem parsing application descriptor file for ").append(string3).append(".\n").append(registrationException.getLocalizedMessage());
                    throw new RegistrationException(stringBuffer.toString());
                }
                String string4 = registrationInfo.getManagementApp().getPluginName();
                String string5 = "**CPN-NA**";
                UrlDesc urlDesc = registrationInfo.getUrlDesc();
                if (urlDesc != null && (string = urlDesc.getUrl()) != null) {
                    int n2;
                    if ((string = string.trim()).charAt(0) == '/') {
                        string = string.substring(1);
                    }
                    if ((n2 = string.indexOf("/")) >= 0) {
                        string = string.substring(0, n2);
                    }
                    if (string.length() > 0) {
                        string5 = string;
                    }
                }
                if ((string = servletContext.getInitParameter("com.sun.web.console.defaultcontext")) != null && string.equalsIgnoreCase("true") && object.isAppRegistered(string4)) {
                    Debug.trace3((String)("Default context app already registered: " + string4));
                    return;
                }
                if (!this.checkFilterStatus(servletContext, string4)) break block14;
                object.registerApp(registrationInfo, string5);
                servletContext.setAttribute(PLUGIN_NAME, (Object)string4);
                try {
                    ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    RegistrationUtil.setAppLoader((String)string4, (ClassLoader)classLoader);
                }
                catch (Exception exception) {
                    Debug.trace1((String)("Exception getting classloader for " + string4), (Throwable)exception);
                }
                Debug.trace1((String)(string4 + " was registered successfully!"));
                this.writeLogRecord(Level.INFO, "init", "log_app_success", string4);
                inputStreamReader.close();
                inputStream.close();
            }
            catch (Exception exception) {
                this.writeLogRecord(Level.SEVERE, "init", "log_cannot_register", exception.getMessage());
            }
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(404);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(404);
    }

    public void destroy() {
        ServletConfig servletConfig;
        this.logger = ConsoleLogService.getConsoleLogger();
        String string = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            string = (String)servletContext.getAttribute(PLUGIN_NAME);
        }
        if (string == null) {
            Debug.trace1((String)"Servlet context is null in destroy...");
            servletConfig = this.getServletConfig();
            if (servletConfig != null) {
                string = servletConfig.getInitParameter("pluginName") + "_" + servletConfig.getInitParameter("version");
            } else {
                Debug.trace1((String)"Servlet config is null in destroy...");
            }
        }
        if (string != null) {
            Debug.trace3((String)("begin unregistering " + string));
            try {
                servletConfig = MgmtAppRegistrationServiceFactory.getRegistrationService();
                if (servletConfig.isAppRegistered(string)) {
                    servletConfig.unregisterApp(string);
                    Debug.trace1((String)(string + " unregistered successfully"));
                    this.writeLogRecord(Level.INFO, "destroy", "log_app_unreg", string);
                }
            }
            catch (Exception exception) {
                Debug.trace1((String)"exception during destroy ", (Throwable)exception);
            }
        }
    }

    private boolean checkFilterStatus(ServletContext servletContext, String string) throws Exception {
        if (string.indexOf("com.sun.web.ui_") != -1) {
            return true;
        }
        Debug.trace3((String)("checking web.xml for filter: " + string));
        InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        if (inputStream == null) {
            Debug.trace1((String)("unable to read web.xml for " + string));
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
            return false;
        }
        String string2 = WebXmlParser.neuterWebXml((String)WebXmlParser.trimWebXml((InputStream)inputStream));
        if (string2 == null) {
            Debug.trace1((String)("unable to trim web.xml for " + string));
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
            return false;
        }
        StringReader stringReader = new StringReader(string2);
        InputSource inputSource = new InputSource(stringReader);
        WebXmlParser webXmlParser = new WebXmlParser();
        try {
            webXmlParser.parse(inputSource);
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error parsing web.xml for " + string + ": " + exception.getMessage()));
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_cannot_check_filter", null);
            return false;
        }
        if (!webXmlParser.isFilterSet()) {
            Debug.trace1((String)"Filter has not been set properly");
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_no_filter", string);
            return false;
        }
        String string3 = webXmlParser.getFilterImplClassName();
        if (string.indexOf(CONSOLE_PLUGIN_NAME) != -1) {
            if (!string3.equals(CONSOLE_FILTER_CLASS)) {
                this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_improper_filter", string);
                return false;
            }
        } else if (!string3.equals(APP_FILTER_CLASS)) {
            this.writeLogRecord(Level.SEVERE, "checkFilterStatus", "log_improper_filter", string);
            return false;
        }
        try {
            stringReader.close();
        }
        catch (Exception exception) {
            Debug.trace1((String)("error closing web.xml of " + string), (Throwable)exception);
        }
        return true;
    }

    private void writeLogRecord(Level level, String string, String string2, String string3) {
        try {
            if (string3 == null) {
                this.logger.logrb(level, SERVLET_NAME, string, RESOURCE_PKG, string2);
            } else {
                this.logger.logrb(level, SERVLET_NAME, string, RESOURCE_PKG, string2, (Object)string3);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error while logging: " + exception.getLocalizedMessage()));
        }
    }
}

