/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.EventService;
import com.sun.wbem.cimom.IndicationPoller;
import com.sun.wbem.cimom.IndicationRequestCollator;
import com.sun.wbem.cimom.LogFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import javax.wbem.query.AndQueryExp;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.FromExp;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QualifiedAttributeExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;

public class FilterActivation {
    public static final String INSTANCEADDITION = "cim_instcreation";
    private static final int INSTANCEADDITIONTYPE = 0;
    public static final String INSTANCEDELETION = "cim_instdeletion";
    static final int INSTANCEDELETIONTYPE = 1;
    public static final String INSTANCEMODIFICATION = "cim_instmodification";
    static final int INSTANCEMODIFICATIONTYPE = 2;
    public static final String INSTANCEREAD = "cim_instread";
    static final int INSTANCEREADTYPE = 3;
    public static final String INSTANCEMETHODCALL = "cim_instmethodcall";
    public static final int INSTANCEMETHODCALLTYPE = 4;
    public static final String CLASSCREATION = "cim_classcreation";
    public static final String CLASSDELETION = "cim_classdeletion";
    public static final String CLASSMODIFICATION = "cim_classmodification";
    List result = null;
    CIMException exception = null;
    CIMInstance filterInstance = null;
    CIMObjectPath filterOp = null;
    CIMObjectPath targetNameSpace = null;
    SelectExp parsedExp = null;
    List canonizedExp = null;
    EventService eventService = null;

    FilterActivation(CIMObjectPath filterOp, CIMInstance filterInstance, EventService eventService) {
        this.filterInstance = filterInstance;
        this.filterOp = new CIMObjectPath();
        this.filterOp.setKeys(filterOp.getKeys());
        this.filterOp.setObjectName(filterOp.getObjectName());
        this.filterOp.setNameSpace(filterOp.getNameSpace().toLowerCase());
        this.eventService = eventService;
    }

    List getSubActivations() throws CIMException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    SelectExp getParsedExp() {
        return this.parsedExp;
    }

    CIMInstance getFilterInstance() {
        return this.filterInstance;
    }

    CIMObjectPath getFilterOp() {
        return this.filterOp;
    }

    CIMObjectPath getTargetNameSpace() {
        return this.targetNameSpace;
    }

    void run() {
        String query = null;
        try {
            query = (String)this.filterInstance.getProperty("query").getValue().getValue();
        }
        catch (NullPointerException e) {
            this.exception = new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int in = 0;
        try {
            String n = (String)this.filterInstance.getProperty("querylanguage").getValue().getValue();
        }
        catch (NullPointerException e) {
            in = 0;
        }
        if (in != 0) {
            this.exception = new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)new Integer(in));
            return;
        }
        try {
            this.determineClasses(query);
        }
        catch (CIMException e) {
            this.exception = e;
        }
        catch (Exception e) {
            this.exception = new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
    }

    private CIMIndicationProvider getProvider(CIMObjectPath classPath, String eventType) throws CIMException {
        CIMObjectPath cp = classPath;
        String className = cp.getObjectName();
        if (className == null || className.length() == 0) {
            cp = new CIMObjectPath();
            cp.setNameSpace(classPath.getNameSpace());
            cp.setObjectName(eventType);
        }
        CIMClass cc = this.eventService.ps.getClass(cp.getNameSpace(), cp.getObjectName());
        CIMIndicationProvider localep = CIMOMImpl.getProviderFactory().getCIMIndicationProvider(this.filterOp.getNameSpace(), cc);
        if (localep == null) {
            throw new CIMProviderException("NO_INDICATION_PROVIDER", (Object)cp.getObjectName(), (Object)cp.getNameSpace());
        }
        return localep;
    }

    void getPollInfo(final CIMInstance handler, final CIMInstance subscription) throws CIMException {
        IndicationRequestCollator irc = new IndicationRequestCollator(this.getSubActivations(), new IndicationRequestCollator.Callback(){
            int count = 0;

            public EventProviderRequest doSubActivationOperation(SubActivation sa) throws CIMException {
                return sa.getPollInfo();
            }

            public Object doProviderOperation(String[] filters, CIMObjectPath[] classPaths, String[] eventTypes) throws CIMException {
                this.count = 0;
                CIMIndicationProvider localep = FilterActivation.this.getProvider(classPaths[0], eventTypes[0]);
                return localep.mustPoll(FilterActivation.this.filterInstance, handler, subscription, filters, classPaths, eventTypes);
            }

            public void processSingleResult(SubActivation sa, Object result) throws CIMException {
                boolean[] pollResult = (boolean[])result;
                sa.processPollInfo(true, pollResult[this.count], null);
                ++this.count;
            }

            public void processSingleException(SubActivation sa, CIMException ce) throws CIMException {
                sa.processPollInfo(true, false, ce);
            }

            public void processSingleNoResult(SubActivation sa) throws CIMException {
                sa.processPollInfo(false, false, null);
            }
        });
        Object[] retVal = irc.processEventRequest();
        if (retVal[0] != null) {
            throw (CIMException)((Object)retVal[0]);
        }
    }

    void authorize(final String owner, final CIMInstance handler, final CIMInstance subscription) throws CIMException {
        IndicationRequestCollator irc = new IndicationRequestCollator(this.getSubActivations(), new IndicationRequestCollator.Callback(){

            public EventProviderRequest doSubActivationOperation(SubActivation sa) throws CIMException {
                return sa.authorize(owner);
            }

            public Object doProviderOperation(String[] filters, CIMObjectPath[] classPaths, String[] eventTypes) throws CIMException {
                CIMIndicationProvider localep = FilterActivation.this.getProvider(classPaths[0], eventTypes[0]);
                localep.authorizeFilter(FilterActivation.this.filterInstance, handler, subscription, filters, classPaths, eventTypes);
                return null;
            }

            public void processSingleResult(SubActivation sa, Object result) throws CIMException {
            }

            public void processSingleException(SubActivation sa, CIMException ce) throws CIMException {
                sa.processAuthorizeFailure(true, ce);
            }

            public void processSingleNoResult(SubActivation sa) throws CIMException {
                sa.processAuthorizeFailure(false, null);
            }
        });
        Object[] retVal = irc.processEventRequest();
        if (retVal[0] != null) {
            throw (CIMException)((Object)retVal[0]);
        }
    }

    void commonActivation(final CIMInstance handler, final CIMInstance subscription, final boolean isSubscription) throws CIMException {
        IndicationRequestCollator irc = new IndicationRequestCollator(this.getSubActivations(), new IndicationRequestCollator.Callback(){

            public EventProviderRequest doSubActivationOperation(SubActivation sa) throws CIMException {
                if (isSubscription) {
                    return sa.activateSubscription();
                }
                return sa.activate();
            }

            public Object doProviderOperation(String[] filters, CIMObjectPath[] classPaths, String[] eventTypes) throws CIMException {
                CIMIndicationProvider localep = FilterActivation.this.getProvider(classPaths[0], eventTypes[0]);
                localep.activateFilter(FilterActivation.this.filterInstance, handler, subscription, filters, classPaths, eventTypes);
                return null;
            }

            public void processSingleResult(SubActivation sa, Object result) throws CIMException {
            }

            public void processSingleException(SubActivation sa, CIMException ce) throws CIMException {
                if (!isSubscription) {
                    sa.processActivateFailure(true, ce);
                }
            }

            public void processSingleNoResult(SubActivation sa) throws CIMException {
                if (!isSubscription) {
                    sa.processActivateFailure(false, null);
                }
            }
        });
        Object[] retVal = irc.processEventRequest();
        if (retVal[0] != null) {
            this.commonDeactivation((List)retVal[1], handler, subscription, isSubscription);
            throw (CIMException)((Object)retVal[0]);
        }
    }

    void activate(CIMInstance handler, CIMInstance subscription) throws CIMException {
        this.commonActivation(handler, subscription, false);
    }

    void activateSubscription(CIMInstance handler, CIMInstance subscription) throws CIMException {
        this.commonActivation(handler, subscription, true);
    }

    private void commonDeactivation(List l, final CIMInstance handler, final CIMInstance subscription, final boolean isSubscription) throws CIMException {
        IndicationRequestCollator irc;
        Object[] retVal;
        if (l == null) {
            l = this.getSubActivations();
        }
        if ((retVal = (irc = new IndicationRequestCollator(l, new IndicationRequestCollator.Callback(){

            public EventProviderRequest doSubActivationOperation(SubActivation sa) throws CIMException {
                try {
                    if (isSubscription) {
                        return sa.deactivateSubscription();
                    }
                    return sa.deactivate();
                }
                catch (Throwable th) {
                    Debug.trace2((String)"Got deactivate exception", (Throwable)th);
                    return null;
                }
            }

            public Object doProviderOperation(String[] filters, CIMObjectPath[] classPaths, String[] eventTypes) throws CIMException {
                try {
                    CIMIndicationProvider localep = FilterActivation.this.getProvider(classPaths[0], eventTypes[0]);
                    localep.deActivateFilter(FilterActivation.this.filterInstance, handler, subscription, filters, classPaths, eventTypes);
                }
                catch (Throwable th) {
                    Debug.trace2((String)"Got deactivate exception", (Throwable)th);
                }
                return null;
            }

            public void processSingleResult(SubActivation sa, Object result) throws CIMException {
            }

            public void processSingleException(SubActivation sa, CIMException ce) throws CIMException {
            }

            public void processSingleNoResult(SubActivation sa) throws CIMException {
            }
        })).processEventRequest())[0] != null) {
            Debug.trace2((String)"Got exception during deactivation", (Throwable)((CIMException)((Object)retVal[0])));
        }
    }

    void deactivateSubscription(CIMInstance handler, CIMInstance subscription) throws CIMException {
        this.commonDeactivation(null, handler, subscription, true);
    }

    void deactivate(CIMInstance handler, CIMInstance subscription) throws CIMException {
        this.commonDeactivation(null, handler, subscription, false);
    }

    private List removeIsas(List l) {
        Iterator i = l.iterator();
        ArrayList<BinaryRelQueryExp> output = new ArrayList<BinaryRelQueryExp>();
        while (i.hasNext()) {
            BinaryRelQueryExp br = (BinaryRelQueryExp)i.next();
            int operator = br.getOperator();
            if (operator == 8 || operator == 9) continue;
            output.add(br);
        }
        return output;
    }

    private QueryExp toQueryExp(List l) {
        if (l.size() == 0) {
            return null;
        }
        Iterator i = l.iterator();
        if (l.size() == 1) {
            return (BinaryRelQueryExp)i.next();
        }
        BinaryRelQueryExp lexp = (BinaryRelQueryExp)i.next();
        BinaryRelQueryExp rexp = (BinaryRelQueryExp)i.next();
        AndQueryExp finalExp = new AndQueryExp((QueryExp)lexp, (QueryExp)rexp);
        while (i.hasNext()) {
            finalExp = new AndQueryExp((QueryExp)finalExp, (QueryExp)((BinaryRelQueryExp)i.next()));
        }
        return finalExp;
    }

    static int determineEventType(String eventTypeString) {
        if (eventTypeString.equalsIgnoreCase(INSTANCEMODIFICATION)) {
            return 2;
        }
        if (eventTypeString.equalsIgnoreCase(INSTANCEDELETION)) {
            return 1;
        }
        if (eventTypeString.equalsIgnoreCase(INSTANCEADDITION)) {
            return 0;
        }
        if (eventTypeString.equalsIgnoreCase(INSTANCEMETHODCALL)) {
            return 4;
        }
        if (eventTypeString.equalsIgnoreCase(INSTANCEREAD)) {
            return 3;
        }
        return -1;
    }

    private boolean isAbstract(CIMClass cc) {
        CIMQualifier qe = cc.getQualifier("abstract");
        if (qe == null) {
            return false;
        }
        CIMValue Tmp = qe.getValue();
        return Tmp != null && Tmp.equals((Object)CIMValue.TRUE);
    }

    private boolean isClassIndication(String eventType) {
        String testType = eventType.toLowerCase();
        if (testType.equals(CLASSDELETION)) {
            return true;
        }
        if (testType.equals(CLASSCREATION)) {
            return true;
        }
        return testType.equals(CLASSMODIFICATION);
    }

    private void determineClasses(String query) throws Exception {
        this.parsedExp = new SelectExp(query);
        String eventTypeString = ((NonJoinExp)this.parsedExp.getFromClause()).getAttribute().getAttrClassName().toLowerCase();
        this.targetNameSpace = new CIMObjectPath();
        String targetNS = null;
        try {
            targetNS = (String)this.filterInstance.getProperty("sourceNameSpace").getValue().getValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (targetNS == null) {
            this.targetNameSpace.setNameSpace(this.filterOp.getNameSpace());
        } else {
            this.targetNameSpace.setNameSpace(targetNS.toLowerCase());
        }
        CIMClass indicationClass = this.eventService.ps.getClass(this.filterOp.getNameSpace(), eventTypeString);
        if (indicationClass == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)eventTypeString);
        }
        CIMQualifier qe = indicationClass.getQualifier("indication");
        if (qe == null) {
            throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)eventTypeString);
        }
        CIMValue Tmp = qe.getValue();
        if (Tmp == null || !Tmp.equals((Object)CIMValue.TRUE)) {
            throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)eventTypeString);
        }
        CIMObjectPath eventTypePath = new CIMObjectPath();
        eventTypePath.setNameSpace(this.filterOp.getNameSpace());
        eventTypePath.setObjectName(eventTypeString);
        Vector tempList = this.eventService.ps.enumerateClasses(eventTypePath, true, false);
        ArrayList<CIMClass> indicationList = new ArrayList<CIMClass>();
        ArrayList<CIMClass> intrinsicEventList = new ArrayList<CIMClass>();
        if (!this.isAbstract(indicationClass)) {
            if (FilterActivation.determineEventType(indicationClass.getName().toLowerCase()) != -1) {
                intrinsicEventList.add(indicationClass);
            } else {
                indicationList.add(indicationClass);
            }
        }
        Enumeration e = tempList.elements();
        while (e.hasMoreElements()) {
            CIMClass tic = (CIMClass)e.nextElement();
            if (this.isAbstract(tic)) continue;
            if (FilterActivation.determineEventType(tic.getName().toLowerCase()) != -1) {
                intrinsicEventList.add(tic);
                continue;
            }
            indicationList.add(tic);
        }
        QueryExp whereClause = this.parsedExp.getWhereClause();
        ArrayList cwc = null;
        if (whereClause != null) {
            cwc = whereClause.canonizeDOC();
        } else {
            cwc = new ArrayList();
            cwc.add(new ArrayList());
        }
        this.result = new ArrayList();
        for (CIMClass tic : indicationList) {
            SubActivation subAct = this.isClassIndication(tic.getName()) ? new CISubActivation(tic.getName().toLowerCase(), whereClause, "") : new PISubActivation(tic.getName().toLowerCase(), whereClause, "");
            this.result.add(subAct);
        }
        Iterator i = cwc.iterator();
        this.canonizedExp = new ArrayList();
        if (intrinsicEventList.size() == 0) {
            return;
        }
        while (i.hasNext()) {
            List subExpression = (List)i.next();
            Set s = this.determineSublistClasses(subExpression);
            Iterator is = s.iterator();
            subExpression = this.removeIsas(subExpression);
            this.canonizedExp.add(subExpression);
            QueryExp subQueryExp = this.toQueryExp(subExpression);
            while (is.hasNext()) {
                String className = (String)is.next();
                for (CIMClass tic : intrinsicEventList) {
                    ILCSubActivation subAct = new ILCSubActivation(tic.getName().toLowerCase(), subQueryExp, className.toLowerCase());
                    this.result.add(subAct);
                }
            }
        }
    }

    private Set determineSublistClasses(List l) throws Exception {
        String className;
        Iterator i = l.iterator();
        TreeSet<String> s = new TreeSet<String>();
        ArrayList<String> intersection = new ArrayList<String>();
        ArrayList<String> difference = new ArrayList<String>();
        while (i.hasNext()) {
            BinaryRelQueryExp br = (BinaryRelQueryExp)i.next();
            switch (br.getOperator()) {
                case 8: {
                    AttributeExp aexp = (AttributeExp)br.getRightValue();
                    className = aexp.getAttributeName();
                    intersection.add(className);
                    break;
                }
                case 9: {
                    AttributeExp aexp = (AttributeExp)br.getRightValue();
                    className = aexp.getAttributeName();
                    difference.add(className);
                }
            }
        }
        CIMObjectPath path = new CIMObjectPath();
        path.setNameSpace(this.targetNameSpace.getNameSpace());
        if (intersection.size() == 0) {
            path.setObjectName("");
            Enumeration e = this.eventService.ps.enumerateClasses(path, true).elements();
            while (e.hasMoreElements()) {
                s.add(((CIMObjectPath)e.nextElement()).getObjectName());
            }
            if (s.size() == 0) {
                return s;
            }
        } else {
            Iterator isaList = intersection.iterator();
            className = (String)isaList.next();
            path.setObjectName(className);
            Enumeration e = this.eventService.ps.enumerateClasses(path, true).elements();
            s.add(className);
            while (e.hasMoreElements()) {
                s.add(((CIMObjectPath)e.nextElement()).getObjectName());
            }
            while (s.size() > 0 && isaList.hasNext()) {
                String intersectCN = (String)isaList.next();
                path.setObjectName(intersectCN);
                Vector v = this.eventService.ps.enumerateClasses(path, true);
                v.insertElementAt(new CIMObjectPath(intersectCN), 0);
                e = v.elements();
                while (e.hasMoreElements()) {
                    String intersectClass = ((CIMObjectPath)e.nextElement()).getObjectName();
                    if (s.contains(intersectClass)) continue;
                    s.remove(intersectClass);
                }
            }
            if (s.size() == 0) {
                return s;
            }
        }
        Iterator nisaList = difference.iterator();
        while (nisaList.hasNext() && s.size() != 0) {
            String diffClassName = (String)nisaList.next();
            path.setObjectName(diffClassName);
            Vector v = this.eventService.ps.enumerateClasses(path, true);
            v.insertElementAt(new CIMObjectPath(diffClassName), 0);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                s.remove(((CIMObjectPath)e.nextElement()).getObjectName());
            }
        }
        return s;
    }

    class ILCSubActivation
    extends SubActivation {
        boolean hasIndicationProvider;
        boolean hasInstanceProvider;
        CIMInstanceProvider instanceProvider;
        boolean isSmartIndicationProvider;

        ILCSubActivation(String indicationTypeString, QueryExp expression, String className) {
            super(indicationTypeString, expression, className);
            this.hasIndicationProvider = false;
            this.hasInstanceProvider = false;
            this.instanceProvider = null;
            this.isSmartIndicationProvider = false;
        }

        PollInfoRequest getPollInfo() throws CIMException {
            Authorizable tempAuth;
            block17: {
                CIMClass cc;
                boolean checkForSmartIP;
                block16: {
                    checkForSmartIP = false;
                    cc = FilterActivation.this.eventService.ps.getClass(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                    this.instanceProvider = CIMOMImpl.getProviderFactory().getInstanceProvider(FilterActivation.this.targetNameSpace.getNameSpace(), cc);
                    if (this.instanceProvider != null) {
                        this.hasInstanceProvider = true;
                    }
                    try {
                        this.localep = CIMOMImpl.getProviderFactory().getEventProvider(FilterActivation.this.targetNameSpace.getNameSpace(), cc);
                    }
                    catch (CIMException ce) {
                        if (!ce.getID().equals("NOT_EVENT_PROVIDER")) {
                            throw ce;
                        }
                        try {
                            checkForSmartIP = true;
                            this.localep = CIMOMImpl.getProviderFactory().getCIMIndicationProvider(FilterActivation.this.targetNameSpace.getNameSpace(), cc);
                        }
                        catch (CIMException ce2) {
                            if (ce2.getID().equals("NOT_INDICATION_PROVIDER")) break block16;
                            throw ce2;
                        }
                    }
                }
                if (this.localep != null) {
                    this.hasIndicationProvider = true;
                    if (checkForSmartIP) {
                        this.isSmartIndicationProvider = true;
                    }
                }
                if (!this.hasInstanceProvider && !this.hasIndicationProvider) {
                    LogFile.add(4, "DEBUG_VALUE", "Handled by", "repository");
                    if (this.eventType == 4) {
                        throw new CIMProviderException("NO_EVENT_PROVIDER", (Object)this.subIndicationType, (Object)"");
                    }
                    return null;
                }
                if (!(this.hasIndicationProvider || this.eventType != 3 && this.eventType != 4)) {
                    throw new CIMProviderException("NOT_EVENT_PROVIDER", (Object)this.subIndicationType, (Object)this.instanceProvider.getClass().getName());
                }
                if (!this.hasIndicationProvider) {
                    LogFile.add(4, "DEBUG_VALUE", "Handled by", "poller, not an event provider");
                    this.polled = true;
                    return null;
                }
                tempAuth = null;
                try {
                    tempAuth = CIMOMImpl.getProviderFactory().getAuthorizableProvider(FilterActivation.this.filterOp.getNameSpace(), cc);
                }
                catch (CIMException ce) {
                    if (ce.getID().equals("NOT_AUTHORIZABLE_PROVIDER")) break block17;
                    throw ce;
                }
            }
            this.authorizable = tempAuth == null;
            CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
            if (this.eventType != 3 && this.eventType != 4) {
                if (this.isSmartIndicationProvider) {
                    return new PollInfoRequest(this.getSubSelectExp(), this.getIndicationType(), classPath);
                }
                boolean pollResult = ((EventProvider)this.localep).mustPoll(this.getSubSelectExp(), this.getIndicationType(), classPath);
                this.processPollInfo(true, pollResult, null);
                return null;
            }
            return null;
        }

        void processPollInfo(boolean hasResult, boolean pollFlag, CIMException ce) throws CIMException {
            if (!hasResult) {
                return;
            }
            if (ce != null) {
                return;
            }
            if (pollFlag) {
                this.polled = true;
                LogFile.add(4, "DEBUG_VALUE", "Handled by", "poller, event provider wants a poll");
                if (EventService.pollInterval < 0) {
                    throw new CIMException("CIM_ERR_FAILED");
                }
                if (!this.hasInstanceProvider) {
                    throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.className));
                }
            }
        }

        AuthorizeRequest authorize(String owner) throws CIMException {
            CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
            if (this.authorizable) {
                if (this.isSmartIndicationProvider) {
                    return new AuthorizeRequest(this.getSubSelectExp(), this.getIndicationType(), classPath, owner);
                }
                ((EventProvider)this.localep).authorizeFilter(this.getSubSelectExp(), this.getIndicationType(), classPath, owner);
                return null;
            }
            if (this.polled) {
                IndicationPoller ip = FilterActivation.this.eventService.getIndicationPoller();
                ip.authorizeFilter(this.getSubSelectExp(), this.getIndicationType(), classPath, owner);
                return null;
            }
            CIMOMImpl cfr_ignored_0 = FilterActivation.this.eventService.cimom;
            FilterActivation.this.eventService.cimom.delayedCapabilityCheck((CIMClass)null, false, "read", classPath.getNameSpace());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ActivateRequest activate() throws CIMException {
            boolean repository;
            boolean shouldActivate = FilterActivation.this.eventService.addClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.className, this, this.polled);
            boolean bl = repository = !this.hasIndicationProvider && !this.hasInstanceProvider;
            if (!shouldActivate) {
                if (repository) {
                    return null;
                }
                if (this.polled) {
                    return null;
                }
            }
            boolean failed = true;
            try {
                if (repository) {
                    CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
                    switch (this.eventType) {
                        case 0: {
                            FilterActivation.this.eventService.ps.additionTriggerActivate(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                            break;
                        }
                        case 2: {
                            FilterActivation.this.eventService.ps.modificationTriggerActivate(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                            break;
                        }
                        case 1: {
                            FilterActivation.this.eventService.ps.deletionTriggerActivate(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                            break;
                        }
                        case 3: {
                            FilterActivation.this.eventService.ps.activateFilter(this.getSubSelectExp(), this.getIndicationType(), classPath, shouldActivate);
                        }
                    }
                    failed = false;
                    ActivateRequest activateRequest = null;
                    return activateRequest;
                }
                if (!this.polled) {
                    CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
                    if (this.isSmartIndicationProvider) {
                        failed = false;
                        ActivateRequest activateRequest = new ActivateRequest(this.getSubSelectExp(), this.getIndicationType(), classPath, shouldActivate);
                        return activateRequest;
                    }
                    ((EventProvider)this.localep).activateFilter(this.getSubSelectExp(), this.getIndicationType(), classPath, shouldActivate);
                    failed = false;
                    ActivateRequest activateRequest = null;
                    return activateRequest;
                }
                IndicationPoller ip = FilterActivation.this.eventService.getIndicationPoller();
                switch (this.eventType) {
                    case 0: {
                        ip.additionTriggerActivate(this);
                        break;
                    }
                    case 2: {
                        ip.modificationTriggerActivate(this);
                        break;
                    }
                    case 1: {
                        ip.deletionTriggerActivate(this);
                    }
                }
                failed = false;
                ActivateRequest activateRequest = null;
                return activateRequest;
            }
            finally {
                if (failed) {
                    FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.className, this, this.polled);
                }
            }
        }

        ActivateRequest activateSubscription() throws CIMException {
            boolean repository;
            boolean bl = repository = !this.hasIndicationProvider && !this.hasInstanceProvider;
            if (repository || this.polled) {
                return null;
            }
            if (this.isSmartIndicationProvider) {
                CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
                return new ActivateRequest(this.getSubSelectExp(), this.getIndicationType(), classPath, false);
            }
            return null;
        }

        void processActivateFailure(boolean hasResult, CIMException ce) throws CIMException {
            FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.className, this, this.polled);
        }

        DeactivateRequest deactivateSubscription() throws CIMException {
            boolean repository;
            boolean bl = repository = !this.hasIndicationProvider && !this.hasInstanceProvider;
            if (repository || this.polled) {
                return null;
            }
            if (this.isSmartIndicationProvider) {
                CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
                return new DeactivateRequest(this.getSubSelectExp(), this.getIndicationType(), classPath, false);
            }
            return null;
        }

        DeactivateRequest deactivate() throws CIMException {
            boolean repository;
            boolean shouldDeActivate = FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.className, this, this.polled);
            boolean bl = repository = !this.hasIndicationProvider && !this.hasInstanceProvider;
            if (!shouldDeActivate) {
                if (repository) {
                    return null;
                }
                if (this.polled) {
                    return null;
                }
            }
            if (repository) {
                switch (this.eventType) {
                    case 0: {
                        FilterActivation.this.eventService.ps.additionTriggerDeActivate(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                        break;
                    }
                    case 2: {
                        FilterActivation.this.eventService.ps.modificationTriggerDeActivate(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                        break;
                    }
                    case 1: {
                        FilterActivation.this.eventService.ps.deletionTriggerDeActivate(FilterActivation.this.targetNameSpace.getNameSpace(), this.className);
                    }
                }
                return null;
            }
            if (!this.polled) {
                CIMObjectPath classPath = new CIMObjectPath(this.className, FilterActivation.this.targetNameSpace.getNameSpace());
                if (this.isSmartIndicationProvider) {
                    return new DeactivateRequest(this.getSubSelectExp(), this.getIndicationType(), classPath, shouldDeActivate);
                }
                ((EventProvider)this.localep).deActivateFilter(this.getSubSelectExp(), this.getIndicationType(), classPath, shouldDeActivate);
                return null;
            }
            IndicationPoller ip = FilterActivation.this.eventService.getIndicationPoller();
            switch (this.eventType) {
                case 0: {
                    ip.additionTriggerDeActivate(this);
                    break;
                }
                case 2: {
                    ip.modificationTriggerDeActivate(this);
                    break;
                }
                case 1: {
                    ip.deletionTriggerDeActivate(this);
                }
            }
            return null;
        }
    }

    class CISubActivation
    extends SubActivation {
        EventProvider ep;

        CISubActivation(String indicationTypeString, QueryExp expression, String className) {
            super(indicationTypeString, expression, className);
        }

        PollInfoRequest getPollInfo() throws CIMException {
            this.ep = FilterActivation.this.eventService.ps;
            return null;
        }

        AuthorizeRequest authorize(String owner) throws CIMException {
            CIMOMImpl cfr_ignored_0 = FilterActivation.this.eventService.cimom;
            FilterActivation.this.eventService.cimom.delayedCapabilityCheck((CIMClass)null, false, "read", FilterActivation.this.targetNameSpace.getNameSpace());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ActivateRequest activate() throws CIMException {
            boolean firstFilter = FilterActivation.this.eventService.addClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.subIndicationType, this, this.polled);
            CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.targetNameSpace.getNameSpace());
            boolean failed = true;
            try {
                this.ep.activateFilter(this.getSubSelectExp(), this.subIndicationType, classPath, firstFilter);
                failed = false;
            }
            finally {
                if (failed) {
                    FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.subIndicationType, this, this.polled);
                }
            }
            return null;
        }

        ActivateRequest activateSubscription() {
            return null;
        }

        DeactivateRequest deactivateSubscription() throws CIMException {
            return null;
        }

        DeactivateRequest deactivate() throws CIMException {
            boolean lastFilter = FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.targetNameSpace.getNameSpace() + ":" + this.subIndicationType, this, this.polled);
            CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.targetNameSpace.getNameSpace());
            this.ep.deActivateFilter(this.getSubSelectExp(), this.subIndicationType, classPath, lastFilter);
            return null;
        }
    }

    class PISubActivation
    extends SubActivation {
        boolean isSmartIndicationProvider;

        PISubActivation(String indicationTypeString, QueryExp expression, String className) {
            super(indicationTypeString, expression, className);
            this.isSmartIndicationProvider = false;
        }

        PollInfoRequest getPollInfo() throws CIMException {
            Authorizable tempAuth;
            block8: {
                boolean checkedForSmartIP = false;
                CIMClass cc = FilterActivation.this.eventService.ps.getClass(FilterActivation.this.filterOp.getNameSpace(), this.subIndicationType);
                try {
                    this.localep = CIMOMImpl.getProviderFactory().getEventProvider(FilterActivation.this.filterOp.getNameSpace(), cc);
                }
                catch (CIMException e) {
                    try {
                        checkedForSmartIP = true;
                        this.localep = CIMOMImpl.getProviderFactory().getCIMIndicationProvider(FilterActivation.this.filterOp.getNameSpace(), cc);
                    }
                    catch (CIMException ce) {
                        // empty catch block
                    }
                }
                if (this.localep == null) {
                    throw new CIMProviderException("NO_EVENT_PROVIDER", (Object)this.subIndicationType, (Object)"");
                }
                if (checkedForSmartIP) {
                    this.isSmartIndicationProvider = true;
                }
                tempAuth = null;
                try {
                    tempAuth = CIMOMImpl.getProviderFactory().getAuthorizableProvider(FilterActivation.this.filterOp.getNameSpace(), cc);
                }
                catch (CIMException ce) {
                    if (ce.getID().equals("NOT_AUTHORIZABLE_PROVIDER")) break block8;
                    throw ce;
                }
            }
            this.authorizable = tempAuth != null;
            return null;
        }

        AuthorizeRequest authorize(String owner) throws CIMException {
            CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.filterOp.getNameSpace());
            if (this.authorizable) {
                if (this.isSmartIndicationProvider) {
                    return new AuthorizeRequest(this.getSubSelectExp(), this.subIndicationType, classPath, owner);
                }
                ((EventProvider)this.localep).authorizeFilter(this.getSubSelectExp(), this.subIndicationType, classPath, owner);
                return null;
            }
            CIMOMImpl cfr_ignored_0 = FilterActivation.this.eventService.cimom;
            FilterActivation.this.eventService.cimom.delayedCapabilityCheck((CIMClass)null, false, "read", classPath.getNameSpace());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ActivateRequest activate() throws CIMException {
            boolean firstFilter = FilterActivation.this.eventService.addClassFilter(FilterActivation.this.filterOp.getNameSpace() + ":" + this.subIndicationType, this, this.polled);
            CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.filterOp.getNameSpace());
            if (this.isSmartIndicationProvider) {
                return new ActivateRequest(this.getSubSelectExp(), this.subIndicationType, classPath, firstFilter);
            }
            boolean failed = true;
            EventProvider ep = (EventProvider)this.localep;
            try {
                ep.activateFilter(this.getSubSelectExp(), this.subIndicationType, classPath, firstFilter);
                failed = false;
                ActivateRequest activateRequest = null;
                return activateRequest;
            }
            finally {
                if (failed) {
                    this.processActivateFailure(false, null);
                }
            }
        }

        void processActivateFailure(boolean hasResult, CIMException ce) throws CIMException {
            FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.filterOp.getNameSpace() + ":" + this.subIndicationType, this, this.polled);
        }

        ActivateRequest activateSubscription() throws CIMException {
            CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.filterOp.getNameSpace());
            if (this.isSmartIndicationProvider) {
                return new ActivateRequest(this.getSubSelectExp(), this.subIndicationType, classPath, false);
            }
            return null;
        }

        DeactivateRequest deactivateSubscription() throws CIMException {
            if (this.isSmartIndicationProvider) {
                CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.filterOp.getNameSpace());
                return new DeactivateRequest(this.getSubSelectExp(), this.subIndicationType, classPath, false);
            }
            return null;
        }

        DeactivateRequest deactivate() throws CIMException {
            boolean lastFilter = FilterActivation.this.eventService.removeClassFilter(FilterActivation.this.filterOp.getNameSpace() + ":" + this.subIndicationType, this, this.polled);
            CIMObjectPath classPath = new CIMObjectPath("", FilterActivation.this.filterOp.getNameSpace());
            if (this.isSmartIndicationProvider) {
                return new DeactivateRequest(this.getSubSelectExp(), this.subIndicationType, classPath, lastFilter);
            }
            ((EventProvider)this.localep).deActivateFilter(this.getSubSelectExp(), this.subIndicationType, classPath, lastFilter);
            return null;
        }
    }

    abstract class SubActivation {
        QueryExp expression;
        String className;
        boolean authorizable = false;
        boolean polled = false;
        SelectExp subSelectExp;
        String subIndicationType;
        int eventType = -1;
        CIMProvider localep;

        SelectExp getSubSelectExp() {
            return this.subSelectExp;
        }

        QueryExp getExpression() {
            return this.expression;
        }

        String getClassName() {
            return this.className;
        }

        FilterActivation getParentActivation() {
            return FilterActivation.this;
        }

        String getIndicationType() {
            return this.subIndicationType;
        }

        int getEventType() {
            return this.eventType;
        }

        SubActivation(String indicationTypeString, QueryExp expression, String className) {
            this.expression = expression;
            this.className = className;
            this.subSelectExp = new SelectExp(FilterActivation.this.parsedExp.getSelectList(), (FromExp)new NonJoinExp(new QualifiedAttributeExp(indicationTypeString, null, null)), expression);
            this.subIndicationType = indicationTypeString;
            this.eventType = FilterActivation.determineEventType(this.subIndicationType);
        }

        abstract PollInfoRequest getPollInfo() throws CIMException;

        void processPollInfo(boolean hasResult, boolean pollFlag, CIMException ce) throws CIMException {
        }

        abstract AuthorizeRequest authorize(String var1) throws CIMException;

        void processAuthorizeFailure(boolean hasResult, CIMException ce) throws CIMException {
        }

        abstract ActivateRequest activate() throws CIMException;

        void processActivateFailure(boolean hasResult, CIMException ce) throws CIMException {
        }

        abstract ActivateRequest activateSubscription() throws CIMException;

        abstract DeactivateRequest deactivateSubscription() throws CIMException;

        abstract DeactivateRequest deactivate() throws CIMException;
    }

    static final class DeactivateRequest
    extends EventProviderRequest {
        private boolean lastActivation;

        DeactivateRequest(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) {
            super(filter, eventType, classPath);
            this.lastActivation = lastActivation;
        }

        boolean getLastActivation() {
            return this.lastActivation;
        }
    }

    static final class ActivateRequest
    extends EventProviderRequest {
        private boolean firstActivation;

        ActivateRequest(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) {
            super(filter, eventType, classPath);
            this.firstActivation = firstActivation;
        }

        boolean getFirstActivation() {
            return this.firstActivation;
        }
    }

    static final class AuthorizeRequest
    extends EventProviderRequest {
        private String owner;

        AuthorizeRequest(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) {
            super(filter, eventType, classPath);
            this.owner = owner;
        }

        String getOwner() {
            return this.owner;
        }
    }

    static final class PollInfoRequest
    extends EventProviderRequest {
        private SelectExp filter;
        private String eventType;
        private CIMObjectPath classPath;

        PollInfoRequest(SelectExp filter, String eventType, CIMObjectPath classPath) {
            super(filter, eventType, classPath);
        }
    }

    static class EventProviderRequest {
        private SelectExp filter;
        private String eventType;
        private CIMObjectPath classPath;

        EventProviderRequest(SelectExp filter, String eventType, CIMObjectPath classPath) {
            this.filter = filter;
            this.eventType = eventType;
            this.classPath = classPath;
        }

        SelectExp getFilter() {
            return this.filter;
        }

        String getEventType() {
            return this.eventType;
        }

        CIMObjectPath getClassPath() {
            return this.classPath;
        }
    }
}

