/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMSemanticException;
import javax.wbem.cim.CIMValue;

class MethodChecker {
    CIMOMUtils cu;

    public MethodChecker(CIMOMUtils cu) {
        this.cu = cu;
    }

    private void assignInheritedMethods(String namespace, CIMClass cc, Hashtable overrideMap, CIMClass superclass) {
        String lcns = namespace.toLowerCase();
        if (superclass != null) {
            Vector MethodTable = superclass.getAllMethods();
            Enumeration methods = MethodTable.elements();
            while (methods.hasMoreElements()) {
                CIMMethod me = (CIMMethod)methods.nextElement();
                CIMMethod mec = (CIMMethod)me.clone();
                String om = (String)overrideMap.get(me.getOriginClass() + "." + me.getName());
                if (om != null) {
                    mec.setOverridingMethod(om);
                }
                cc.addMethod(mec);
            }
        }
    }

    private void handleMethodOverride(String namespace, CIMClass cc, CIMMethod me, Hashtable overrideMap, CIMClass superclass) throws CIMException {
        String MethodName;
        Vector qualifiers = me.getQualifiers();
        CIMQualifier qe = me.getQualifier("override");
        if (qe == null) {
            return;
        }
        CIMValue ValueTable = qe.getValue();
        String Value = null;
        if (ValueTable != null) {
            Value = (String)ValueTable.getValue();
        }
        if (ValueTable == null || Value == null || Value.equals("")) {
            throw new CIMSemanticException("NO_QUALIFIER_VALUE", (Object)(me.getOriginClass() + "." + me.getName()), (Object)qe.getName());
        }
        String ClassName = null;
        int trenner = Value.indexOf(".");
        String fullName = MethodName = Value.substring(trenner + 1, Value.length());
        if (trenner > 0) {
            ClassName = Value.substring(0, trenner);
            fullName = ClassName + "." + MethodName;
        }
        CIMMethod ome = null;
        boolean found = false;
        if (superclass == null) {
            throw new CIMMethodException("NO_OVERRIDDEN_METHOD", (Object)(me.getOriginClass() + "." + me.getName()), (Object)fullName);
        }
        ome = superclass.getMethod(MethodName, ClassName);
        if (ome == null) {
            throw new CIMMethodException("NO_OVERRIDDEN_METHOD", (Object)(me.getOriginClass() + "." + me.getName()), (Object)fullName);
        }
        if (ClassName != null && !ome.getOriginClass().equalsIgnoreCase(ClassName) || !ome.getName().equalsIgnoreCase(MethodName)) {
            throw new CIMMethodException("METHOD_OVERRIDDEN", (Object)(me.getOriginClass() + "." + me.getName()), (Object)fullName, (Object)(ome.getOriginClass() + "." + ome.getName()));
        }
        String tempom = (String)overrideMap.get(ome.getOriginClass() + "." + ome.getName());
        if (tempom != null) {
            throw new CIMMethodException("METHOD_OVERRIDDEN", (Object)(me.getOriginClass() + "." + me.getName()), (Object)(ome.getOriginClass() + "." + ome.getName()), (Object)tempom);
        }
        this.cu.assignInheritedQualifiers(me.getQualifiers(), ome.getQualifiers());
        overrideMap.put(ome.getOriginClass() + "." + ome.getName(), me.getOriginClass() + "." + me.getName());
    }

    private void handleMethodParameters(String namespace, CIMClass cc, CIMMethod me) throws CIMException {
        String lcns = namespace.toLowerCase();
        Vector pt = me.getParameters();
        Enumeration pes = pt.elements();
        while (pes.hasMoreElements()) {
            CIMParameter pe = (CIMParameter)pes.nextElement();
            Vector qt = pe.getQualifiers();
            this.cu.doCommonQualifierChecks(namespace, me.getOriginClass() + "." + me.getName() + ":" + pe.getName(), qt, CIMScope.getScope((int)7));
        }
    }

    void checkMethodsSanity(String namespace, CIMClass cc, CIMClass superclass) throws CIMException {
        String lcns = namespace.toLowerCase();
        Vector mt = cc.getMethods();
        Hashtable overrideMap = new Hashtable();
        Hashtable<String, String> methodNames = new Hashtable<String, String>();
        Enumeration mes = mt.elements();
        while (mes.hasMoreElements()) {
            CIMMethod me = (CIMMethod)mes.nextElement();
            me.setOriginClass(cc.getName());
            if (methodNames.get(me.getName().toLowerCase()) != null) {
                throw new CIMMethodException("CIM_ERR_INVALID_PARAMETER", (Object)me.getName());
            }
            methodNames.put(me.getName().toLowerCase(), "");
            Vector qt = me.getQualifiers();
            this.cu.doCommonQualifierChecks(namespace, me.getOriginClass() + "." + me.getName(), qt, CIMScope.getScope((int)6));
            this.handleMethodParameters(namespace, cc, me);
            this.handleMethodOverride(namespace, cc, me, overrideMap, superclass);
        }
        this.assignInheritedMethods(namespace, cc, overrideMap, superclass);
    }
}

