/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.CIMOMLogService;
import com.sun.wbem.cimom.ProviderClient;
import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.UnregHandler;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMInstanceException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.Debug;

class MofregClient
extends ProviderClient {
    private int mode;
    private UnregHandler uh;
    private boolean mustLog = true;

    private void logException(Exception e) {
        CIMOMLogService ls = (CIMOMLogService)ServiceRegistry.getService("logservice");
        if (ls == null) {
            return;
        }
        try {
            ls.writeLog("Mofreg", "MOFREG_ERROR", "MOFREG_ERROR", null, e.toString(), false, 2, 1, null);
        }
        catch (Exception le) {
            Debug.trace2((String)"logging error", (Throwable)le);
        }
    }

    public MofregClient(CIMOMImpl cimom, int mode, UnregHandler uh) throws CIMException {
        super(cimom, new CIMNameSpace("", ""));
        this.mode = mode;
        this.uh = uh;
        if (uh == null) {
            this.mustLog = false;
        }
    }

    public void createNameSpace(CIMNameSpace ns) throws CIMException {
        super.createNameSpace(ns);
    }

    public void deleteNameSpace(CIMNameSpace ns) throws CIMException {
        super.createNameSpace(ns);
    }

    public void deleteClass(CIMObjectPath path) throws CIMException {
        Debug.trace3((String)"In mofreg client deleteclass");
        this.cimom.intMofregRemoveClass(this.nameSpace, path);
    }

    public void deleteInstance(CIMObjectPath path) throws CIMException {
        Debug.trace3((String)"In mofreg client deleteinstance");
        CIMInstance oldci = null;
        Debug.trace3((String)("path for delete is " + path));
        CIMClass cc = super.getClass(path, false);
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(path.getKeys());
        this.cimom.checkInstanceSanity(path.getNameSpace(), nci, cc);
        path.setKeys(nci.getKeyValuePairs());
        oldci = super.getInstance(path, false);
        if (oldci == null) {
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)path.toString());
        }
        this.cimom.intdeleteInstance(this.nameSpace, path, true);
        if (this.mustLog) {
            CIMObjectPath ns = new CIMObjectPath();
            ns.setNameSpace(path.getNameSpace());
            ns.setObjectName(path.getObjectName());
            this.uh.deleteInstance(ns, oldci);
        }
    }

    public void createQualifierType(CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        super.createQualifierType(name, qt);
    }

    public void setClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        CIMClass oldcc = null;
        try {
            CIMObjectPath tname = new CIMObjectPath();
            tname.setNameSpace(name.getNameSpace());
            tname.setObjectName(cc.getName());
            Debug.trace3((String)("Trying to get old class " + tname));
            oldcc = super.getClass(tname, true);
        }
        catch (CIMException e) {
            if (e.getID().equals("CIM_ERR_NOT_FOUND")) {
                this.logException((Exception)((Object)e));
                return;
            }
            throw e;
        }
        Debug.trace3((String)("The old class is " + oldcc));
        this.cimom.intModifyClass(this.nameSpace, name, cc);
        if (this.mustLog) {
            this.uh.setClass(name, oldcc, cc);
        }
    }

    public void createClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            super.createClass(name, cc);
        }
        catch (CIMException e) {
            if (e.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                this.logException((Exception)((Object)e));
                return;
            }
            throw e;
        }
        if (this.mustLog) {
            this.uh.createClass(name, cc);
        }
    }

    public void setInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        Debug.trace3((String)"In mofreg client setinstance");
        CIMInstance oldci = null;
        CIMObjectPath path = new CIMObjectPath();
        path.setObjectName(ci.getClassName());
        path.setNameSpace(name.getNameSpace());
        CIMClass cc = super.getClass(path, false);
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(ci.getProperties());
        this.cimom.checkInstanceSanity(path.getNameSpace(), nci, cc);
        path.setKeys(nci.getKeyValuePairs());
        oldci = super.getInstance(path, false);
        if (oldci == null) {
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)path.toString());
        }
        this.cimom.intsetCIMElement(this.nameSpace, name, ci, true, true, null, true);
        if (this.mustLog) {
            CIMObjectPath ns = new CIMObjectPath();
            ns.setNameSpace(name.getNameSpace());
            ns.setObjectName(name.getObjectName());
            this.uh.setInstance(ns, oldci, ci);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        CIMObjectPath op = super.createInstance(name, ci);
        if (op != null) {
            ci = super.getInstance(name, false);
        }
        if (this.mustLog) {
            this.uh.createInstance(name, ci);
        }
        return op;
    }
}

