/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.CIMOMLogService;
import com.sun.wbem.cimom.MofregClient;
import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.UnregHandler;
import com.sun.wbem.compiler.mofc.CIM_Mofc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;

class Mofregistry {
    private static final String UNREGSUFFIX = ".unreg";
    String parentDir;
    String regDirParent;
    String unregDirParent;
    String failDirParent;
    String preRegDirParent;
    String preUnregDirParent;
    private static Mofregistry mofreg = null;
    private CIMOMImpl cimom;

    private Mofregistry(CIMOMImpl cimom, String parentDir, String regDir, String unregDir, String failDir, String preRegDir, String preUnregDir) throws IOException {
        this.parentDir = parentDir;
        this.regDirParent = parentDir + File.separatorChar + regDir;
        this.unregDirParent = parentDir + File.separatorChar + unregDir;
        this.failDirParent = parentDir + File.separatorChar + failDir;
        this.preRegDirParent = parentDir + File.separatorChar + preRegDir;
        this.preUnregDirParent = parentDir + File.separatorChar + preUnregDir;
        File f = new File(this.failDirParent);
        f.mkdirs();
        f = new File(this.regDirParent);
        f.mkdirs();
        f = new File(this.unregDirParent);
        f.mkdirs();
        f = new File(this.preRegDirParent);
        f.mkdirs();
        f = new File(this.preUnregDirParent);
        f.mkdirs();
        this.cimom = cimom;
    }

    static synchronized Mofregistry getMofregistry(CIMOMImpl cimom, String parentDir, String regDir, String unregDir, String failDir, String preRegDir, String preUnregDir) throws IOException {
        if (mofreg == null) {
            mofreg = new Mofregistry(cimom, parentDir, regDir, unregDir, failDir, preRegDir, preUnregDir);
        }
        return mofreg;
    }

    void logException(Exception e) {
        Debug.trace2((String)"Got a mofreg error", (Throwable)e);
        CIMOMLogService ls = (CIMOMLogService)ServiceRegistry.getService("logservice");
        if (ls == null) {
            return;
        }
        try {
            ls.writeLog("Mofreg", "MOFREG_ERROR", "MOFREG_ERROR", null, e.toString(), false, 2, 2, null);
        }
        catch (Exception le) {
            Debug.trace2((String)"logging error", (Throwable)le);
        }
    }

    void doRegistry(File regDir) throws Exception {
        File[] fArray = regDir.listFiles();
        if (fArray.length == 0) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)(regDir + ".reg"));
        }
        OutputStream fos = null;
        String regDirName = regDir.getName();
        try {
            int mode = 1;
            String unregDirString = this.unregDirParent + File.separatorChar + regDirName;
            File unregDir = new File(unregDirString);
            if (unregDir.exists()) {
                Debug.trace2((String)(unregDir + " already exists"));
                String failDirBackupString = this.failDirParent + File.separatorChar + regDirName + File.separatorChar + "reg";
                File failDirBackup = new File(failDirBackupString);
                Debug.trace3((String)("Cleaning up old backup if any " + failDirBackupString));
                this.recursiveDelete(failDirBackup);
                failDirBackup.mkdirs();
                regDir.renameTo(failDirBackup);
                return;
            }
            unregDir.mkdir();
            String regDirBackupString = unregDirString + File.separatorChar + regDirName;
            fos = new FileOutputStream(regDirBackupString + UNREGSUFFIX);
            Debug.trace3((String)("The input file is " + fArray[0]));
            Debug.trace3((String)("The output file is " + regDirBackupString + UNREGSUFFIX));
            UnregHandler uh = new UnregHandler(fos);
            CIM_Mofc.parseMOF((String[])new String[]{"-v", fArray[0].getPath()}, (int)mode, (CIMOMHandle)new MofregClient(this.cimom, mode, uh));
            uh.outputUnreg();
            fos.close();
            Debug.trace3((String)("Cleaning up old backup if any " + regDirBackupString));
            File regDirBackup = new File(regDirBackupString);
            this.recursiveDelete(regDirBackup);
            regDir.renameTo(regDirBackup);
        }
        catch (Exception e) {
            this.logException(e);
            String failDirBackupString = this.failDirParent + File.separatorChar + regDirName + File.separatorChar + "reg";
            File failDirBackup = new File(failDirBackupString);
            Debug.trace3((String)("Cleaning up old backup if any " + failDirBackupString));
            this.recursiveDelete(failDirBackup);
            if (fos != null) {
                fos.close();
            }
            File unregDir = new File(this.unregDirParent + File.separatorChar + regDirName);
            Debug.trace3((String)("Recursively deleting unreg " + unregDir));
            if (unregDir.exists()) {
                this.recursiveDelete(unregDir);
            }
            failDirBackup.mkdirs();
            regDir.renameTo(failDirBackup);
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void recursiveDelete(File dir) {
        if (!dir.isDirectory()) {
            Debug.trace3((String)("rec: Deleting file " + dir));
            dir.delete();
        } else {
            File[] fArray = dir.listFiles();
            for (int i = 0; i < fArray.length; ++i) {
                this.recursiveDelete(fArray[i]);
            }
            Debug.trace3((String)("rec: Deleting dir " + dir));
            dir.delete();
        }
    }

    void doUnregistry(File unregDir) throws Exception {
        File unregFile;
        String regDirName = unregDir.getName();
        String unregDirString = this.unregDirParent + File.separatorChar + regDirName;
        File regInfo = new File(unregDirString);
        if (!regInfo.exists()) {
            Debug.trace2((String)(unregDir + " not registered"));
            String failDirBackupString = this.failDirParent + File.separatorChar + regDirName + File.separatorChar + "unreg";
            File failDirBackup = new File(failDirBackupString);
            Debug.trace3((String)("Cleaning up old backup if any " + failDirBackupString));
            this.recursiveDelete(failDirBackup);
            failDirBackup.mkdirs();
            unregDir.renameTo(failDirBackup);
            return;
        }
        File[] fArray = unregDir.listFiles();
        if (fArray.length == 0) {
            String unregFileName = unregDirString + File.separatorChar + regDirName + UNREGSUFFIX;
            unregFile = new File(unregFileName);
        } else {
            unregFile = fArray[0];
        }
        try {
            int mode = 2;
            Debug.trace3((String)"Parsing testunreg.mof");
            CIM_Mofc.parseMOF((String[])new String[]{"-v", unregFile.getPath()}, (int)mode, (CIMOMHandle)new MofregClient(this.cimom, mode, null));
            Debug.trace3((String)("Cleaning up reg info for " + regInfo));
            this.recursiveDelete(regInfo);
            Debug.trace3((String)("Removing " + unregDir));
            this.recursiveDelete(unregDir);
        }
        catch (Exception e) {
            this.logException(e);
            String failDirBackupString = this.failDirParent + File.separatorChar + regDirName + File.separatorChar + "unreg";
            Debug.trace3((String)("Failed - renaming to " + failDirBackupString));
            File failDirBackup = new File(failDirBackupString);
            Debug.trace3((String)("Cleaning up old backup if any " + failDirBackupString));
            this.recursiveDelete(failDirBackup);
            failDirBackup.mkdirs();
            unregDir.renameTo(failDirBackup);
            Debug.trace3((String)("Cleaning up reg info for " + regInfo));
            this.recursiveDelete(regInfo);
            unregFile.renameTo(new File(failDirBackupString + unregFile.getName()));
        }
    }

    private List getSortedFileList(File dir1, File dir2) {
        int i;
        File[] fArray = dir1.listFiles();
        ArrayList<File> fList = new ArrayList<File>();
        for (i = 0; i < fArray.length; ++i) {
            fList.add(fArray[i]);
        }
        if (dir2 != null) {
            fArray = dir2.listFiles();
            for (i = 0; i < fArray.length; ++i) {
                fList.add(fArray[i]);
            }
        }
        Collections.sort(fList, new Comparator(){

            public int compare(Object fin1, Object fin2) {
                long f2lm;
                File f1 = (File)fin1;
                File f2 = (File)fin2;
                long f1lm = f1.lastModified();
                if (f1lm > (f2lm = f2.lastModified())) {
                    return 1;
                }
                if (f1lm < f2lm) {
                    return -1;
                }
                return 0;
            }
        });
        return fList;
    }

    synchronized void mofReg() throws Exception {
        Debug.trace3((String)("Looking for reg info in " + this.preRegDirParent + " and " + this.preUnregDirParent));
        File preRegDirP = new File(this.preRegDirParent);
        File preUnregDirP = new File(this.preUnregDirParent);
        List fl = this.getSortedFileList(preRegDirP, preUnregDirP);
        Iterator i = fl.iterator();
        Debug.trace3((String)"Processing pre reg entries");
        while (i.hasNext()) {
            File dirEntry = (File)i.next();
            if (dirEntry.getName().endsWith(UNREGSUFFIX)) {
                this.recursiveDelete(dirEntry);
                continue;
            }
            if (dirEntry.getParentFile().equals(preRegDirP)) {
                Debug.trace3((String)("Handling preReg for " + dirEntry));
                try {
                    this.doRegistry(dirEntry);
                }
                catch (Exception e) {
                    Debug.trace1((String)("Registry " + dirEntry + " failed"), (Throwable)e);
                    this.logException(e);
                }
                continue;
            }
            Debug.trace3((String)("Handling preUnReg for " + dirEntry));
            try {
                this.doUnregistry(dirEntry);
            }
            catch (Exception e) {
                Debug.trace1((String)("UnRegistry " + dirEntry + " failed"), (Throwable)e);
                this.logException(e);
            }
        }
        Debug.trace3((String)"Done Processing reg/unreg entries");
    }
}

