/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import javax.wbem.cim.CIMException;

class ReadersWriters {
    private String name;
    private int turn = 0;
    private int currentTurn = 0;
    private int numReaders = 0;
    private int numWriters = 0;
    private ThreadLocal tl = new ThreadLocal();
    private int count = 0;

    private boolean checkThreadStart(boolean writer) throws CIMException {
        RWEntry rwe = (RWEntry)this.tl.get();
        if (rwe != null) {
            if (writer && !rwe.writer) {
                throw new CIMException("CIM_ERR_FAILED", (Object)"Reader cant become writer");
            }
            ++rwe.numLocks;
            return true;
        }
        rwe = new RWEntry();
        rwe.writer = writer;
        rwe.count = this.count++;
        this.tl.set(rwe);
        return false;
    }

    private boolean checkThreadStop() throws CIMException {
        RWEntry rwe = (RWEntry)this.tl.get();
        if (rwe != null) {
            --rwe.numLocks;
            if (rwe.numLocks == 0) {
                this.tl.set(null);
                return false;
            }
            return true;
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)"Thread not active!");
    }

    public ReadersWriters(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startRead() throws CIMException {
        if (this.checkThreadStart(false)) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            int myturn = this.turn++;
            while (myturn != this.currentTurn) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.currentTurn;
            this.notifyAll();
            ++this.numReaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWrite() throws CIMException {
        if (this.checkThreadStart(true)) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            int myturn = this.turn++;
            while (myturn != this.currentTurn || this.numReaders != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.numWriters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRead() throws CIMException {
        if (this.checkThreadStop()) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            --this.numReaders;
            if (this.numReaders == 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWrite() throws CIMException {
        if (this.checkThreadStop()) {
            return;
        }
        ReadersWriters readersWriters = this;
        synchronized (readersWriters) {
            --this.numWriters;
            ++this.currentTurn;
            this.notifyAll();
        }
    }

    private class RWEntry {
        int count = 0;
        int numLocks = 1;
        boolean writer = false;

        private RWEntry() {
        }
    }
}

