/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.http;

import com.sun.wbem.cimom.CommonServerSecurityContext;
import com.sun.wbem.cimom.EventService;
import com.sun.xml.parser.Parser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMExport;
import javax.wbem.client.CIMExportIndication;
import javax.wbem.client.adapter.http.transport.HttpClientConnection;
import javax.wbem.client.adapter.http.transport.HttpClientSocketFactory;
import javax.wbem.client.adapter.http.transport.HttpSocketFactory;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class HttpIndicationHandler
implements EventService.IndicationHandler {
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private static boolean useMPost = true;
    private Map connMap = new HashMap();
    private CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();
    private boolean debug = false;
    private String prefix = "";

    public CommonServerSecurityContext getSecurityContext(CIMInstance handlerInstance) {
        return null;
    }

    public void deliverEvent(CIMEvent e, CIMInstance handlerInstance) throws CIMException {
        URL dest = null;
        try {
            XmlDocument request = this.xmlImpl.getXmlRequest((CIMExport)new CIMExportIndication(e.getIndication()));
            dest = new URL((String)handlerInstance.getProperty("Destination").getValue().getValue());
            this.deliverEventRequest(request, dest);
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ex);
        }
    }

    private synchronized void deliverEventRequest(XmlDocument request, URL url) throws CIMException, IOException {
        OutputStreamWriter out = null;
        String host = url.getHost();
        int port = url.getPort();
        HttpSocketFactory factory = new HttpSocketFactory(url.getProtocol());
        OutboundRequest outRequest = null;
        String key = host + ":" + port;
        HttpClientConnection conn = (HttpClientConnection)this.connMap.get(key);
        for (int i = 0; i < 2; ++i) {
            try {
                if (conn == null) {
                    conn = new HttpClientConnection(host, port, (HttpClientSocketFactory)factory, useMPost);
                    this.connMap.put(key, conn);
                }
                outRequest = conn.newRequest(url.getPath());
                out = new OutputStreamWriter(outRequest.getRequestOutputStream(), "UTF8");
                this.setRequestHeaders(outRequest, this.xmlImpl.getXmlRequestHeaders(request));
                outRequest.endWriteHeader();
                request.write((Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
                break;
            }
            catch (IOException e) {
                conn.shutdown(true);
                conn = null;
                this.connMap.put(key, conn);
                if (i != 1) continue;
                throw e;
            }
        }
        try {
            if (this.debug) {
                this.dumpRequest(request, outRequest);
            }
            XmlDocument resp = this.getResponse(outRequest);
            if (this.debug) {
                this.dumpResponse(resp, outRequest);
            }
        }
        catch (SAXException e) {
            if (useMPost) {
                if (conn != null) {
                    conn.shutdown(true);
                    conn = null;
                    this.connMap.put(key, conn);
                }
                useMPost = false;
                this.deliverEventRequest(request, url);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    public void ping(CIMInstance handlerInstance) throws CIMException {
    }

    private void dumpRequest(XmlDocument request, OutboundRequest outRequest) throws IOException {
        System.out.println("****************************************");
        outRequest.dumpOutHeader();
        if (request != null) {
            request.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF REQUEST  =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private void dumpResponse(XmlDocument response, OutboundRequest outRequest) throws IOException {
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
        outRequest.dumpInHeader();
        System.out.println("\n");
        if (response != null) {
            response.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF RESPONSE =-=-=-=-=-=-=-=-=-=-=-=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument getResponse(OutboundRequest outRequest) throws IOException, SAXException {
        InputStream contentInput = outRequest.getResponseInputStream();
        try {
            XmlDocument xmlD;
            Parser parser = new Parser();
            XmlDocumentBuilder builder = new XmlDocumentBuilder();
            InputSource in = new InputSource();
            builder.setDisableNamespaces(false);
            parser.setDocumentHandler((DocumentHandler)builder);
            in.setByteStream(contentInput);
            parser.parse(in);
            if (outRequest.getResponseCode() >= 400) {
                throw new IOException();
            }
            XmlDocument xmlDocument = xmlD = builder.getDocument();
            return xmlDocument;
        }
        finally {
            contentInput.close();
        }
    }

    private void setRequestHeaders(OutboundRequest outRequest, Map headers) throws CIMException {
        if (useMPost) {
            this.setPrefix();
            outRequest.addHeaderField("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        } else {
            this.prefix = "";
        }
        for (Map.Entry entry : headers.entrySet()) {
            outRequest.addHeaderField(this.prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setPrefix() {
        Random generator = new Random();
        int rand = Math.abs(generator.nextInt() % 100);
        this.prefix = Integer.toString(rand);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }
}

