/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.audit;

import com.sun.wbem.cimom.ServerSecurity;
import com.sun.wbem.cimom.audit.WbemAuditService;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;

public class WbemAuditServiceImpl
implements WbemAuditService {
    private static WbemAuditServiceImpl wbemAuditService = null;
    private CIMOMHandle mCimomHandle = null;
    private Class auditSessionClass = null;

    private WbemAuditServiceImpl(CIMOMHandle pCimomHandle) {
        this.mCimomHandle = pCimomHandle;
    }

    public static synchronized WbemAuditServiceImpl getInstance(CIMOMHandle chandle) {
        if (wbemAuditService == null) {
            wbemAuditService = new WbemAuditServiceImpl(chandle);
        }
        return wbemAuditService;
    }

    public synchronized WbemAuditSession getAuditSession() {
        if (this.auditSessionClass == null) {
            this.getWbemAuditSessionClass();
        }
        try {
            WbemAuditSession auditSession = ServerSecurity.getThreadAuditSession();
            if (auditSession == null && this.auditSessionClass != null) {
                auditSession = (WbemAuditSession)this.auditSessionClass.newInstance();
            }
            return auditSession;
        }
        catch (Exception ex) {
            Debug.trace3((String)"WbemAuditServiceImpl::getAuditSession() : getThreadAuditSession() threw exception.", (Throwable)ex);
            return null;
        }
    }

    private String getWbemAuditSessionPath() {
        String aslibpath = null;
        try {
            String pdpath = System.getProperty("propdir");
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(pdpath + "/cimom.properties"));
            Properties p = new Properties();
            p.load(bin);
            aslibpath = p.getProperty("com.sun.wbem.cimom.audit.auditsession");
            if (aslibpath == null) {
                aslibpath = "com.sun.wbem.cimom.audit.WbemAuditSessionImpl";
                Debug.trace3((String)"WbemAuditSession defaulting to class com.sun.wbem.cimom.audit.WbemAuditSessionImpl");
            }
        }
        catch (Exception ex) {
            Debug.trace1((String)"Failed to get property WbemAuditSession.AUDIT_SESSION_PROV_PROP", (Throwable)ex);
        }
        return aslibpath;
    }

    private void getWbemAuditSessionClass() {
        String auditSessionPath = this.getWbemAuditSessionPath();
        if (auditSessionPath == null) {
            return;
        }
        try {
            this.auditSessionClass = Class.forName(auditSessionPath);
        }
        catch (Exception e) {
            this.auditSessionClass = null;
            Debug.trace1((String)("Could not get audit session class " + auditSessionPath), (Throwable)e);
        }
    }
}

